/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.resources;

import com.android.annotations.NonNull;
import com.android.builder.resources.DataItem;
import com.android.builder.resources.NodeUtils;
import com.android.builder.resources.ResourceFile;
import com.android.resources.ResourceType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class ResourceItem
extends DataItem<ResourceFile> {
    private static final String ATTR_TYPE = "type";
    private final ResourceType mType;
    private Node mValue;

    ResourceItem(@NonNull String name, @NonNull ResourceType type, Node value) {
        super(name);
        this.mType = type;
        this.mValue = value;
    }

    @NonNull
    public ResourceType getType() {
        return this.mType;
    }

    public Node getValue() {
        return this.mValue;
    }

    void setValue(ResourceItem from) {
        this.mValue = from.mValue;
        this.setTouched();
    }

    @Override
    String getKey() {
        if (this.getSource() == null) {
            throw new IllegalStateException("ResourceItem.getKey called on object with no ResourceFile: " + this);
        }
        String qualifiers = ((ResourceFile)this.getSource()).getQualifiers();
        if (qualifiers != null && qualifiers.length() > 0) {
            return this.mType.getName() + "-" + qualifiers + "/" + this.getName();
        }
        return this.mType.getName() + "/" + this.getName();
    }

    @Override
    void addExtraAttributes(Document document, Node node, String namespaceUri) {
        NodeUtils.addAttribute(document, node, null, ATTR_TYPE, this.mType.getName());
    }

    @Override
    Node getAdoptedNode(Document document) {
        return NodeUtils.adoptNode(document, this.mValue);
    }

    public boolean compareValueWith(ResourceItem resource) {
        if (this.mValue != null && resource.mValue != null) {
            return NodeUtils.compareElementNode(this.mValue, resource.mValue);
        }
        return this.mValue == resource.mValue;
    }

    public String toString() {
        return "ResourceItem{mName='" + this.getName() + '\'' + ", mType=" + (Object)((Object)this.mType) + ", mStatus=" + this.getStatus() + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceItem that = (ResourceItem)o;
        return this.mType == that.mType;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mType.hashCode();
        return result;
    }
}

