/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.resources;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.AaptRunner;
import com.android.builder.internal.util.concurrent.WaitableExecutor;
import com.android.builder.resources.DataFile;
import com.android.builder.resources.DataMerger;
import com.android.builder.resources.DuplicateDataException;
import com.android.builder.resources.NodeUtils;
import com.android.builder.resources.ResourceFile;
import com.android.builder.resources.ResourceItem;
import com.android.builder.resources.ResourceSet;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.resources.ResourceFolderType;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResourceMerger
extends DataMerger<ResourceItem, ResourceFile, ResourceSet> {
    private static final String FN_VALUES_XML = "values.xml";
    private AaptRunner mAaptRunner;
    private ListMultimap<String, ResourceItem> mValuesResMap;
    private Set<String> mQualifierWithDeletedValues;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDataFolder(@NonNull File rootFolder, @Nullable AaptRunner aaptRunner) throws IOException, DuplicateDataException, ExecutionException, InterruptedException {
        this.mAaptRunner = aaptRunner;
        this.mValuesResMap = ArrayListMultimap.create();
        this.mQualifierWithDeletedValues = Sets.newHashSet();
        try {
            super.writeDataFolder(rootFolder);
        }
        finally {
            this.mAaptRunner = null;
            this.mValuesResMap = null;
            this.mQualifierWithDeletedValues = null;
        }
    }

    @Override
    protected void writeItem(final @NonNull File rootFolder, final @NonNull ResourceItem item, @NonNull WaitableExecutor executor) throws IOException {
        DataFile.FileType type = ((ResourceFile)item.getSource()).getType();
        if (type == DataFile.FileType.MULTI) {
            String qualifier = ((ResourceFile)item.getSource()).getQualifiers();
            if (qualifier == null) {
                qualifier = "";
            }
            this.mValuesResMap.put(qualifier, item);
        } else if (item.isTouched()) {
            executor.execute(new Callable(){

                public Object call() throws Exception {
                    ResourceFile resourceFile = (ResourceFile)item.getSource();
                    File file = resourceFile.getFile();
                    String filename = file.getName();
                    String folderName = item.getType().getName();
                    String qualifiers = resourceFile.getQualifiers();
                    if (qualifiers != null && qualifiers.length() > 0) {
                        folderName = folderName + "-" + qualifiers;
                    }
                    File typeFolder = new File(rootFolder, folderName);
                    ResourceMerger.this.createDir(typeFolder);
                    File outFile = new File(typeFolder, filename);
                    if (ResourceMerger.this.mAaptRunner != null && filename.endsWith(".9.png")) {
                        ResourceMerger.this.mAaptRunner.crunchPng(file, outFile);
                    } else {
                        Files.copy(file, outFile);
                    }
                    return null;
                }
            });
        }
    }

    @Override
    protected void removeItem(File rootFolder, ResourceItem removedItem, ResourceItem replacedBy) {
        DataFile.FileType replacedType;
        DataFile.FileType removedType = ((ResourceFile)removedItem.getSource()).getType();
        DataFile.FileType fileType = replacedType = replacedBy != null ? ((ResourceFile)replacedBy.getSource()).getType() : null;
        if (removedType == replacedType) {
            if (removedType == DataFile.FileType.MULTI) {
                this.mQualifierWithDeletedValues.add(((ResourceFile)removedItem.getSource()).getQualifiers());
            }
        } else if (removedType == DataFile.FileType.SINGLE) {
            ResourceMerger.removeOutFile(rootFolder, (ResourceFile)removedItem.getSource());
        } else {
            this.mQualifierWithDeletedValues.add(((ResourceFile)removedItem.getSource()).getQualifiers());
        }
    }

    private static boolean removeOutFile(File outFolder, ResourceFile resourceFile) {
        if (resourceFile.getType() == DataFile.FileType.MULTI) {
            throw new IllegalArgumentException("SourceFile cannot be a FileType.MULTI");
        }
        File file = resourceFile.getFile();
        String fileName = file.getName();
        String folderName = file.getParentFile().getName();
        return ResourceMerger.removeOutFile(outFolder, folderName, fileName);
    }

    private static boolean removeOutFile(File outFolder, String folderName, String fileName) {
        File valuesFolder = new File(outFolder, folderName);
        File outFile = new File(valuesFolder, fileName);
        return outFile.delete();
    }

    @Override
    protected void postWriteDataFolder(File rootFolder) throws IOException {
        for (String key : this.mValuesResMap.keySet()) {
            boolean mustWriteFile = this.mQualifierWithDeletedValues.remove(key);
            List<ResourceItem> items = this.mValuesResMap.get(key);
            if (!mustWriteFile) {
                for (ResourceItem item : items) {
                    if (!item.isTouched()) continue;
                    mustWriteFile = true;
                    break;
                }
            }
            if (!mustWriteFile) continue;
            String folderName = key.length() > 0 ? ResourceFolderType.VALUES.getName() + "-" + key : ResourceFolderType.VALUES.getName();
            File valuesFolder = new File(rootFolder, folderName);
            this.createDir(valuesFolder);
            File outFile = new File(valuesFolder, FN_VALUES_XML);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                Element rootNode = document.createElement("resources");
                document.appendChild(rootNode);
                for (ResourceItem item : items) {
                    Node adoptedNode = NodeUtils.adoptNode(document, item.getValue());
                    rootNode.appendChild(adoptedNode);
                }
                String content = XmlPrettyPrinter.prettyPrint(document);
                Files.write(content, outFile, Charsets.UTF_8);
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e);
            }
        }
        for (String key : this.mQualifierWithDeletedValues) {
            String folderName = key != null && key.length() > 0 ? ResourceFolderType.VALUES.getName() + "-" + key : ResourceFolderType.VALUES.getName();
            ResourceMerger.removeOutFile(rootFolder, folderName, FN_VALUES_XML);
        }
    }

    @Override
    protected ResourceSet createFromXml(Node node) {
        ResourceSet set = new ResourceSet("");
        return (ResourceSet)set.createFromXml(node);
    }

    @Override
    public void writeDataFolder(@NonNull File rootFolder) throws IOException, DuplicateDataException, ExecutionException, InterruptedException {
        throw new UnsupportedOperationException("Call writeDataFolder(File, AaptRunner) instead");
    }
}

