/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.resources;

import com.android.annotations.NonNull;
import com.android.builder.resources.ResourceItem;
import com.android.resources.ResourceType;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ValueResourceParser {
    private final File mFile;

    ValueResourceParser(File file) {
        this.mFile = file;
    }

    @NonNull
    List<ResourceItem> parseFile() throws IOException {
        Document document = ValueResourceParser.parseDocument(this.mFile);
        Element rootNode = document.getDocumentElement();
        if (rootNode == null) {
            return Collections.emptyList();
        }
        NodeList nodes = rootNode.getChildNodes();
        ArrayList<ResourceItem> resources = Lists.newArrayListWithExpectedSize(nodes.getLength());
        int n = nodes.getLength();
        for (int i = 0; i < n; ++i) {
            ResourceItem resource;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || (resource = ValueResourceParser.getResource(node)) == null) continue;
            resources.add(resource);
        }
        return resources;
    }

    static ResourceItem getResource(Node node) {
        ResourceType type = ValueResourceParser.getType(node);
        String name = ValueResourceParser.getName(node);
        if (type != null && name != null) {
            return new ResourceItem(name, type, node);
        }
        return null;
    }

    static ResourceType getType(Node node) {
        String nodeName = node.getLocalName();
        String typeString = null;
        if ("item".equals(nodeName)) {
            Attr attribute = (Attr)node.getAttributes().getNamedItemNS(null, "type");
            if (attribute != null) {
                typeString = attribute.getValue();
            }
        } else {
            typeString = nodeName;
        }
        if (typeString != null) {
            return ResourceType.getEnum(typeString);
        }
        return null;
    }

    static String getName(Node node) {
        Attr attribute = (Attr)node.getAttributes().getNamedItemNS(null, "name");
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    @NonNull
    static Document parseDocument(File file) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        InputSource is = new InputSource(stream);
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(is);
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        finally {
            Closeables.closeQuietly(stream);
        }
    }
}

