/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.log.LogReceiver;
import java.io.IOException;
import java.util.Map;

public interface IDevice {
    public static final String PROP_BUILD_VERSION = "ro.build.version.release";
    public static final String PROP_BUILD_API_LEVEL = "ro.build.version.sdk";
    public static final String PROP_BUILD_CODENAME = "ro.build.version.codename";
    public static final String PROP_DEVICE_MODEL = "ro.product.model";
    public static final String PROP_DEVICE_MANUFACTURER = "ro.product.manufacturer";
    public static final String PROP_DEBUGGABLE = "ro.debuggable";
    public static final String FIRST_EMULATOR_SN = "emulator-5554";
    public static final int CHANGE_STATE = 1;
    public static final int CHANGE_CLIENT_LIST = 2;
    public static final int CHANGE_BUILD_INFO = 4;
    @Deprecated
    public static final String PROP_BUILD_VERSION_NUMBER = "ro.build.version.sdk";
    public static final String MNT_EXTERNAL_STORAGE = "EXTERNAL_STORAGE";
    public static final String MNT_ROOT = "ANDROID_ROOT";
    public static final String MNT_DATA = "ANDROID_DATA";

    public String getSerialNumber();

    public String getAvdName();

    public String getName();

    public DeviceState getState();

    public Map<String, String> getProperties();

    public int getPropertyCount();

    public String getProperty(String var1);

    public boolean arePropertiesSet();

    public String getPropertySync(String var1) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException;

    public String getPropertyCacheOrSync(String var1) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException;

    public String getMountPoint(String var1);

    public boolean isOnline();

    public boolean isEmulator();

    public boolean isOffline();

    public boolean isBootLoader();

    public boolean hasClients();

    public Client[] getClients();

    public Client getClient(String var1);

    public SyncService getSyncService() throws TimeoutException, AdbCommandRejectedException, IOException;

    public FileListingService getFileListingService();

    public RawImage getScreenshot() throws TimeoutException, AdbCommandRejectedException, IOException;

    public void executeShellCommand(String var1, IShellOutputReceiver var2) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException;

    public void executeShellCommand(String var1, IShellOutputReceiver var2, int var3) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException;

    public void runEventLogService(LogReceiver var1) throws TimeoutException, AdbCommandRejectedException, IOException;

    public void runLogService(String var1, LogReceiver var2) throws TimeoutException, AdbCommandRejectedException, IOException;

    public void createForward(int var1, int var2) throws TimeoutException, AdbCommandRejectedException, IOException;

    public void createForward(int var1, String var2, DeviceUnixSocketNamespace var3) throws TimeoutException, AdbCommandRejectedException, IOException;

    public void removeForward(int var1, int var2) throws TimeoutException, AdbCommandRejectedException, IOException;

    public void removeForward(int var1, String var2, DeviceUnixSocketNamespace var3) throws TimeoutException, AdbCommandRejectedException, IOException;

    public String getClientName(int var1);

    public void pushFile(String var1, String var2) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException;

    public void pullFile(String var1, String var2) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException;

    public String installPackage(String var1, boolean var2, String ... var3) throws InstallException;

    public String syncPackageToDevice(String var1) throws TimeoutException, AdbCommandRejectedException, IOException, SyncException;

    public String installRemotePackage(String var1, boolean var2, String ... var3) throws InstallException;

    public void removeRemotePackage(String var1) throws InstallException;

    public String uninstallPackage(String var1) throws InstallException;

    public void reboot(String var1) throws TimeoutException, AdbCommandRejectedException, IOException;

    public Integer getBatteryLevel() throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException;

    public Integer getBatteryLevel(long var1) throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException;

    public static enum DeviceUnixSocketNamespace {
        ABSTRACT("localabstract"),
        FILESYSTEM("localfilesystem"),
        RESERVED("localreserved");

        private String mType;

        private DeviceUnixSocketNamespace(String type) {
            this.mType = type;
        }

        String getType() {
            return this.mType;
        }
    }

    public static enum DeviceState {
        BOOTLOADER("bootloader"),
        OFFLINE("offline"),
        ONLINE("device"),
        RECOVERY("recovery");

        private String mState;

        private DeviceState(String state) {
            this.mState = state;
        }

        public static DeviceState getState(String state) {
            for (DeviceState deviceState : DeviceState.values()) {
                if (!deviceState.mState.equals(state)) continue;
                return deviceState;
            }
            return null;
        }
    }
}

