/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering;

import com.android.annotations.NonNull;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;

public class HardwareConfigHelper {
    @NonNull
    private final Device mDevice;
    @NonNull
    private ScreenOrientation mScreenOrientation = ScreenOrientation.PORTRAIT;
    private int mMaxRenderWidth = -1;
    private int mMaxRenderHeight = -1;
    private int mOverrideRenderWidth = -1;
    private int mOverrideRenderHeight = -1;

    public HardwareConfigHelper(@NonNull Device device) {
        this.mDevice = device;
    }

    @NonNull
    public HardwareConfigHelper setOrientation(@NonNull ScreenOrientation screenOrientation) {
        this.mScreenOrientation = screenOrientation;
        return this;
    }

    @NonNull
    public HardwareConfigHelper setOverrideRenderSize(int overrideRenderWidth, int overrideRenderHeight) {
        this.mOverrideRenderWidth = overrideRenderWidth;
        this.mOverrideRenderHeight = overrideRenderHeight;
        return this;
    }

    @NonNull
    public HardwareConfigHelper setMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
        this.mMaxRenderWidth = maxRenderWidth;
        this.mMaxRenderHeight = maxRenderHeight;
        return this;
    }

    @NonNull
    public HardwareConfig getConfig() {
        int height;
        int width;
        int y;
        Screen screen = this.mDevice.getDefaultHardware().getScreen();
        int x = screen.getXDimension();
        if (x > (y = screen.getYDimension())) {
            if (this.mScreenOrientation == ScreenOrientation.LANDSCAPE) {
                width = x;
                height = y;
            } else {
                width = y;
                height = x;
            }
        } else if (this.mScreenOrientation == ScreenOrientation.LANDSCAPE) {
            width = y;
            height = x;
        } else {
            width = x;
            height = y;
        }
        if (this.mOverrideRenderHeight != -1) {
            width = this.mOverrideRenderWidth;
        }
        if (this.mOverrideRenderHeight != -1) {
            height = this.mOverrideRenderHeight;
        }
        if (this.mMaxRenderWidth != -1) {
            width = this.mMaxRenderWidth;
        }
        if (this.mMaxRenderHeight != -1) {
            height = this.mMaxRenderHeight;
        }
        return new HardwareConfig(width, height, screen.getPixelDensity(), (float)screen.getXdpi(), (float)screen.getYdpi(), screen.getSize(), this.mScreenOrientation, this.mDevice.getDefaultHardware().getButtonType() == ButtonType.SOFT);
    }
}

