/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.DeclareStyleableResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.resources.ResourceType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ValueResourceParser
extends DefaultHandler {
    private static final String NODE_RESOURCES = "resources";
    private static final String NODE_ITEM = "item";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_PARENT = "parent";
    private static final String ATTR_VALUE = "value";
    private static final String DEFAULT_NS_PREFIX = "android:";
    private static final int DEFAULT_NS_PREFIX_LEN = "android:".length();
    private boolean inResources = false;
    private int mDepth = 0;
    private ResourceValue mCurrentValue = null;
    private StyleResourceValue mCurrentStyle = null;
    private DeclareStyleableResourceValue mCurrentDeclareStyleable = null;
    private AttrResourceValue mCurrentAttr;
    private IValueResourceRepository mRepository;
    private final boolean mIsFramework;

    public ValueResourceParser(IValueResourceRepository repository, boolean isFramework) {
        this.mRepository = repository;
        this.mIsFramework = isFramework;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.mCurrentValue != null) {
            this.mCurrentValue.setValue(ValueResourceParser.unescapeResourceString(this.mCurrentValue.getValue(), false, true));
        }
        if (this.inResources && qName.equals(NODE_RESOURCES)) {
            this.inResources = false;
        } else if (this.mDepth == 2) {
            this.mCurrentValue = null;
            this.mCurrentStyle = null;
            this.mCurrentDeclareStyleable = null;
            this.mCurrentAttr = null;
        } else if (this.mDepth == 3) {
            this.mCurrentValue = null;
            if (this.mCurrentDeclareStyleable != null) {
                this.mCurrentAttr = null;
            }
        }
        --this.mDepth;
        super.endElement(uri, localName, qName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            ++this.mDepth;
            if (!this.inResources && this.mDepth == 1) {
                if (qName.equals(NODE_RESOURCES)) {
                    this.inResources = true;
                }
            } else if (this.mDepth == 2 && this.inResources) {
                String name;
                ResourceType type = this.getType(qName, attributes);
                if (type != null && (name = attributes.getValue(ATTR_NAME)) != null) {
                    switch (type) {
                        case STYLE: {
                            String parent = attributes.getValue(ATTR_PARENT);
                            this.mCurrentStyle = new StyleResourceValue(type, name, parent, this.mIsFramework);
                            this.mRepository.addResourceValue(this.mCurrentStyle);
                            break;
                        }
                        case DECLARE_STYLEABLE: {
                            this.mCurrentDeclareStyleable = new DeclareStyleableResourceValue(type, name, this.mIsFramework);
                            this.mRepository.addResourceValue(this.mCurrentDeclareStyleable);
                            break;
                        }
                        case ATTR: {
                            this.mCurrentAttr = new AttrResourceValue(type, name, this.mIsFramework);
                            this.mRepository.addResourceValue(this.mCurrentAttr);
                            break;
                        }
                        default: {
                            this.mCurrentValue = new ResourceValue(type, name, this.mIsFramework);
                            this.mRepository.addResourceValue(this.mCurrentValue);
                        }
                    }
                }
            } else if (this.mDepth == 3) {
                String name = attributes.getValue(ATTR_NAME);
                if (name != null) {
                    if (this.mCurrentStyle != null) {
                        boolean isFrameworkAttr = this.mIsFramework;
                        if (name.startsWith(DEFAULT_NS_PREFIX)) {
                            name = name.substring(DEFAULT_NS_PREFIX_LEN);
                            isFrameworkAttr = true;
                        }
                        this.mCurrentValue = new ResourceValue(null, name, this.mIsFramework);
                        this.mCurrentStyle.addValue(this.mCurrentValue, isFrameworkAttr);
                    } else if (this.mCurrentDeclareStyleable != null) {
                        boolean isFramework = this.mIsFramework;
                        if (name.startsWith(DEFAULT_NS_PREFIX)) {
                            name = name.substring(DEFAULT_NS_PREFIX_LEN);
                            isFramework = true;
                        }
                        this.mCurrentAttr = new AttrResourceValue(ResourceType.ATTR, name, isFramework);
                        this.mCurrentDeclareStyleable.addValue(this.mCurrentAttr);
                        this.mRepository.addResourceValue(this.mCurrentAttr);
                    } else if (this.mCurrentAttr != null) {
                        String value = attributes.getValue(ATTR_VALUE);
                        try {
                            this.mCurrentAttr.addValue(name, (int)Long.decode(value).longValue());
                        }
                        catch (NumberFormatException e) {}
                    }
                }
            } else if (this.mDepth == 4 && this.mCurrentAttr != null) {
                String name = attributes.getValue(ATTR_NAME);
                String value = attributes.getValue(ATTR_VALUE);
                try {
                    this.mCurrentAttr.addValue(name, (int)Long.decode(value).longValue());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        finally {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    private ResourceType getType(String qName, Attributes attributes) {
        String typeValue = NODE_ITEM.equals(qName) ? attributes.getValue(ATTR_TYPE) : qName;
        ResourceType type = ResourceType.getEnum(typeValue);
        return type;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.mCurrentValue != null) {
            String value = this.mCurrentValue.getValue();
            if (value == null) {
                this.mCurrentValue.setValue(new String(ch, start, length));
            } else {
                this.mCurrentValue.setValue(value + new String(ch, start, length));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static String unescapeResourceString(@Nullable String s, boolean escapeEntities, boolean trim) {
        if (s == null) {
            return null;
        }
        n = s.length();
        if (trim) {
            for (i = 0; i < n && Character.isWhitespace(c = s.charAt(i)); ++i) {
            }
            while (n > i) {
                c = s.charAt(n - 1);
                if (!Character.isWhitespace(c)) {
                    if (n >= s.length() || !ValueResourceParser.isEscaped(s, n)) break;
                    ++n;
                    break;
                }
                --n;
            }
            quoteStart = i;
            quoteEnd = n;
            while (i < n && (c = s.charAt(i)) == '\"') {
                ++i;
            }
            while (n > i) {
                c = s.charAt(n - 1);
                if (c != '\"') {
                    if (n >= s.length() || !ValueResourceParser.isEscaped(s, n)) break;
                    ++n;
                    break;
                }
                --n;
            }
            if (n == i) {
                return "";
            }
            if (i == quoteStart) {
                while (i < n && Character.isWhitespace(c = s.charAt(i))) {
                    ++i;
                }
            }
            if (n == quoteEnd) {
                while (n > i) {
                    c = s.charAt(n - 1);
                    if (!Character.isWhitespace(c)) {
                        if (n >= s.length() || !ValueResourceParser.isEscaped(s, n)) break;
                        ++n;
                        break;
                    }
                    --n;
                }
            }
            if (n == i) {
                return "";
            }
        }
        if (!(i != 0 || n != s.length() || s.indexOf(92) != -1 || escapeEntities && s.indexOf(38) != -1)) {
            return s;
        }
        sb = new StringBuilder(n - i);
        while (i < n) {
            block30: {
                block29: {
                    c = s.charAt(i);
                    if (c != '\\' || i >= n - 1) break block29;
                    next = s.charAt(i + 1);
                    if (next == 'u' && i < n - 5) {
                        hex = s.substring(i + 2, i + 6);
                        try {
                            unicodeValue = Integer.parseInt(hex, 16);
                            sb.append((char)unicodeValue);
                            i += 5;
                        }
                        catch (NumberFormatException e) {
                            sb.append(c);
                        }
                    } else if (next == 'n') {
                        sb.append('\n');
                        ++i;
                    } else if (next == 't') {
                        sb.append('\t');
                        ++i;
                    } else {
                        sb.append(next);
                        ++i;
                    }
                    break block30;
                }
                if (c != '&' || !escapeEntities) ** GOTO lbl-1000
                if (s.regionMatches(true, i, "&lt;", 0, "&lt;".length())) {
                    sb.append('<');
                    i += "&lt;".length() - 1;
                } else if (s.regionMatches(true, i, "&amp;", 0, "&amp;".length())) {
                    sb.append('&');
                    i += "&amp;".length() - 1;
                } else lbl-1000:
                // 2 sources

                {
                    sb.append(c);
                }
            }
            ++i;
        }
        s = sb.toString();
        return s;
    }

    static boolean isEscaped(String s, int index) {
        int j;
        if (index == 0 || index == s.length()) {
            return false;
        }
        int prevPos = index - 1;
        char prev = s.charAt(prevPos);
        if (prev != '\\') {
            return false;
        }
        for (j = prevPos - 1; j >= 0 && s.charAt(j) == '\\'; --j) {
        }
        return (prevPos - j) % 2 == 1;
    }

    public static String escapeResourceString(String s) {
        boolean hasSpace;
        int n = s.length();
        if (n == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(s.length() * 2);
        boolean bl = hasSpace = s.charAt(0) == ' ' || s.charAt(n - 1) == ' ';
        if (hasSpace) {
            sb.append('\"');
        } else if (s.charAt(0) == '@' || s.charAt(0) == '?') {
            sb.append('\\');
        }
        block8: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\'': {
                    if (!hasSpace) {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block8;
                }
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block8;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block8;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (hasSpace) {
            sb.append('\"');
        }
        return sb.toString();
    }

    public static interface IValueResourceRepository {
        public void addResourceValue(ResourceValue var1);

        public boolean hasResourceValue(ResourceType var1, String var2);
    }
}

