/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.ArgvParser;
import com.android.manifmerger.ManifestMerger;
import com.android.manifmerger.MergerLog;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import java.io.File;

public class Main {
    private ILogger mSdkLog;
    private ArgvParser mArgvParser;

    public static void main(String[] args) {
        new Main().run(args);
    }

    private void run(String[] args) {
        this.createLogger();
        this.mArgvParser = new ArgvParser(this.mSdkLog);
        this.mArgvParser.parseArgs(args);
        ManifestMerger mm = new ManifestMerger(MergerLog.wrapSdkLog(this.mSdkLog), null);
        String[] libPaths = this.mArgvParser.getParamLibs();
        File[] libFiles = new File[libPaths.length];
        for (int n = libPaths.length - 1; n >= 0; --n) {
            libFiles[n] = new File(libPaths[n]);
        }
        boolean ok = mm.process(new File(this.mArgvParser.getParamOut()), new File(this.mArgvParser.getParamMain()), libFiles, null);
        System.exit(ok ? 0 : 1);
    }

    private void createLogger() {
        this.mSdkLog = new StdLogger(StdLogger.Level.VERBOSE);
    }

    public void setLogger(ILogger logger) {
        this.mSdkLog = logger;
    }
}

