/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.manifmerger.ICallback;
import com.android.manifmerger.IMergerLog;
import com.android.manifmerger.MergerXmlUtils;
import com.android.utils.XmlUtils;
import com.android.xml.AndroidXPathFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestMerger {
    private final IMergerLog mLog;
    private final ICallback mCallback;
    private XPath mXPath;
    private Document mMainDoc;
    private boolean mExtractPackagePrefix;
    private static final String NS_URI = "http://schemas.android.com/apk/res/android";
    private static final String NS_PREFIX = "android";
    private static final String TOOLS_URI = "http://schemas.android.com/tools";
    private static final String MERGE_ATTR = "merge";
    private static final String MERGE_OVERRIDE = "override";
    private static final String MERGE_REMOVE = "remove";
    private static final String[] sClassAttributes = new String[]{"application/name", "application/backupAgent", "activity/name", "activity-alias/name", "receiver/name", "service/name", "provider/name", "instrumentation/name"};

    public ManifestMerger(@NonNull IMergerLog log, @Nullable ICallback callback) {
        this.mLog = log;
        this.mCallback = callback;
    }

    public ManifestMerger setExtractPackagePrefix(boolean extract) {
        this.mExtractPackagePrefix = extract;
        return this;
    }

    public boolean process(File outputFile, File mainFile, File[] libraryFiles, Map<String, String> injectAttributes) {
        Document mainDoc = MergerXmlUtils.parseDocument(mainFile, this.mLog);
        if (mainDoc == null) {
            return false;
        }
        boolean success = this.process(mainDoc, libraryFiles, injectAttributes);
        if (!MergerXmlUtils.printXmlFile(mainDoc, outputFile, this.mLog)) {
            success = false;
        }
        return success;
    }

    public boolean process(Document mainDoc, File[] libraryFiles, Map<String, String> injectAttributes) {
        boolean success = true;
        this.mMainDoc = mainDoc;
        MergerXmlUtils.decorateDocument(mainDoc, "@main");
        MergerXmlUtils.injectAttributes(mainDoc, injectAttributes, this.mLog);
        String prefix = XmlUtils.lookupNamespacePrefix(mainDoc, NS_URI);
        this.mXPath = AndroidXPathFactory.newXPath(prefix);
        this.expandFqcns(mainDoc);
        for (File libFile : libraryFiles) {
            Document libDoc = MergerXmlUtils.parseDocument(libFile, this.mLog);
            if (libDoc != null && this.mergeLibDoc(this.cleanupToolsAttributes(libDoc))) continue;
            success = false;
        }
        this.cleanupToolsAttributes(mainDoc);
        if (this.mExtractPackagePrefix) {
            this.extractFqcns(mainDoc);
        }
        this.mXPath = null;
        this.mMainDoc = null;
        return success;
    }

    public boolean process(@NonNull Document mainDoc, Document ... libraryDocs) {
        boolean success = true;
        this.mMainDoc = mainDoc;
        MergerXmlUtils.decorateDocument(mainDoc, "@main");
        String prefix = XmlUtils.lookupNamespacePrefix(mainDoc, NS_URI);
        this.mXPath = AndroidXPathFactory.newXPath(prefix);
        this.expandFqcns(mainDoc);
        for (Document libDoc : libraryDocs) {
            MergerXmlUtils.decorateDocument(libDoc, "@library");
            if (this.mergeLibDoc(this.cleanupToolsAttributes(libDoc))) continue;
            success = false;
        }
        this.cleanupToolsAttributes(mainDoc);
        this.mXPath = null;
        this.mMainDoc = null;
        return success;
    }

    private boolean mergeLibDoc(Document libDoc) {
        boolean err = false;
        this.expandFqcns(libDoc);
        err |= !this.checkApplication(libDoc);
        err |= !this.doNotMergeCheckEqual("/manifest/uses-configuration", libDoc);
        err |= !this.doNotMergeCheckEqual("/manifest/supports-screens", libDoc);
        err |= !this.doNotMergeCheckEqual("/manifest/compatible-screens", libDoc);
        err |= !this.doNotMergeCheckEqual("/manifest/supports-gl-texture", libDoc);
        boolean skipApplication = this.hasOverrideOrRemoveTag(this.findFirstElement(this.mMainDoc, "/manifest/application"));
        if (!skipApplication) {
            err |= !this.mergeNewOrEqual("/manifest/application/activity", "name", libDoc, true);
            err |= !this.mergeNewOrEqual("/manifest/application/activity-alias", "name", libDoc, true);
            err |= !this.mergeNewOrEqual("/manifest/application/service", "name", libDoc, true);
            err |= !this.mergeNewOrEqual("/manifest/application/receiver", "name", libDoc, true);
            err |= !this.mergeNewOrEqual("/manifest/application/provider", "name", libDoc, true);
        }
        err |= !this.mergeNewOrEqual("/manifest/permission", "name", libDoc, false);
        err |= !this.mergeNewOrEqual("/manifest/permission-group", "name", libDoc, false);
        err |= !this.mergeNewOrEqual("/manifest/permission-tree", "name", libDoc, false);
        err |= !this.mergeNewOrEqual("/manifest/uses-permission", "name", libDoc, false);
        if (!skipApplication) {
            err |= !this.mergeAdjustRequired("/manifest/application/uses-library", "name", "required", libDoc, null);
            err |= !this.mergeNewOrEqual("/manifest/application/meta-data", "name", libDoc, true);
        }
        err |= !this.mergeAdjustRequired("/manifest/uses-feature", "name", "required", libDoc, "glEsVersion");
        err |= !this.checkSdkVersion(libDoc);
        return !(err |= !this.checkGlEsVersion(libDoc));
    }

    private void expandFqcns(Document doc) {
        String pkg = null;
        Element manifest = this.findFirstElement(doc, "/manifest");
        if (manifest != null) {
            pkg = manifest.getAttribute("package");
        }
        if (pkg == null || pkg.length() == 0) {
            assert (manifest != null);
            this.mLog.error(IMergerLog.Severity.WARNING, this.xmlFileAndLine(manifest), "Missing 'package' attribute in manifest.", new Object[0]);
            return;
        }
        for (String elementAttr : sClassAttributes) {
            String[] names = elementAttr.split("/");
            if (names.length != 2) continue;
            String elemName = names[0];
            String attrName = names[1];
            NodeList elements = doc.getElementsByTagName(elemName);
            for (int i = 0; i < elements.getLength(); ++i) {
                String value;
                Attr attr;
                Node elem = elements.item(i);
                if (!(elem instanceof Element) || (attr = ((Element)elem).getAttributeNodeNS(NS_URI, attrName)) == null || (value = attr.getNodeValue()) == null || value.length() <= 0 || value.indexOf(46) != -1 && value.charAt(0) != '.') continue;
                value = value.charAt(0) == '.' ? pkg + value : pkg + '.' + value;
                attr.setNodeValue(value);
            }
        }
    }

    private void extractFqcns(Document doc) {
        String pkg = null;
        Element manifest = this.findFirstElement(doc, "/manifest");
        if (manifest != null) {
            pkg = manifest.getAttribute("package");
        }
        if (pkg == null || pkg.length() == 0) {
            return;
        }
        int pkgLength = pkg.length();
        for (String elementAttr : sClassAttributes) {
            String[] names = elementAttr.split("/");
            if (names.length != 2) continue;
            String elemName = names[0];
            String attrName = names[1];
            NodeList elements = doc.getElementsByTagName(elemName);
            for (int i = 0; i < elements.getLength(); ++i) {
                String value;
                Attr attr;
                Node elem = elements.item(i);
                if (!(elem instanceof Element) || (attr = ((Element)elem).getAttributeNodeNS(NS_URI, attrName)) == null || (value = attr.getNodeValue()) == null || value.length() <= pkgLength || !value.startsWith(pkg) || value.charAt(pkgLength) != '.') continue;
                value = value.substring(pkgLength);
                attr.setNodeValue(value);
            }
        }
    }

    private boolean checkApplication(Document libDoc) {
        Element mainApp = this.findFirstElement(this.mMainDoc, "/manifest/application");
        Element libApp = this.findFirstElement(libDoc, "/manifest/application");
        if (libApp == null) {
            return true;
        }
        if (this.hasOverrideOrRemoveTag(mainApp)) {
            return true;
        }
        for (String attrName : new String[]{"name", "backupAgent"}) {
            String mainValue;
            String libValue = this.getAttributeValue(libApp, attrName);
            if (libValue == null || libValue.length() == 0) continue;
            String string = mainValue = mainApp == null ? "" : this.getAttributeValue(mainApp, attrName);
            if (libValue.equals(mainValue)) continue;
            assert (mainApp != null);
            this.mLog.conflict(IMergerLog.Severity.WARNING, this.xmlFileAndLine(mainApp), this.xmlFileAndLine(libApp), mainApp == null ? "Library has <application android:%1$s='%3$s'> but main manifest has no application element." : "Main manifest has <application android:%1$s='%2$s'> but library uses %1$s='%3$s'.", attrName, mainValue, libValue);
        }
        return true;
    }

    private boolean doNotMergeCheckEqual(String path, Document libDoc) {
        for (Element src : this.findElements(libDoc, path)) {
            boolean found = false;
            for (Element dest : this.findElements(this.mMainDoc, path)) {
                if (this.hasOverrideOrRemoveTag(dest) || !this.compareElements(dest, src, false, null, null)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.mLog.conflict(IMergerLog.Severity.WARNING, this.xmlFileAndLine(this.mMainDoc), this.xmlFileAndLine(src), "%1$s defined in library, missing from main manifest:\n%2$s", path, MergerXmlUtils.dump(src, false));
        }
        return true;
    }

    private boolean mergeNewOrEqual(String path, String keyAttr, Document libDoc, boolean warnDups) {
        int pos = path.lastIndexOf(47);
        assert (pos > 1);
        String parentPath = path.substring(0, pos);
        Element parent = this.findFirstElement(this.mMainDoc, parentPath);
        assert (parent != null);
        if (parent == null) {
            this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(this.mMainDoc), "Could not find element %1$s.", parentPath);
            return false;
        }
        boolean success = true;
        block0: for (Element src : this.findElements(libDoc, path)) {
            String name = this.getAttributeValue(src, keyAttr);
            if (name.length() == 0) {
                this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(src), "Undefined '%1$s' attribute in %2$s.", keyAttr, path);
                success = false;
                continue;
            }
            List<Element> dests = this.findElements(this.mMainDoc, path, keyAttr, name);
            if (dests.size() > 1) {
                this.mLog.error(IMergerLog.Severity.WARNING, this.xmlFileAndLine(dests.get(0)), "Manifest has more than one %1$s[@%2$s=%3$s] element.", path, keyAttr, name);
            }
            boolean doMerge = true;
            for (Element dest : dests) {
                if (this.hasOverrideOrRemoveTag(dest)) {
                    doMerge = false;
                    continue;
                }
                StringBuilder diff = new StringBuilder();
                if (this.compareElements(dest, src, false, diff, keyAttr)) {
                    if (!warnDups) continue block0;
                    this.mLog.conflict(IMergerLog.Severity.INFO, this.xmlFileAndLine(dest), this.xmlFileAndLine(src), "Skipping identical %1$s[@%2$s=%3$s] element.", path, keyAttr, name);
                    continue block0;
                }
                this.mLog.conflict(IMergerLog.Severity.ERROR, this.xmlFileAndLine(dest), this.xmlFileAndLine(src), "Trying to merge incompatible %1$s[@%2$s=%3$s] element:\n%4$s", path, keyAttr, name, diff.toString());
                success = false;
                continue block0;
            }
            if (!doMerge) continue;
            Node start = this.selectPreviousSiblings(src);
            this.insertAtEndOf(parent, start, src);
        }
        return success;
    }

    private String getAttributeValue(Element element, String attrName) {
        Attr attr = element.getAttributeNodeNS(NS_URI, attrName);
        String value = attr == null ? "" : attr.getNodeValue();
        return value;
    }

    private boolean mergeAdjustRequired(String path, String keyAttr, String requiredAttr, Document libDoc, @Nullable String alternateKeyAttr) {
        int pos = path.lastIndexOf(47);
        assert (pos > 1);
        String parentPath = path.substring(0, pos);
        Element parent = this.findFirstElement(this.mMainDoc, parentPath);
        assert (parent != null);
        if (parent == null) {
            this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(this.mMainDoc), "Could not find element %1$s.", parentPath);
            return false;
        }
        boolean success = true;
        for (Element src : this.findElements(libDoc, path)) {
            String name;
            Attr attr = src.getAttributeNodeNS(NS_URI, keyAttr);
            String string = name = attr == null ? "" : attr.getNodeValue().trim();
            if (name.length() == 0) {
                if (alternateKeyAttr != null) {
                    String s;
                    attr = src.getAttributeNodeNS(NS_URI, alternateKeyAttr);
                    String string2 = s = attr == null ? "" : attr.getNodeValue().trim();
                    if (s.length() != 0) continue;
                }
                this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(src), "Undefined '%1$s' attribute in %2$s.", keyAttr, path);
                success = false;
                continue;
            }
            List<Element> dests = this.findElements(this.mMainDoc, path, keyAttr, name);
            if (dests.size() > 1) {
                this.mLog.error(IMergerLog.Severity.WARNING, this.xmlFileAndLine(dests.get(0)), "Manifest has more than one %1$s[@%2$s=%3$s] element.", path, keyAttr, name);
            }
            if (dests.size() > 0) {
                String value;
                attr = src.getAttributeNodeNS(NS_URI, requiredAttr);
                String string3 = value = attr == null ? "true" : attr.getNodeValue();
                if (value == null || !value.equals("true") && !value.equals("false")) {
                    this.mLog.error(IMergerLog.Severity.WARNING, this.xmlFileAndLine(src), "Invalid attribute '%1$s' in %2$s[@%3$s=%4$s] element:\nExpected 'true' or 'false' but found '%5$s'.", requiredAttr, path, keyAttr, name, value);
                    continue;
                }
                boolean boolE = Boolean.parseBoolean(value);
                for (Element dest : dests) {
                    if (this.hasOverrideOrRemoveTag(dest)) continue;
                    attr = dest.getAttributeNodeNS(NS_URI, requiredAttr);
                    String string4 = value = attr == null ? "true" : attr.getNodeValue();
                    if (value == null || !value.equals("true") && !value.equals("false")) {
                        this.mLog.error(IMergerLog.Severity.WARNING, this.xmlFileAndLine(dest), "Invalid attribute '%1$s' in %2$s[@%3$s=%4$s] element:\nExpected 'true' or 'false' but found '%5$s'.", requiredAttr, path, keyAttr, name, value);
                        continue;
                    }
                    boolean boolD = Boolean.parseBoolean(value);
                    if (boolD || !boolE || attr == null) continue;
                    attr.setNodeValue("true");
                }
                continue;
            }
            Node start = this.selectPreviousSiblings(src);
            Node node = this.insertAtEndOf(parent, start, src);
            NamedNodeMap attrs = node.getAttributes();
            if (attrs == null) continue;
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node a = attrs.item(i);
                if (a.getNodeType() != 2) continue;
                boolean keep = NS_URI.equals(a.getNamespaceURI());
                if (keep) {
                    name = a.getLocalName();
                    boolean bl = keep = keyAttr.equals(name) || requiredAttr.equals(name);
                }
                if (keep) continue;
                attrs.removeNamedItemNS(NS_URI, name);
                i = -1;
            }
        }
        return success;
    }

    private boolean checkGlEsVersion(Document libDoc) {
        String parentPath = "/manifest";
        Element parent = this.findFirstElement(this.mMainDoc, parentPath);
        assert (parent != null);
        if (parent == null) {
            this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(this.mMainDoc), "Could not find element %1$s.", parentPath);
            return false;
        }
        String path = "/manifest/uses-feature";
        String keyAttr = "glEsVersion";
        long destGlEsVersion = 65536L;
        Element destNode = null;
        boolean result = true;
        for (Element dest : this.findElements(this.mMainDoc, path)) {
            Attr attr = dest.getAttributeNodeNS(NS_URI, keyAttr);
            String value = attr == null ? "" : attr.getNodeValue().trim();
            if (value.length() == 0) continue;
            try {
                long version = Long.decode(value);
                if (version >= destGlEsVersion) {
                    destGlEsVersion = version;
                    destNode = dest;
                    continue;
                }
                if (version >= 65536L) continue;
                this.mLog.error(IMergerLog.Severity.WARNING, this.xmlFileAndLine(dest), "Ignoring <uses-feature android:glEsVersion='%1$s'> because it's smaller than 1.0.", value);
            }
            catch (NumberFormatException e) {
                this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(dest), "Failed to parse <uses-feature android:glEsVersion='%1$s'>: must be an integer in the form 0x00020001.", value);
                result = false;
            }
        }
        if (!result && destNode == null) {
            return false;
        }
        long srcGlEsVersion = 65536L;
        Element srcNode = null;
        result = true;
        for (Element src : this.findElements(libDoc, path)) {
            Attr attr = src.getAttributeNodeNS(NS_URI, keyAttr);
            String value = attr == null ? "" : attr.getNodeValue().trim();
            if (value.length() == 0) continue;
            try {
                long version = Long.decode(value);
                if (version >= srcGlEsVersion) {
                    srcGlEsVersion = version;
                    srcNode = src;
                    continue;
                }
                if (version >= 65536L) continue;
                this.mLog.error(IMergerLog.Severity.WARNING, this.xmlFileAndLine(src), "Ignoring <uses-feature android:glEsVersion='%1$s'> because it's smaller than 1.0.", value);
            }
            catch (NumberFormatException e) {
                this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(src), "Failed to parse <uses-feature android:glEsVersion='%1$s'>: must be an integer in the form 0x00020001.", value);
                result = false;
            }
        }
        if (srcNode != null && destGlEsVersion < srcGlEsVersion) {
            this.mLog.conflict(IMergerLog.Severity.WARNING, this.xmlFileAndLine(destNode == null ? this.mMainDoc : destNode), this.xmlFileAndLine(srcNode), "Main manifest has <uses-feature android:glEsVersion='0x%1$08x'> but library uses glEsVersion='0x%2$08x'%3$s", destGlEsVersion, srcGlEsVersion, destNode != null ? "" : "\nNote: main manifest lacks a <uses-feature android:glEsVersion> declaration, and thus defaults to glEsVersion=0x00010000.");
            result = false;
        }
        return result;
    }

    private boolean checkSdkVersion(Document libDoc) {
        boolean result = true;
        Element destUsesSdk = this.findFirstElement(this.mMainDoc, "/manifest/uses-sdk");
        if (this.hasOverrideOrRemoveTag(destUsesSdk)) {
            return true;
        }
        Element srcUsesSdk = this.findFirstElement(libDoc, "/manifest/uses-sdk");
        AtomicInteger destValue = new AtomicInteger(1);
        AtomicInteger srcValue = new AtomicInteger(1);
        AtomicBoolean destImplied = new AtomicBoolean(true);
        AtomicBoolean srcImplied = new AtomicBoolean(true);
        int destMinSdk = 1;
        result = this.extractSdkVersionAttribute(libDoc, destUsesSdk, srcUsesSdk, "min", destValue, srcValue, destImplied, srcImplied);
        if (result && (destMinSdk = destValue.get()) < srcValue.get()) {
            this.mLog.conflict(IMergerLog.Severity.ERROR, this.xmlFileAndLine(destUsesSdk == null ? this.mMainDoc : destUsesSdk), this.xmlFileAndLine(srcUsesSdk == null ? libDoc : srcUsesSdk), "Main manifest has <uses-sdk android:minSdkVersion='%1$d'> but library uses minSdkVersion='%2$d'%3$s", destMinSdk, srcValue.get(), !destImplied.get() ? "" : "\nNote: main manifest lacks a <uses-sdk android:minSdkVersion> declaration, which defaults to value 1.");
            result = false;
        }
        destImplied.set(true);
        srcImplied.set(true);
        boolean result2 = this.extractSdkVersionAttribute(libDoc, destUsesSdk, srcUsesSdk, "target", destValue, srcValue, destImplied, srcImplied);
        result &= result2;
        if (result2) {
            int destTargetSdk;
            int n = destTargetSdk = destImplied.get() ? destMinSdk : destValue.get();
            if (destTargetSdk < srcValue.get()) {
                this.mLog.conflict(IMergerLog.Severity.WARNING, this.xmlFileAndLine(destUsesSdk == null ? this.mMainDoc : destUsesSdk), this.xmlFileAndLine(srcUsesSdk == null ? libDoc : srcUsesSdk), "Main manifest has <uses-sdk android:targetSdkVersion='%1$d'> but library uses targetSdkVersion='%2$d'%3$s", destTargetSdk, srcValue.get(), !destImplied.get() ? "" : "\nNote: main manifest lacks a <uses-sdk android:targetSdkVersion> declaration, which defaults to value minSdkVersion or 1.");
                result = false;
            }
        }
        return result;
    }

    private boolean extractSdkVersionAttribute(Document libDoc, Element destUsesSdk, Element srcUsesSdk, String attr, AtomicInteger destValue, AtomicInteger srcValue, AtomicBoolean destImplied, AtomicBoolean srcImplied) {
        boolean result;
        block11: {
            int apiLevel;
            boolean error;
            String s;
            block10: {
                s = destUsesSdk == null ? "" : destUsesSdk.getAttributeNS(NS_URI, attr + "SdkVersion");
                result = true;
                assert (s != null);
                s = s.trim();
                try {
                    if (s.length() > 0) {
                        destValue.set(Integer.parseInt(s));
                        destImplied.set(false);
                    }
                }
                catch (NumberFormatException e) {
                    error = true;
                    if (this.mCallback != null && (apiLevel = this.mCallback.queryCodenameApiLevel(s)) > 0) {
                        destValue.set(apiLevel);
                        destImplied.set(false);
                        error = false;
                    }
                    if (!error) break block10;
                    this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(destUsesSdk == null ? this.mMainDoc : destUsesSdk), "Failed to parse <uses-sdk %1$sSdkVersion='%2$s'>: must be an integer number or codename.", attr, s);
                    result = false;
                }
            }
            String string = s = srcUsesSdk == null ? "" : srcUsesSdk.getAttributeNS(NS_URI, attr + "SdkVersion");
            assert (s != null);
            s = s.trim();
            try {
                if (s.length() > 0) {
                    srcValue.set(Integer.parseInt(s));
                    srcImplied.set(false);
                }
            }
            catch (NumberFormatException e) {
                error = true;
                if (this.mCallback != null && (apiLevel = this.mCallback.queryCodenameApiLevel(s)) > 0) {
                    srcValue.set(apiLevel);
                    srcImplied.set(false);
                    error = false;
                }
                if (!error) break block11;
                this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(srcUsesSdk == null ? libDoc : srcUsesSdk), "Failed to parse <uses-sdk %1$sSdkVersion='%2$s'>: must be an integer number or codename.", attr, s);
                result = false;
            }
        }
        return result;
    }

    @NonNull
    private Node selectPreviousSiblings(Node end) {
        String text;
        short t;
        Node start = end;
        Node prev = start.getPreviousSibling();
        while (prev != null && !((t = prev.getNodeType()) != 3 ? t != 8 : (text = prev.getNodeValue()) == null || text.trim().length() != 0)) {
            start = prev;
            prev = start.getPreviousSibling();
        }
        return start;
    }

    private Node insertAtEndOf(Element dest, Node start, Node end) {
        String text;
        Node target;
        String destPrefix = XmlUtils.lookupNamespacePrefix(this.mMainDoc, NS_URI);
        String srcPrefix = XmlUtils.lookupNamespacePrefix(start.getOwnerDocument(), NS_URI);
        boolean needPrefixChange = destPrefix != null && !destPrefix.equals(srcPrefix);
        for (target = dest.getLastChild(); target != null && target.getNodeType() == 3 && (text = target.getNodeValue()) != null && text.trim().length() == 0; target = target.getPreviousSibling()) {
        }
        if (target != null) {
            target = target.getNextSibling();
        }
        assert (dest.getOwnerDocument() == this.mMainDoc);
        assert (dest.getOwnerDocument() != start.getOwnerDocument());
        assert (start.getOwnerDocument() == end.getOwnerDocument());
        while (start != null) {
            Node node = this.mMainDoc.importNode(start, true);
            if (needPrefixChange) {
                this.changePrefix(node, srcPrefix, destPrefix);
            }
            dest.insertBefore(node, target);
            if (start == end) {
                return node;
            }
            start = start.getNextSibling();
        }
        return null;
    }

    private void changePrefix(Node node, String srcPrefix, String destPrefix) {
        while (node != null) {
            Node child;
            if (srcPrefix.equals(node.getPrefix())) {
                node.setPrefix(destPrefix);
            }
            if ((child = node.getFirstChild()) != null) {
                this.changePrefix(child, srcPrefix, destPrefix);
            }
            node = node.getNextSibling();
        }
    }

    private boolean compareElements(@NonNull Node expected, @NonNull Node actual, boolean nextSiblings, @Nullable StringBuilder diff, @Nullable String keyAttr) {
        String sA;
        HashMap<String, String> nsPrefixE = new HashMap<String, String>();
        HashMap<String, String> nsPrefixA = new HashMap<String, String>();
        String sE = MergerXmlUtils.printElement(expected, nsPrefixE, "");
        if (sE.equals(sA = MergerXmlUtils.printElement(actual, nsPrefixA, ""))) {
            return true;
        }
        if (diff != null) {
            MergerXmlUtils.printXmlDiff(diff, sE, sA, nsPrefixE, nsPrefixA, "http://schemas.android.com/apk/res/android:" + keyAttr);
        }
        return false;
    }

    @Nullable
    private Element findFirstElement(@NonNull Document doc, @NonNull String path) {
        try {
            Node result = (Node)this.mXPath.evaluate(path, doc, XPathConstants.NODE);
            if (result instanceof Element) {
                return (Element)result;
            }
            if (result != null) {
                this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(doc), "Unexpected Node type %s when evaluating %s", result.getClass().getName(), path);
            }
        }
        catch (XPathExpressionException e) {
            this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(doc), "XPath error on expr %s: %s", path, e.toString());
        }
        return null;
    }

    private List<Element> findElements(@NonNull Document doc, @NonNull String path) {
        return this.findElements(doc, path, null, null);
    }

    private List<Element> findElements(@NonNull Document doc, @NonNull String path, @Nullable String attrName, @Nullable String attrValue) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (attrName != null) {
            assert (attrValue != null);
            path = String.format("%1$s[@%2$s:%3$s='%4$s']", path, NS_PREFIX, attrName, attrValue);
        }
        try {
            NodeList results = (NodeList)this.mXPath.evaluate(path, doc, XPathConstants.NODESET);
            if (results != null && results.getLength() > 0) {
                for (int i = 0; i < results.getLength(); ++i) {
                    Node n = results.item(i);
                    assert (n instanceof Element);
                    if (n instanceof Element) {
                        elements.add((Element)n);
                        continue;
                    }
                    this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(doc), "Unexpected Node type %s when evaluating %s", n.getClass().getName(), path);
                }
            }
        }
        catch (XPathExpressionException e) {
            this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(doc), "XPath error on expr %s: %s", path, e.toString());
        }
        return elements;
    }

    @NonNull
    private IMergerLog.FileAndLine xmlFileAndLine(@NonNull Node node) {
        return MergerXmlUtils.xmlFileAndLine(node);
    }

    private boolean hasOverrideOrRemoveTag(@Nullable Node node) {
        if (node == null || node.getNodeType() != 1) {
            return false;
        }
        NamedNodeMap attrs = node.getAttributes();
        Node merge = attrs.getNamedItemNS(TOOLS_URI, MERGE_ATTR);
        String value = merge == null ? null : merge.getNodeValue();
        return MERGE_OVERRIDE.equals(value) || MERGE_REMOVE.equals(value);
    }

    private void cleanupToolsAttributes(@Nullable Node root) {
        if (root == null) {
            return;
        }
        NamedNodeMap attrs = root.getAttributes();
        if (attrs != null) {
            for (int i = attrs.getLength() - 1; i >= 0; --i) {
                Node attr = attrs.item(i);
                if ("http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) && TOOLS_URI.equals(attr.getNodeValue())) {
                    attrs.removeNamedItem(attr.getNodeName());
                    continue;
                }
                if (!TOOLS_URI.equals(attr.getNamespaceURI()) || !MERGE_ATTR.equals(attr.getLocalName())) continue;
                attrs.removeNamedItem(attr.getNodeName());
            }
            assert (attrs.getNamedItemNS(TOOLS_URI, MERGE_ATTR) == null);
        }
        Node child = root.getFirstChild();
        while (child != null) {
            if (child.getNodeType() != 1) {
                child = child.getNextSibling();
                continue;
            }
            attrs = child.getAttributes();
            Node merge = attrs == null ? null : attrs.getNamedItemNS(TOOLS_URI, MERGE_ATTR);
            String value = merge == null ? null : merge.getNodeValue();
            Node sibling = child.getNextSibling();
            if (MERGE_REMOVE.equals(value)) {
                Node prev = child.getPreviousSibling();
                root.removeChild(child);
                while (prev != null && prev.getNodeType() == 3 && prev.getNodeValue().trim().length() == 0) {
                    Node prevPrev = prev.getPreviousSibling();
                    root.removeChild(prev);
                    prev = prevPrev;
                }
            } else {
                this.cleanupToolsAttributes(child);
            }
            child = sibling;
        }
    }

    private Document cleanupToolsAttributes(@NonNull Document doc) {
        this.cleanupToolsAttributes(doc.getFirstChild());
        return doc;
    }
}

