/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.project;

import com.android.annotations.NonNull;
import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.StreamException;
import com.android.sdklib.internal.project.ProjectProperties;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;

public class ProjectPropertiesWorkingCopy
extends ProjectProperties {
    private static final Map<String, String> COMMENT_MAP = new HashMap<String, String>();

    public synchronized void setProperty(String name, String value) {
        this.mProperties.put(name, value);
    }

    public synchronized String removeProperty(String name) {
        return (String)this.mProperties.remove(name);
    }

    public synchronized ProjectPropertiesWorkingCopy merge(ProjectProperties.PropertyType type) {
        Map<String, String> map;
        IAbstractFile propFile;
        if (this.mProjectFolder.exists() && this.mType != type && (propFile = this.mProjectFolder.getFile(type.getFilename())).exists() && (map = ProjectPropertiesWorkingCopy.parsePropertyFile(propFile, null)) != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (this.mProperties.containsKey(key) || value == null) continue;
                this.mProperties.put(key, value);
            }
        }
        return this;
    }

    public synchronized void save() throws IOException, StreamException {
        IAbstractFile toSave = this.mProjectFolder.getFile(this.mType.getFilename());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        if (toSave.exists()) {
            String value;
            BufferedReader reader = new BufferedReader(new InputStreamReader(toSave.getContents(), "UTF-8"));
            HashSet<String> visitedProps = new HashSet<String>();
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.length() > 0 && line.charAt(0) != '#') {
                    Matcher m = PATTERN_PROP.matcher(line);
                    if (!m.matches()) continue;
                    String key = m.group(1);
                    value = m.group(2);
                    visitedProps.add(key);
                    if (this.mType.isRemovedProperty(key)) {
                        value = null;
                    } else if (this.mProperties.containsKey(key)) {
                        value = (String)this.mProperties.get(key);
                    } else if (this.mType.isKnownProperty(key)) {
                        value = null;
                    }
                    if (value == null) continue;
                    this.writeValue(writer, key, value, false);
                    continue;
                }
                writer.append(line).append('\n');
            }
            for (Map.Entry entry : this.mProperties.entrySet()) {
                if (visitedProps.contains(entry.getKey()) || (value = (String)entry.getValue()) == null) continue;
                this.writeValue(writer, (String)entry.getKey(), value, true);
            }
            Closeables.closeQuietly(reader);
        } else {
            if (this.mType.getHeader() != null) {
                writer.write(this.mType.getHeader());
            }
            for (Map.Entry entry : this.mProperties.entrySet()) {
                String value = (String)entry.getValue();
                if (value == null) continue;
                this.writeValue(writer, (String)entry.getKey(), value, true);
            }
        }
        writer.flush();
        OutputStream filestream = toSave.getOutputStream();
        filestream.write(baos.toByteArray());
        filestream.flush();
        filestream.close();
    }

    private void writeValue(OutputStreamWriter writer, String key, String value, boolean addComment) throws IOException {
        String comment;
        if (addComment && (comment = COMMENT_MAP.get(key)) != null) {
            writer.write(comment);
        }
        writer.write(String.format("%s=%s\n", key, ProjectPropertiesWorkingCopy.escape(value)));
    }

    ProjectPropertiesWorkingCopy(IAbstractFolder projectFolder, Map<String, String> map, ProjectProperties.PropertyType type) {
        super(projectFolder, map, type);
    }

    @NonNull
    public ProjectProperties makeReadOnlyCopy() {
        HashMap<String, String> propList = new HashMap<String, String>(this.mProperties);
        return new ProjectProperties(this.mProjectFolder, propList, this.mType);
    }

    static {
        COMMENT_MAP.put("target", "# Project target.\n");
        COMMENT_MAP.put("split.density", "# Indicates whether an apk should be generated for each density.\n");
        COMMENT_MAP.put("sdk.dir", "# location of the SDK. This is only used by Ant\n# For customization when using a Version Control System, please read the\n# header note.\n");
        COMMENT_MAP.put("package", "# Package of the application being exported\n");
        COMMENT_MAP.put("versionCode", "# Major version code\n");
        COMMENT_MAP.put("projects", "# List of the Android projects being used for the export.\n# The list is made of paths that are relative to this project,\n# using forward-slash (/) as separator, and are separated by colons (:).\n");
    }
}

