/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging;

import com.android.builder.internal.packaging.JavaResourceProcessor;
import com.android.builder.packaging.DuplicateFileException;
import com.android.builder.packaging.PackagerException;
import com.android.builder.packaging.SealedPackageException;
import com.android.builder.signing.SignedJarBuilder;
import com.android.ide.common.signing.CertificateInfo;
import com.android.utils.ILogger;
import com.google.common.collect.Iterables;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Packager
implements JavaResourceProcessor.IArchiveBuilder {
    private SignedJarBuilder mBuilder = null;
    private final ILogger mLogger;
    private boolean mJniDebugMode = false;
    private boolean mIsSealed = false;
    private final DuplicateZipFilter mNoDuplicateFilter = new DuplicateZipFilter();
    private final NoJavaClassZipFilter mNoJavaClassZipFilter = new NoJavaClassZipFilter(this.mNoDuplicateFilter);
    private final HashMap<String, File> mAddedFiles = new HashMap();

    public Packager(String apkLocation, String resLocation, CertificateInfo certificateInfo, String createdBy, ILogger logger) throws PackagerException {
        try {
            File apkFile = new File(apkLocation);
            Packager.checkOutputFile(apkFile);
            File resFile = new File(resLocation);
            Packager.checkInputFile(resFile);
            this.mLogger = logger;
            this.mBuilder = new SignedJarBuilder(new FileOutputStream(apkFile, false), certificateInfo != null ? certificateInfo.getKey() : null, certificateInfo != null ? certificateInfo.getCertificate() : null, Packager.getLocalVersion(), createdBy);
            this.mLogger.verbose("Packaging %s", new Object[]{apkFile.getName()});
            this.addZipFile(resFile);
        }
        catch (PackagerException e) {
            if (this.mBuilder != null) {
                this.mBuilder.cleanUp();
            }
            throw e;
        }
        catch (Exception e) {
            if (this.mBuilder != null) {
                this.mBuilder.cleanUp();
            }
            throw new PackagerException(e);
        }
    }

    public void addDexFiles(Set<File> dexFolders) throws DuplicateFileException, SealedPackageException, PackagerException {
        block3: {
            block2: {
                if (dexFolders.size() != 1) break block2;
                File[] dexFiles = ((File)Iterables.getOnlyElement(dexFolders)).listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String name) {
                        return name.endsWith(".dex");
                    }
                });
                if (dexFiles == null) break block3;
                for (File dexFile : dexFiles) {
                    this.addFile(dexFile, dexFile.getName());
                }
                break block3;
            }
            int dexIndex = 1;
            for (File folderEntry : dexFolders) {
                dexIndex = this.addContentOfDexFolder(folderEntry, dexIndex);
            }
        }
    }

    private int addContentOfDexFolder(File dexFolder, int dexIndex) throws PackagerException, SealedPackageException, DuplicateFileException {
        File[] dexFiles = dexFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(".dex");
            }
        });
        if (dexFiles != null) {
            for (File dexFile : dexFiles) {
                this.addFile(dexFile, dexIndex == 1 ? "classes.dex" : String.format("classes%d.dex", dexIndex));
                ++dexIndex;
            }
        }
        return dexIndex;
    }

    public void setJniDebugMode(boolean jniDebugMode) {
        this.mJniDebugMode = jniDebugMode;
    }

    @Override
    public void addFile(File file, String archivePath) throws PackagerException, SealedPackageException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedPackageException("APK is already sealed", new Object[0]);
        }
        try {
            this.doAddFile(file, archivePath, null);
        }
        catch (DuplicateFileException e) {
            this.mBuilder.cleanUp();
            throw e;
        }
        catch (Exception e) {
            this.mBuilder.cleanUp();
            throw new PackagerException(e, "Failed to add %s", file);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addZipFile(File zipFile) throws PackagerException, SealedPackageException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedPackageException("APK is already sealed", new Object[0]);
        }
        FileInputStream fis = null;
        try {
            this.mLogger.verbose("%s:", new Object[]{zipFile});
            this.mNoDuplicateFilter.reset(zipFile);
            fis = new FileInputStream(zipFile);
            this.mBuilder.writeZip(fis, this.mNoDuplicateFilter, null);
        }
        catch (DuplicateFileException e) {
            try {
                this.mBuilder.cleanUp();
                throw e;
                catch (Exception e2) {
                    this.mBuilder.cleanUp();
                    throw new PackagerException(e2, "Failed to add %s", zipFile);
                }
            }
            catch (Throwable throwable) {
                try {
                    Closeables.close(fis, (boolean)true);
                    throw throwable;
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            Closeables.close((Closeable)fis, (boolean)true);
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addResources(File jarFileOrDirectory) throws PackagerException, DuplicateFileException, SealedPackageException {
        if (this.mIsSealed) {
            throw new SealedPackageException("APK is already sealed", new Object[0]);
        }
        this.mNoDuplicateFilter.reset(jarFileOrDirectory);
        BufferedInputStream fis = null;
        try {
            if (jarFileOrDirectory.isDirectory()) {
                this.addResourcesFromDirectory(jarFileOrDirectory, "");
            } else {
                fis = new BufferedInputStream(new FileInputStream(jarFileOrDirectory));
                this.mBuilder.writeZip(fis, this.mNoJavaClassZipFilter, null);
            }
        }
        catch (DuplicateFileException e) {
            try {
                this.mBuilder.cleanUp();
                throw e;
                catch (Exception e2) {
                    this.mBuilder.cleanUp();
                    throw new PackagerException(e2, "Failed to add %s", jarFileOrDirectory);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fis == null) throw throwable;
                    Closeables.close(fis, (boolean)true);
                    throw throwable;
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (fis == null) return;
            Closeables.close((Closeable)fis, (boolean)true);
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    private void addResourcesFromDirectory(File directory, String path) throws IOException, SignedJarBuilder.IZipEntryFilter.ZipAbortException {
        File[] directoryFiles = directory.listFiles();
        if (directoryFiles == null) {
            return;
        }
        for (File file : directoryFiles) {
            String entryName;
            String string = entryName = path.isEmpty() ? file.getName() : path + "/" + file.getName();
            if (file.isDirectory()) {
                this.addResourcesFromDirectory(file, entryName);
                continue;
            }
            this.doAddFile(file, entryName, null);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addNativeLibraries(File jarFileOrDirectory, Set<String> abiFilters) throws PackagerException, SealedPackageException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedPackageException("APK is already sealed", new Object[0]);
        }
        this.mLogger.verbose("Native Libraries input: %s", new Object[]{jarFileOrDirectory});
        NativeLibZipFilter filter = new NativeLibZipFilter(abiFilters, this.mNoDuplicateFilter, this.mJniDebugMode);
        this.mNoDuplicateFilter.reset(jarFileOrDirectory);
        BufferedInputStream fis = null;
        try {
            if (jarFileOrDirectory.isDirectory()) {
                this.addNativeLibrariesFromDirectory(jarFileOrDirectory, "", filter);
            } else {
                fis = new BufferedInputStream(new FileInputStream(jarFileOrDirectory));
                this.mBuilder.writeZip(fis, filter, null);
            }
        }
        catch (DuplicateFileException e) {
            try {
                this.mBuilder.cleanUp();
                throw e;
                catch (Exception e2) {
                    this.mBuilder.cleanUp();
                    throw new PackagerException(e2, "Failed to add %s", jarFileOrDirectory);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fis == null) throw throwable;
                    Closeables.close(fis, (boolean)true);
                    throw throwable;
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (fis == null) return;
            Closeables.close((Closeable)fis, (boolean)true);
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    private void addNativeLibrariesFromDirectory(File directory, String path, NativeLibZipFilter zipFilter) throws IOException, SignedJarBuilder.IZipEntryFilter.ZipAbortException {
        File[] directoryFiles = directory.listFiles();
        if (directoryFiles == null) {
            return;
        }
        for (File file : directoryFiles) {
            String entryName;
            String string = entryName = path.isEmpty() ? file.getName() : path + "/" + file.getName();
            if (file.isDirectory()) {
                this.addNativeLibrariesFromDirectory(file, entryName, zipFilter);
                continue;
            }
            this.doAddFile(file, entryName, zipFilter);
        }
    }

    public void sealApk() throws PackagerException, SealedPackageException {
        if (this.mIsSealed) {
            throw new SealedPackageException("APK is already sealed", new Object[0]);
        }
        try {
            this.mBuilder.close();
            this.mIsSealed = true;
        }
        catch (Exception e) {
            throw new PackagerException(e, "Failed to seal APK", new Object[0]);
        }
        finally {
            this.mBuilder.cleanUp();
            this.mAddedFiles.clear();
        }
    }

    private void doAddFile(File file, String archivePath, SignedJarBuilder.IZipEntryFilter filter) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException, IOException {
        if (filter == null) {
            filter = this.mNoJavaClassZipFilter;
        }
        if (!filter.checkEntry(archivePath)) {
            return;
        }
        this.mAddedFiles.put(archivePath, file);
        this.mBuilder.writeFile(file, archivePath);
    }

    private File checkFileForDuplicate(String archivePath) {
        return this.mAddedFiles.get(archivePath);
    }

    private static void checkOutputFile(File file) throws PackagerException {
        if (file.isDirectory()) {
            throw new PackagerException("%s is a directory!", file);
        }
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new PackagerException("Cannot write %s", file);
            }
        } else {
            try {
                if (!file.createNewFile()) {
                    throw new PackagerException("Failed to create %s", file);
                }
            }
            catch (IOException e) {
                throw new PackagerException("Failed to create '%1$ss': %2$s", file, e.getMessage());
            }
        }
    }

    private static void checkInputFile(File file) throws FileNotFoundException, PackagerException {
        if (file.isDirectory()) {
            throw new PackagerException("%s is a directory!", file);
        }
        if (file.exists()) {
            if (!file.canRead()) {
                throw new PackagerException("Cannot read %s", file);
            }
        } else {
            throw new FileNotFoundException(String.format("%s does not exist", file));
        }
    }

    public static String getLocalVersion() {
        Class<Packager> clazz = Packager.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return null;
        }
        try {
            String manifestPath = classPath.substring(0, classPath.lastIndexOf(33) + 1) + "/META-INF/MANIFEST.MF";
            URLConnection jarConnection = new URL(manifestPath).openConnection();
            jarConnection.setUseCaches(false);
            InputStream jarInputStream = jarConnection.getInputStream();
            Attributes attr = new Manifest(jarInputStream).getMainAttributes();
            jarInputStream.close();
            return attr.getValue("Builder-Version");
        }
        catch (MalformedURLException ignored) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static final class NativeLibZipFilter
    implements SignedJarBuilder.IZipEntryFilter {
        private final SignedJarBuilder.IZipEntryFilter parentFilter;
        private final Set<String> acceptedAbis;
        private final boolean mJniDebugMode;
        private final Pattern mAbiPattern = Pattern.compile("lib/([^/]+)/[^/]+");
        private final Pattern mFilenamePattern = Pattern.compile(".*\\.so");

        private NativeLibZipFilter(Set<String> acceptedAbis, SignedJarBuilder.IZipEntryFilter parentFilter, boolean jniDebugMode) {
            this.acceptedAbis = acceptedAbis;
            this.parentFilter = parentFilter;
            this.mJniDebugMode = jniDebugMode;
        }

        @Override
        public boolean checkEntry(String archivePath) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException {
            if (!this.parentFilter.checkEntry(archivePath)) {
                return false;
            }
            Matcher m = this.mAbiPattern.matcher(archivePath);
            if (m.matches() && (this.acceptedAbis.isEmpty() || this.acceptedAbis.contains(m.group(1)))) {
                String filename = archivePath.substring(5 + m.group(1).length());
                return this.mFilenamePattern.matcher(filename).matches() || this.mJniDebugMode && ("gdbserver".equals(filename) || "gdb.setup".equals(filename));
            }
            return false;
        }
    }

    private static final class NoJavaClassZipFilter
    implements SignedJarBuilder.IZipEntryFilter {
        private final SignedJarBuilder.IZipEntryFilter parentFilter;

        private NoJavaClassZipFilter(SignedJarBuilder.IZipEntryFilter parentFilter) {
            this.parentFilter = parentFilter;
        }

        @Override
        public boolean checkEntry(String archivePath) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException {
            return this.parentFilter.checkEntry(archivePath) && !archivePath.endsWith(".class");
        }
    }

    private final class DuplicateZipFilter
    implements SignedJarBuilder.IZipEntryFilter {
        private File mInputFile;

        private DuplicateZipFilter() {
        }

        void reset(File inputFile) {
            this.mInputFile = inputFile;
        }

        @Override
        public boolean checkEntry(String archivePath) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException {
            Packager.this.mLogger.verbose("=> %s", new Object[]{archivePath});
            File duplicate = Packager.this.checkFileForDuplicate(archivePath);
            if (duplicate != null) {
                File potentialDuplicate = new File(this.mInputFile, archivePath);
                if (!duplicate.getAbsolutePath().equals(potentialDuplicate.getAbsolutePath())) {
                    throw new DuplicateFileException(archivePath, duplicate, this.mInputFile);
                }
                return false;
            }
            Packager.this.mAddedFiles.put(archivePath, this.mInputFile);
            return true;
        }
    }
}

