/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.shrinker;

import com.android.builder.shrinker.ClassLookupException;
import com.android.builder.shrinker.Dependency;
import com.android.builder.shrinker.DependencyType;
import com.android.builder.shrinker.Shrinker;
import com.android.builder.shrinker.ShrinkerGraph;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;

public class JavaSerializationShrinkerGraph
implements ShrinkerGraph<String> {
    private boolean allClassesAdded = false;
    private final File mStateDir;
    private static final CacheLoader<String, Counter> CACHE_LOADER = new CacheLoader<String, Counter>(){

        public Counter load(String unused) throws Exception {
            return new Counter();
        }
    };
    private ConcurrentMap<String, ClassInfo> mClasses = Maps.newConcurrentMap();
    private SetMultimap<String, String> mMembers = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private SetMultimap<String, String> mAnnotations = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private Map<String, Integer> mModifiers = Maps.newConcurrentMap();
    private EnumMap<Shrinker.ShrinkType, LoadingCache<String, Counter>> mReferenceCounters;
    private SetMultimap<String, Dependency<String>> mDependencies = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());

    public JavaSerializationShrinkerGraph(File stateDir) {
        this.mStateDir = (File)Preconditions.checkNotNull((Object)stateDir);
        this.mReferenceCounters = new EnumMap(Shrinker.ShrinkType.class);
        for (Shrinker.ShrinkType shrinkType : Shrinker.ShrinkType.values()) {
            LoadingCache counters = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).build(CACHE_LOADER);
            this.mReferenceCounters.put(shrinkType, (LoadingCache<String, Counter>)counters);
        }
    }

    @Override
    public String addMember(String owner, String name, String desc, int modifiers) {
        String fullName = JavaSerializationShrinkerGraph.getFullMethodName(owner, name, desc);
        this.mMembers.put((Object)owner, (Object)fullName);
        this.mModifiers.put(fullName, modifiers);
        return fullName;
    }

    @Override
    public String getMemberReference(String className, String memberName, String methodDesc) {
        return JavaSerializationShrinkerGraph.getFullMethodName(className, memberName, methodDesc);
    }

    private static String getFullMethodName(String className, String methodName, String typeDesc) {
        return className + "." + methodName + ":" + typeDesc;
    }

    @Override
    public void addDependency(String source, String target, DependencyType type) {
        Dependency<String> dep = new Dependency<String>(target, type);
        this.mDependencies.put((Object)source, dep);
    }

    @Override
    public Set<Dependency<String>> getDependencies(String member) {
        return Sets.newHashSet((Iterable)this.mDependencies.get((Object)member));
    }

    @Override
    public Set<String> getMethods(String klass) {
        HashSet members = Sets.newHashSet((Iterable)this.mMembers.get((Object)klass));
        Iterator iterator = members.iterator();
        while (iterator.hasNext()) {
            String member = (String)iterator.next();
            if (JavaSerializationShrinkerGraph.isMethod(member)) continue;
            iterator.remove();
        }
        return members;
    }

    @Override
    public Set<String> getFields(String klass) {
        HashSet members = Sets.newHashSet((Iterable)this.mMembers.get((Object)klass));
        Iterator iterator = members.iterator();
        while (iterator.hasNext()) {
            String member = (String)iterator.next();
            if (!JavaSerializationShrinkerGraph.isMethod(member)) continue;
            iterator.remove();
        }
        return members;
    }

    private static boolean isMethod(String member) {
        return member.contains("(");
    }

    @Override
    public boolean incrementAndCheck(String member, DependencyType type, Shrinker.ShrinkType shrinkType) {
        try {
            return ((Counter)this.mReferenceCounters.get((Object)shrinkType).get((Object)member)).incrementAndCheck(type);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveState() throws IOException {
        ObjectOutputStream stream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.getStateFile())));
        try {
            stream.writeObject(this.mClasses);
            stream.writeObject(this.mMembers);
            stream.writeObject(this.mDependencies);
            HashMap countersMap = Maps.newHashMap();
            for (Map.Entry<Shrinker.ShrinkType, LoadingCache<String, Counter>> entry : this.mReferenceCounters.entrySet()) {
                countersMap.put(entry.getKey(), Maps.newHashMap((Map)entry.getValue().asMap()));
            }
            stream.writeObject(countersMap);
        }
        finally {
            stream.close();
        }
    }

    @Override
    public boolean isReachable(String member, Shrinker.ShrinkType shrinkType) {
        try {
            return ((Counter)this.mReferenceCounters.get((Object)shrinkType).get((Object)member)).isReachable();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeDependency(String source, Dependency<String> dep) {
        this.mDependencies.remove((Object)source, dep);
    }

    @Override
    public boolean decrementAndCheck(String member, DependencyType type, Shrinker.ShrinkType shrinkType) {
        try {
            return ((Counter)this.mReferenceCounters.get((Object)shrinkType).get((Object)member)).decrementAndCheck(type);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getSuperclass(String klass) throws ClassLookupException {
        Preconditions.checkState((boolean)this.allClassesAdded, (Object)"allNodesAdded() not called yet.");
        ClassInfo classInfo = (ClassInfo)this.mClasses.get(klass);
        if (classInfo == null) {
            throw new ClassLookupException(klass);
        }
        return classInfo.superclass;
    }

    @Override
    public String findMatchingMethod(String klass, String method) {
        String methodToLookFor = klass + "." + JavaSerializationShrinkerGraph.getMemberId(method);
        if (this.mMembers.containsEntry((Object)klass, (Object)methodToLookFor)) {
            return methodToLookFor;
        }
        return null;
    }

    @Override
    public boolean isLibraryMember(String method) {
        return ((ClassInfo)this.mClasses.get(this.getClassForMember(method))).isLibraryClass();
    }

    @Override
    public boolean isLibraryClass(String klass) {
        ClassInfo classInfo = (ClassInfo)this.mClasses.get(klass);
        return classInfo != null && classInfo.isLibraryClass();
    }

    public String[] getInterfaces(String klass) {
        return ((ClassInfo)this.mClasses.get((Object)klass)).interfaces;
    }

    @Override
    public void checkDependencies() {
        HashMap invalidDeps = Maps.newHashMap();
        for (Map.Entry entry : this.mDependencies.entries()) {
            Dependency dep = (Dependency)entry.getValue();
            String target = (String)dep.target;
            if (!target.contains(".")) {
                if (this.mClasses.containsKey(target) || target.startsWith("sun/misc/Unsafe") || target.startsWith("android/support")) continue;
                System.out.println("Invalid dependency target: " + target);
                invalidDeps.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (this.mMembers.containsEntry((Object)this.getClassForMember(target), (Object)target) || target.startsWith("sun/misc/Unsafe") || target.startsWith("android/support")) continue;
            System.out.println("Invalid dependency target: " + target);
            invalidDeps.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : invalidDeps.entrySet()) {
            this.mDependencies.remove(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean keepClass(String klass, Shrinker.ShrinkType shrinkType) {
        try {
            if (((ClassInfo)this.mClasses.get(klass)).isLibraryClass()) {
                return true;
            }
            LoadingCache<String, Counter> counters = this.mReferenceCounters.get((Object)shrinkType);
            Counter counter = (Counter)counters.get((Object)klass);
            return counter.isReachable();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private File getStateFile() {
        return new File(this.mStateDir, "shrinker.bin");
    }

    @Override
    public void loadState() throws IOException {
        ObjectInputStream stream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.getStateFile())));
        try {
            this.mClasses = (ConcurrentMap)stream.readObject();
            this.mMembers = (SetMultimap)stream.readObject();
            this.mDependencies = (SetMultimap)stream.readObject();
            Map countersMap = (Map)stream.readObject();
            for (Map.Entry entry : countersMap.entrySet()) {
                LoadingCache<String, Counter> cache = this.mReferenceCounters.get(entry.getKey());
                cache.invalidateAll();
                cache.putAll((Map)entry.getValue());
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            stream.close();
        }
    }

    @Override
    public void removeStoredState() throws IOException {
        FileUtils.emptyFolder((File)this.mStateDir);
    }

    @Override
    public Collection<String> getClassesToKeep(Shrinker.ShrinkType shrinkType) {
        try {
            ArrayList classesToKeep = Lists.newArrayList();
            for (Map.Entry entry : this.mClasses.entrySet()) {
                LoadingCache<String, Counter> counters;
                Counter counter;
                if (((ClassInfo)entry.getValue()).isLibraryClass() || !(counter = (Counter)(counters = this.mReferenceCounters.get((Object)shrinkType)).get(entry.getKey())).isReachable()) continue;
                classesToKeep.add(entry.getKey());
            }
            return classesToKeep;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public File getClassFile(String klass) {
        return ((ClassInfo)this.mClasses.get((Object)klass)).classFile;
    }

    @Override
    public Set<String> getMembersToKeep(String klass, Shrinker.ShrinkType shrinkType) {
        try {
            HashSet memberIds = Sets.newHashSet();
            for (String member : this.mMembers.get((Object)klass)) {
                if (!((Counter)this.mReferenceCounters.get((Object)shrinkType).get((Object)member)).isReachable()) continue;
                String memberId = JavaSerializationShrinkerGraph.getMemberId(member);
                memberIds.add(memberId);
            }
            return memberIds;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getMemberId(String member) {
        return member.substring(member.indexOf(46) + 1);
    }

    @Override
    public String getClassForMember(String member) {
        return member.substring(0, member.indexOf(46));
    }

    @Override
    public String getClassReference(String className) {
        return className;
    }

    @Override
    public String addClass(String name, String superName, String[] interfaces, int access, File classFile) {
        Preconditions.checkState((!this.allClassesAdded ? 1 : 0) != 0, (Object)"allNodesAdded() has already been called.");
        ClassInfo classInfo = new ClassInfo(classFile, superName, interfaces);
        this.mClasses.put(name, classInfo);
        this.mModifiers.put(name, access);
        return name;
    }

    @Override
    public void allClassesAdded() {
        this.allClassesAdded = true;
    }

    @Override
    public Iterable<String> getAllProgramClasses() {
        ArrayList classes = Lists.newArrayList();
        for (Map.Entry entry : this.mClasses.entrySet()) {
            boolean isProgramClass = ((ClassInfo)entry.getValue()).classFile != null;
            if (!isProgramClass) continue;
            classes.add(entry.getKey());
        }
        return classes;
    }

    @Override
    public String getClassName(String classOrMember) {
        return classOrMember;
    }

    @Override
    public String getMethodNameAndDesc(String method) {
        return method.substring(method.indexOf(46) + 1);
    }

    @Override
    public String getFieldName(String field) {
        return field.substring(field.indexOf(46) + 1, field.indexOf(58));
    }

    @Override
    public String getFieldDesc(String field) {
        return field.substring(field.indexOf(58) + 1);
    }

    @Override
    public int getClassModifiers(String klass) {
        return this.mModifiers.get(klass);
    }

    @Override
    public int getMemberModifiers(String member) {
        return this.mModifiers.get(member);
    }

    @Override
    public void addAnnotation(String classOrMember, String desc) {
        this.mAnnotations.put((Object)classOrMember, (Object)desc);
    }

    @Override
    public Iterable<String> getAnnotations(String classOrMember) {
        return this.mAnnotations.get((Object)classOrMember);
    }

    private static final class Counter
    implements Serializable {
        int required = 0;
        int ifClassKept = 0;
        int classIsKept = 0;

        private Counter() {
        }

        synchronized boolean decrementAndCheck(DependencyType type) {
            boolean before = this.isReachable();
            switch (type) {
                case REQUIRED: {
                    --this.required;
                    break;
                }
                case IF_CLASS_KEPT: {
                    --this.ifClassKept;
                    break;
                }
                case CLASS_IS_KEPT: {
                    --this.classIsKept;
                }
            }
            boolean after = this.isReachable();
            return before != after;
        }

        synchronized boolean incrementAndCheck(DependencyType type) {
            boolean before = this.isReachable();
            switch (type) {
                case REQUIRED: {
                    ++this.required;
                    break;
                }
                case IF_CLASS_KEPT: {
                    ++this.ifClassKept;
                    break;
                }
                case CLASS_IS_KEPT: {
                    ++this.classIsKept;
                }
            }
            boolean after = this.isReachable();
            return before != after;
        }

        synchronized boolean isReachable() {
            return this.required > 0 || this.ifClassKept > 0 && this.classIsKept > 0;
        }
    }

    private static final class ClassInfo
    implements Serializable {
        final File classFile;
        final String superclass;
        final String[] interfaces;

        private ClassInfo(File classFile, String superclass, String[] interfaces) {
            this.classFile = classFile;
            this.superclass = superclass;
            this.interfaces = interfaces;
        }

        boolean isLibraryClass() {
            return this.classFile == null;
        }
    }
}

