/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.shrinker;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.builder.shrinker.ClassLookupException;
import com.android.builder.shrinker.ClassStructureVisitor;
import com.android.builder.shrinker.Dependency;
import com.android.builder.shrinker.DependencyFinderVisitor;
import com.android.builder.shrinker.DependencyType;
import com.android.builder.shrinker.FilterMembersVisitor;
import com.android.builder.shrinker.KeepRules;
import com.android.builder.shrinker.ShrinkerGraph;
import com.android.builder.shrinker.TypeHierarchyTraverser;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.utils.FileUtils;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class Shrinker<T> {
    private final WaitableExecutor<Void> mExecutor;
    private final ShrinkerGraph<T> mGraph;
    private final File mAndroidJar;

    public Shrinker(WaitableExecutor<Void> executor, ShrinkerGraph<T> graph, File androidJar) {
        this.mExecutor = executor;
        this.mGraph = graph;
        this.mAndroidJar = androidJar;
    }

    private static Optional<File> chooseOutputFile(File classFile, Collection<TransformInput> inputs, TransformOutputProvider output) {
        String absolutePath = classFile.getAbsolutePath();
        for (TransformInput input : inputs) {
            for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                File folder = directoryInput.getFile();
                if (!absolutePath.startsWith(folder.getAbsolutePath())) continue;
                File outputDir = output.getContentLocation(directoryInput.getName(), directoryInput.getContentTypes(), directoryInput.getScopes(), Format.DIRECTORY);
                String relativePath = FileUtils.relativePath((File)classFile, (File)folder);
                return Optional.of((Object)new File(outputDir, relativePath));
            }
        }
        return Optional.absent();
    }

    private static ClassNode readClassNode(File classFile) throws IOException {
        ClassReader classReader = new ClassReader(Files.toByteArray((File)classFile));
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    private static byte[] rewrite(File classFile, Set<String> membersToKeep, Predicate<String> keepClass) throws IOException {
        ClassReader classReader = new ClassReader(Files.toByteArray((File)classFile));
        ClassWriter classWriter = new ClassWriter(0);
        FilterMembersVisitor filter = new FilterMembersVisitor(membersToKeep, keepClass, (ClassVisitor)classWriter);
        classReader.accept((ClassVisitor)filter, 0);
        return classWriter.toByteArray();
    }

    public static UnsupportedOperationException todo(String message) {
        return new UnsupportedOperationException("TODO: " + message);
    }

    private ImmutableMap<ShrinkType, Set<T>> buildMapPerShrinkType(ImmutableMap<ShrinkType, KeepRules> keepRules) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ShrinkType shrinkType : keepRules.keySet()) {
            builder.put((Object)shrinkType, (Object)Sets.newConcurrentHashSet());
        }
        return builder.build();
    }

    private void buildGraph(Iterable<TransformInput> programInputs, Iterable<TransformInput> libraryInputs) throws IOException {
        final Set virtualMethods = Sets.newConcurrentHashSet();
        final Set multipleInheritance = Sets.newConcurrentHashSet();
        final Set unresolvedReferences = Sets.newConcurrentHashSet();
        this.readPlatformJar();
        for (TransformInput input : libraryInputs) {
            for (File folder : Shrinker.getAllDirectories(input)) {
                for (final File classFile : Shrinker.getClassFiles(folder)) {
                    this.mExecutor.execute((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            Shrinker.this.processLibraryClass(Files.toByteArray((File)classFile));
                            return null;
                        }
                    });
                }
            }
        }
        for (TransformInput input : programInputs) {
            for (File folder : Shrinker.getAllDirectories(input)) {
                for (final File classFile : Shrinker.getClassFiles(folder)) {
                    this.mExecutor.execute((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            Shrinker.this.processNewClassFile(classFile, virtualMethods, multipleInheritance, unresolvedReferences);
                            return null;
                        }
                    });
                }
            }
        }
        this.waitForAllTasks();
        this.mGraph.allClassesAdded();
        this.handleOverrides(virtualMethods);
        this.handleMultipleInheritance(multipleInheritance);
        this.resolveReferences(unresolvedReferences);
        this.waitForAllTasks();
        this.mGraph.checkDependencies();
    }

    private static Collection<File> getAllDirectories(TransformInput input) {
        ArrayList files = Lists.newArrayList();
        for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
            files.add(directoryInput.getFile());
        }
        return files;
    }

    private static FluentIterable<File> getClassFiles(File dir) {
        return FileUtils.getAllFiles((File)dir).filter(FileUtils.withExtension((String)"class"));
    }

    private void resolveReferences(Set<UnresolvedReference<T>> unresolvedReferences) {
        for (final UnresolvedReference<T> unresolvedReference : unresolvedReferences) {
            this.mExecutor.execute((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Object startClass = Shrinker.this.mGraph.getClassForMember(unresolvedReference.target);
                    if (unresolvedReference.opcode == 183) {
                        startClass = Shrinker.this.mGraph.getSuperclass(Shrinker.this.mGraph.getClassForMember(unresolvedReference.method));
                        Preconditions.checkState((startClass != null ? 1 : 0) != 0);
                    }
                    for (Object currentClass : new TypeHierarchyTraverser(Shrinker.this.mGraph).preOrderTraversal(startClass)) {
                        Object target = Shrinker.this.mGraph.findMatchingMethod(currentClass, unresolvedReference.target);
                        if (target == null) continue;
                        if (!Shrinker.this.mGraph.isLibraryMember(target)) {
                            Shrinker.this.mGraph.addDependency(unresolvedReference.method, currentClass, DependencyType.REQUIRED);
                            Shrinker.this.mGraph.addDependency(unresolvedReference.method, target, DependencyType.REQUIRED);
                        }
                        return null;
                    }
                    String className = Shrinker.this.mGraph.getClassName(Shrinker.this.mGraph.getClassForMember(unresolvedReference.target));
                    if (!className.startsWith("sun/misc/Unsafe")) {
                        System.out.println(String.format("Unresolved reference: %s.%s", className, Shrinker.this.mGraph.getMethodNameAndDesc(unresolvedReference.target)));
                    }
                    return null;
                }
            });
        }
    }

    private void handleOverrides(Set<T> virtualMethods) {
        for (final T method : virtualMethods) {
            this.mExecutor.execute((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    String methodNameAndDesc = Shrinker.this.mGraph.getMethodNameAndDesc(method);
                    if (Shrinker.isJavaLangObjectMethod(methodNameAndDesc)) {
                        Shrinker.this.mGraph.addDependency(Shrinker.this.mGraph.getClassForMember(method), method, DependencyType.REQUIRED);
                        return null;
                    }
                    FluentIterable superTypes = new TypeHierarchyTraverser(Shrinker.this.mGraph).preOrderTraversal(Shrinker.this.mGraph.getClassForMember(method));
                    for (Object klass : superTypes) {
                        Object superMethod;
                        if (Shrinker.this.mGraph.getClassName(klass).equals("java/lang/Object") || (superMethod = Shrinker.this.mGraph.findMatchingMethod(klass, method)) == null || superMethod.equals(method)) continue;
                        if (Shrinker.this.mGraph.isLibraryMember(superMethod)) {
                            Shrinker.this.mGraph.addDependency(Shrinker.this.mGraph.getClassForMember(method), method, DependencyType.REQUIRED);
                            return null;
                        }
                        Shrinker.this.mGraph.addDependency(Shrinker.this.mGraph.getClassForMember(method), method, DependencyType.CLASS_IS_KEPT);
                        Shrinker.this.mGraph.addDependency(superMethod, method, DependencyType.IF_CLASS_KEPT);
                    }
                    return null;
                }
            });
        }
    }

    private static boolean isJavaLangObjectMethod(String nameAndDesc) {
        return nameAndDesc.equals("hashCode:()I") || nameAndDesc.equals("equals:(Ljava/lang/Object;)Z") || nameAndDesc.equals("toString:()Ljava/lang/String;");
    }

    private void handleMultipleInheritance(Set<T> multipleInheritance) {
        for (final T klass : multipleInheritance) {
            this.mExecutor.execute((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Object[] interfaces = Shrinker.this.mGraph.getInterfaces(klass);
                    HashSet methods = Sets.newHashSet();
                    for (Object iface : interfaces) {
                        for (Object method : Shrinker.this.mGraph.getMethods(iface)) {
                            methods.add(method);
                        }
                    }
                    block4: for (Object method : methods) {
                        Object matchingMethod = Shrinker.this.mGraph.findMatchingMethod(klass, method);
                        if (matchingMethod != null) continue;
                        try {
                            Object current = Shrinker.this.mGraph.getSuperclass(klass);
                            while (current != null) {
                                matchingMethod = Shrinker.this.mGraph.findMatchingMethod(current, method);
                                if (matchingMethod != null) {
                                    if (Shrinker.this.mGraph.isLibraryClass(current)) continue block4;
                                    String name = Shrinker.this.mGraph.getMethodNameAndDesc(method);
                                    String desc = name.substring(name.indexOf(58) + 1);
                                    name = name.substring(0, name.indexOf(58));
                                    name = name + "$shrinker_fake";
                                    Object fakeMethod = Shrinker.this.mGraph.addMember(klass, name, desc, Shrinker.this.mGraph.getMemberModifiers(method));
                                    Shrinker.this.mGraph.addDependency(fakeMethod, matchingMethod, DependencyType.REQUIRED);
                                    if (Shrinker.this.mGraph.isLibraryMember(method)) {
                                        Shrinker.this.mGraph.addDependency(klass, fakeMethod, DependencyType.REQUIRED);
                                        continue block4;
                                    }
                                    Shrinker.this.mGraph.addDependency(klass, fakeMethod, DependencyType.CLASS_IS_KEPT);
                                    Shrinker.this.mGraph.addDependency(method, fakeMethod, DependencyType.IF_CLASS_KEPT);
                                    continue block4;
                                }
                                current = Shrinker.this.mGraph.getSuperclass(current);
                            }
                        }
                        catch (ClassLookupException e) {
                            System.out.println("Can't resolve " + method);
                        }
                    }
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPlatformJar() throws IOException {
        JarFile jarFile = new JarFile(this.mAndroidJar);
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                InputStream inputStream = jarFile.getInputStream(entry);
                try {
                    final byte[] source = ByteStreams.toByteArray((InputStream)inputStream);
                    this.mExecutor.execute((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            Shrinker.this.processLibraryClass(source);
                            return null;
                        }
                    });
                }
                finally {
                    inputStream.close();
                }
            }
        }
        finally {
            jarFile.close();
        }
    }

    private void processLibraryClass(byte[] source) throws IOException {
        ClassReader classReader = new ClassReader(source);
        classReader.accept(new ClassStructureVisitor<T>(this.mGraph, null, null), 7);
    }

    private void waitForAllTasks() {
        try {
            this.mExecutor.waitForTasksWithQuickFail(true);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (LoggedErrorException e) {
            throw new RuntimeException(e);
        }
    }

    private void decrementCounter(T member, DependencyType dependencyType, ShrinkType shrinkType, ImmutableMap<ShrinkType, Set<T>> modifiedClasses) {
        if (this.mGraph.decrementAndCheck(member, dependencyType, shrinkType)) {
            if (modifiedClasses != null) {
                ((Set)modifiedClasses.get((Object)shrinkType)).add(this.mGraph.getClassForMember(member));
            }
            for (Dependency<T> dependency : this.mGraph.getDependencies(member)) {
                this.decrementCounter(dependency.target, dependency.type, shrinkType, modifiedClasses);
            }
        }
    }

    private Set<Dependency<T>> getDependencies(MethodNode methodNode) {
        final HashSet deps = Sets.newHashSet();
        methodNode.accept((ClassVisitor)new DependencyFinderVisitor<T>(this.mGraph, null, null, null, null){

            @Override
            protected void handleDependency(T source, T target, DependencyType type) {
                deps.add(new Dependency(target, type));
            }
        });
        return deps;
    }

    public void handleFileChanges(Collection<TransformInput> inputs, TransformOutputProvider output, final ImmutableMap<ShrinkType, KeepRules> keepRules) throws IOException {
        this.mGraph.loadState();
        final ImmutableMap<ShrinkType, Set<T>> modifiedClasses = this.buildMapPerShrinkType(keepRules);
        for (TransformInput input : inputs) {
            for (JarInput jarInput : input.getJarInputs()) {
                switch (jarInput.getStatus()) {
                    case ADDED: {
                        break;
                    }
                    case REMOVED: {
                        break;
                    }
                }
            }
            for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                for (final Map.Entry changedFile : directoryInput.getChangedFiles().entrySet()) {
                    this.mExecutor.execute((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            switch ((Status)changedFile.getValue()) {
                                case ADDED: {
                                    throw Shrinker.todo("new file added");
                                }
                                case REMOVED: {
                                    throw Shrinker.todo("removed file");
                                }
                                case CHANGED: {
                                    Shrinker.this.processChangedClassFile((File)changedFile.getKey(), (Map)keepRules, modifiedClasses);
                                }
                            }
                            return null;
                        }
                    });
                }
            }
        }
        this.waitForAllTasks();
        for (ShrinkType shrinkType : keepRules.keySet()) {
            this.updateClassFiles((Iterable)modifiedClasses.get((Object)shrinkType), inputs, output);
        }
        this.waitForAllTasks();
    }

    private void incrementCounter(T member, DependencyType dependencyType, ShrinkType shrinkType) {
        if (this.mGraph.incrementAndCheck(member, dependencyType, shrinkType)) {
            for (Dependency<T> dependency : this.mGraph.getDependencies(member)) {
                this.incrementCounter(dependency.target, dependency.type, shrinkType);
            }
        }
    }

    private void processChangedClassFile(File classFile, Map<ShrinkType, KeepRules> keepRules, ImmutableMap<ShrinkType, Set<T>> modifiedClasses) throws IOException {
        ClassNode classNode = Shrinker.readClassNode(classFile);
        T klass = this.mGraph.getClassReference(classNode.name);
        for (ShrinkType shrinkType : keepRules.keySet()) {
            if (!this.mGraph.isReachable(klass, shrinkType)) continue;
            ((Set)modifiedClasses.get((Object)shrinkType)).add(klass);
        }
        Set<T> oldMembers = this.mGraph.getMethods(klass);
        for (MethodNode methodNode : classNode.methods) {
            T method = this.mGraph.getMemberReference(classNode.name, methodNode.name, methodNode.desc);
            if (!oldMembers.contains(method)) {
                throw Shrinker.todo("added method");
            }
            Set<Dependency<T>> oldDeps = this.mGraph.getDependencies(method);
            Set<Dependency<T>> currentDeps = this.getDependencies(methodNode);
            for (Dependency addedDep : Sets.difference(currentDeps, oldDeps)) {
                this.mGraph.addDependency(method, addedDep.target, addedDep.type);
                for (ShrinkType shrinkType : keepRules.keySet()) {
                    if (!this.mGraph.isReachable(method, shrinkType)) continue;
                    this.incrementCounter(addedDep.target, addedDep.type, shrinkType);
                }
            }
            for (Dependency removedDep : Sets.difference(oldDeps, currentDeps)) {
                this.mGraph.removeDependency(method, removedDep);
                for (ShrinkType shrinkType : keepRules.keySet()) {
                    if (!this.mGraph.isReachable(method, shrinkType)) continue;
                    this.decrementCounter(removedDep.target, removedDep.type, shrinkType, modifiedClasses);
                }
            }
            oldMembers.remove(method);
        }
        if (!oldMembers.isEmpty()) {
            throw Shrinker.todo("deleted member");
        }
    }

    private void processNewClassFile(File classFile, Set<T> virtualMethods, Set<T> multipleInheritance, Set<UnresolvedReference<T>> unresolvedReferences) throws IOException {
        ClassNode classNode = new ClassNode(327680);
        DependencyFinderVisitor depsFinder = new DependencyFinderVisitor<T>(this.mGraph, (ClassVisitor)classNode, virtualMethods, unresolvedReferences, multipleInheritance){

            @Override
            protected void handleDependency(T source, T target, DependencyType type) {
                Shrinker.this.mGraph.addDependency(source, target, type);
            }
        };
        ClassStructureVisitor<T> structureVisitor = new ClassStructureVisitor<T>(this.mGraph, classFile, depsFinder);
        ClassReader classReader = new ClassReader(Files.toByteArray((File)classFile));
        classReader.accept(structureVisitor, 6);
    }

    public void run(Collection<TransformInput> inputs, Collection<TransformInput> referencedClasses, TransformOutputProvider output, ImmutableMap<ShrinkType, KeepRules> keepRules, boolean saveState) throws IOException {
        this.mGraph.removeStoredState();
        output.deleteAll();
        this.buildGraph(inputs, referencedClasses);
        this.setCounters(keepRules);
        this.writeOutput(inputs, output);
        if (saveState) {
            this.mGraph.saveState();
        }
    }

    private void writeOutput(Collection<TransformInput> inputs, TransformOutputProvider output) throws IOException {
        this.updateClassFiles(this.mGraph.getClassesToKeep(ShrinkType.SHRINK), inputs, output);
    }

    private void setCounters(ImmutableMap<ShrinkType, KeepRules> allKeepRules) {
        for (Map.Entry entry : allKeepRules.entrySet()) {
            ShrinkType shrinkType = (ShrinkType)((Object)entry.getKey());
            KeepRules keepRules = (KeepRules)entry.getValue();
            HashMap toIncrement = Maps.newHashMap();
            for (T t : this.mGraph.getAllProgramClasses()) {
                toIncrement.putAll(keepRules.getSymbolsToKeep(t, this.mGraph));
            }
            for (Map.Entry entry2 : toIncrement.entrySet()) {
                this.incrementCounter(entry2.getKey(), (DependencyType)((Object)entry2.getValue()), shrinkType);
            }
        }
    }

    private void updateClassFiles(Iterable<T> classesToWrite, Collection<TransformInput> inputs, TransformOutputProvider output) throws IOException {
        for (T klass : classesToWrite) {
            File classFile = this.mGraph.getClassFile(klass);
            Optional<File> outputFile = Shrinker.chooseOutputFile(classFile, inputs, output);
            if (!outputFile.isPresent()) continue;
            Files.createParentDirs((File)((File)outputFile.get()));
            Files.write((byte[])Shrinker.rewrite(classFile, this.mGraph.getMembersToKeep(klass, ShrinkType.SHRINK), new Predicate<String>(){

                public boolean apply(String input) {
                    return Shrinker.this.mGraph.keepClass(input, ShrinkType.SHRINK);
                }
            }), (File)((File)outputFile.get()));
        }
    }

    static class UnresolvedReference<T> {
        final T method;
        final T target;
        final int opcode;

        UnresolvedReference(T method, T target, int opcode) {
            this.method = method;
            this.target = target;
            this.opcode = opcode;
        }
    }

    public static enum ShrinkType {
        SHRINK,
        LEGACY_MULTIDEX;

    }
}

