/*
 * Decompiled with CFR 0.152.
 */
package com.android.dvlib;

import com.android.annotations.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DeviceSchema {
    public static final String NS_DEVICES_XSD = "http://schemas.android.com/sdk/devices/1";
    public static final String NODE_DEVICES = "devices";
    public static final String NODE_DEVICE = "device";
    public static final String NODE_HARDWARE = "hardware";
    public static final String NODE_SOFTWARE = "software";
    public static final String NODE_STATE = "state";
    public static final String NODE_KEYBOARD = "keyboard";
    public static final String NODE_TOUCH = "touch";
    public static final String NODE_GL_EXTENSIONS = "gl-extensions";
    public static final String NODE_GL_VERSION = "gl-version";
    public static final String NODE_NETWORKING = "networking";
    public static final String NODE_REMOVABLE_STORAGE = "removable-storage";
    public static final String NODE_FLASH = "flash";
    public static final String NODE_LIVE_WALLPAPER_SUPPORT = "live-wallpaper-support";
    public static final String NODE_STATUS_BAR = "status-bar";
    public static final String NODE_BUTTONS = "buttons";
    public static final String NODE_CAMERA = "camera";
    public static final String NODE_LOCATION = "location";
    public static final String NODE_GPU = "gpu";
    public static final String NODE_DOCK = "dock";
    public static final String NODE_YDPI = "ydpi";
    public static final String NODE_POWER_TYPE = "power-type";
    public static final String NODE_Y_DIMENSION = "y-dimension";
    public static final String NODE_SCREEN_RATIO = "screen-ratio";
    public static final String NODE_NAV_STATE = "nav-state";
    public static final String NODE_MIC = "mic";
    public static final String NODE_RAM = "ram";
    public static final String NODE_XDPI = "xdpi";
    public static final String NODE_DIMENSIONS = "dimensions";
    public static final String NODE_ABI = "abi";
    public static final String NODE_MECHANISM = "mechanism";
    public static final String NODE_MULTITOUCH = "multitouch";
    public static final String NODE_NAV = "nav";
    public static final String NODE_PIXEL_DENSITY = "pixel-density";
    public static final String NODE_SCREEN_ORIENTATION = "screen-orientation";
    public static final String NODE_AUTOFOCUS = "autofocus";
    public static final String NODE_SCREEN_SIZE = "screen-size";
    public static final String NODE_DESCRIPTION = "description";
    public static final String NODE_BLUETOOTH_PROFILES = "bluetooth-profiles";
    public static final String NODE_SCREEN = "screen";
    public static final String NODE_SENSORS = "sensors";
    public static final String NODE_DIAGONAL_LENGTH = "diagonal-length";
    public static final String NODE_SCREEN_TYPE = "screen-type";
    public static final String NODE_KEYBOARD_STATE = "keyboard-state";
    public static final String NODE_X_DIMENSION = "x-dimension";
    public static final String NODE_CPU = "cpu";
    public static final String NODE_INTERNAL_STORAGE = "internal-storage";
    public static final String NODE_META = "meta";
    public static final String NODE_ICONS = "icons";
    public static final String NODE_SIXTY_FOUR = "sixty-four";
    public static final String NODE_SIXTEEN = "sixteen";
    public static final String NODE_FRAME = "frame";
    public static final String NODE_PATH = "path";
    public static final String NODE_PORTRAIT_X_OFFSET = "portrait-x-offset";
    public static final String NODE_PORTRAIT_Y_OFFSET = "portrait-y-offset";
    public static final String NODE_LANDSCAPE_X_OFFSET = "landscape-x-offset";
    public static final String NODE_LANDSCAPE_Y_OFFSET = "landscape-y-offset";
    public static final String NODE_NAME = "name";
    public static final String NODE_ID = "id";
    public static final String NODE_API_LEVEL = "api-level";
    public static final String NODE_MANUFACTURER = "manufacturer";
    public static final String ATTR_DEFAULT = "default";
    public static final String ATTR_UNIT = "unit";
    public static final String ATTR_NAME = "name";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validate(InputStream deviceXml, OutputStream out, File parent) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        PrintWriter writer = new PrintWriter(out);
        try {
            Schema s = DeviceSchema.getSchema();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.setSchema(s);
            ValidationHandler validator = new ValidationHandler(parent, writer);
            SAXParser parser = factory.newSAXParser();
            parser.parse(deviceXml, (DefaultHandler)validator);
            boolean bl = validator.isValidDevicesFile();
            return bl;
        }
        catch (SAXException e) {
            writer.println(e.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (ParserConfigurationException e) {
            writer.println("Error creating SAX parser:");
            writer.println(e.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            writer.println("Error reading file stream:");
            writer.println(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            writer.flush();
        }
    }

    public static InputStream getXsdStream() {
        return DeviceSchema.class.getResourceAsStream("devices.xsd");
    }

    @Nullable
    public static Schema getSchema() throws SAXException {
        InputStream xsdStream = DeviceSchema.getXsdStream();
        if (xsdStream == null) {
            return null;
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(new StreamSource(xsdStream));
        return schema;
    }

    private static class ValidationHandler
    extends DefaultHandler {
        private boolean mValidDevicesFile = true;
        private boolean mDefaultSeen = false;
        private String mDeviceName;
        private final File mDirectory;
        private final PrintWriter mWriter;
        private final StringBuilder mStringAccumulator = new StringBuilder();

        public ValidationHandler(File directory, PrintWriter writer) {
            this.mDirectory = directory;
            this.mWriter = writer;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            String val;
            if (DeviceSchema.NODE_DEVICE.equals(localName)) {
                this.mDefaultSeen = false;
            } else if (DeviceSchema.NODE_STATE.equals(localName) && (val = attributes.getValue(DeviceSchema.ATTR_DEFAULT)) != null && ("1".equals(val) || Boolean.parseBoolean(val))) {
                if (this.mDefaultSeen) {
                    this.validationError("More than one default state for device " + this.mDeviceName);
                } else {
                    this.mDefaultSeen = true;
                }
            }
            this.mStringAccumulator.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.mStringAccumulator.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (DeviceSchema.NODE_DEVICE.equals(localName) && !this.mDefaultSeen) {
                this.validationError("No default state for device " + this.mDeviceName);
            } else if ("name".equals(localName)) {
                this.mDeviceName = this.mStringAccumulator.toString().trim();
            } else if (DeviceSchema.NODE_PATH.equals(localName) || DeviceSchema.NODE_SIXTY_FOUR.equals(localName) || DeviceSchema.NODE_SIXTEEN.equals(localName)) {
                if (this.mDirectory == null) {
                    this.validationError("No parent directory given, but relative paths exist.");
                    return;
                }
                String relativePath = this.mStringAccumulator.toString().trim();
                File f = new File(this.mDirectory, relativePath);
                if (f == null || !f.isFile()) {
                    this.validationError(relativePath + " is not a valid path.");
                    return;
                }
                String fileName = f.getName();
                int extensionStart = fileName.lastIndexOf(46);
                if (extensionStart == -1 || !fileName.substring(extensionStart + 1).equals("png")) {
                    this.validationError(relativePath + " is not a valid file type.");
                }
            }
        }

        @Override
        public void error(SAXParseException e) {
            this.validationError(e.getMessage());
        }

        @Override
        public void fatalError(SAXParseException e) {
            this.validationError(e.getMessage());
        }

        public boolean isValidDevicesFile() {
            return this.mValidDevicesFile;
        }

        private void validationError(String reason) {
            this.mWriter.println("Error: " + reason);
            this.mValidDevicesFile = false;
        }
    }
}

