/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.beans.PropertyUtils;
import com.atomikos.datasource.pool.Reapable;
import com.atomikos.datasource.xa.session.InvalidSessionHandleStateException;
import com.atomikos.datasource.xa.session.SessionHandleState;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.AbstractConnectionProxy;
import com.atomikos.jdbc.AtomikosSQLException;
import com.atomikos.jdbc.JdbcConnectionProxyHelper;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.ClassLoadingHelper;
import com.atomikos.util.DynamicProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class AtomikosConnectionProxy
extends AbstractConnectionProxy {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosConnectionProxy.class);
    private static final List ENLISTMENT_METHODS = Arrays.asList("createStatement", "prepareStatement", "prepareCall");
    private static final List CLOSE_METHODS = Arrays.asList("close");
    private static final List XA_INCOMPATIBLE_METHODS = Arrays.asList("commit", "rollback", "setSavepoint", "releaseSavepoint");
    private final Connection delegate;
    private SessionHandleState sessionHandleState;
    private boolean closed = false;
    private boolean reaped = false;
    private HeuristicMessage hmsg;
    private String toString;

    private AtomikosConnectionProxy(Connection c, SessionHandleState sessionHandleState, HeuristicMessage hmsg) {
        this.delegate = c;
        this.sessionHandleState = sessionHandleState;
        this.hmsg = hmsg;
        sessionHandleState.notifySessionBorrowed();
    }

    public String toString() {
        if (this.toString == null) {
            StringBuffer ret = new StringBuffer();
            ret.append("atomikos connection proxy for ");
            ret.append(this.delegate);
            this.toString = ret.toString();
        }
        return this.toString;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws SQLException {
        String methodName = method.getName();
        boolean jtaTxFound = false;
        if (methodName.equals("getInvocationHandler")) {
            return this;
        }
        if (methodName.equals("reap")) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo(this + ": reaping pending connection...");
            }
            this.reap();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug(this + ": reap done!");
            }
            return null;
        }
        if (methodName.equals("isClosed")) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo(this + ": isClosed()...");
            }
            Boolean ret = this.closed;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug(this + ": isClosed() returning " + ret);
            }
            return ret;
        }
        if (this.closed && !methodName.equals("close")) {
            if (this.reaped) {
                String msg = "Connection has been reaped - calling " + methodName + " is no longer allowed! Increase reapTimeout to avoid this problem.";
                AtomikosSQLException.throwAtomikosSQLException(msg);
            } else {
                String msg = "Connection was already closed - calling " + methodName + " is no longer allowed!";
                AtomikosSQLException.throwAtomikosSQLException(msg);
            }
            return null;
        }
        if (this.isEnlistedInGlobalTransaction()) {
            if (XA_INCOMPATIBLE_METHODS.contains(methodName)) {
                AtomikosSQLException.throwAtomikosSQLException("Cannot call method '" + methodName + "' while a global transaction is running");
            }
            if (methodName.equals("setAutoCommit") && args[0].equals(Boolean.TRUE)) {
                AtomikosSQLException.throwAtomikosSQLException("Cannot call 'setAutoCommit(true)' while a global transaction is running");
            }
            if (methodName.equals("getAutoCommit")) {
                return Boolean.FALSE;
            }
        }
        if (ENLISTMENT_METHODS.contains(methodName)) {
            try {
                jtaTxFound = this.enlist();
            }
            catch (Exception e) {
                this.sessionHandleState.notifySessionErrorOccurred();
                JdbcConnectionProxyHelper.convertProxyError(e, "Error enlisting in transaction - connection might be broken? Please check the logs for more information...");
            }
        }
        Object ret = null;
        if (CLOSE_METHODS.contains(methodName) && args == null) {
            this.close();
            return null;
        }
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo(this + ": calling " + methodName + "...");
            }
            ret = method.invoke((Object)this.delegate, args);
        }
        catch (Exception ex) {
            this.sessionHandleState.notifySessionErrorOccurred();
            JdbcConnectionProxyHelper.convertProxyError(ex, "Error delegating '" + methodName + "' call");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": " + methodName + " returning " + ret);
        }
        if (ret instanceof Statement) {
            Statement s = (Statement)ret;
            this.addStatement(s);
        }
        return ret;
    }

    private void reap() {
        LOGGER.logWarning(this + ": reaping - check if the application closes connections correctly, or increase the reapTimeout value");
        this.close();
        this.sessionHandleState.notifySessionErrorOccurred();
        this.reaped = true;
    }

    private CompositeTransactionManager getCompositeTransactionManager() {
        CompositeTransactionManager ret = Configuration.getCompositeTransactionManager();
        if (ret == null) {
            LOGGER.logWarning(this + ": WARNING: transaction manager not running?");
        }
        return ret;
    }

    private boolean enlist() throws AtomikosSQLException {
        boolean ret = false;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug(this + ": notifyBeforeUse " + this.sessionHandleState);
            }
            CompositeTransaction ct = null;
            CompositeTransactionManager ctm = this.getCompositeTransactionManager();
            if (ctm != null) {
                ct = ctm.getCompositeTransaction();
                this.sessionHandleState.notifyBeforeUse(ct, this.hmsg);
                if (ct != null && ct.getProperty("com.atomikos.icatch.jta.transaction") != null) {
                    ret = true;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.logDebug(this + ": detected transaction " + ct);
                    }
                    if (ct.getState().equals(TxState.ACTIVE)) {
                        ct.registerSynchronization((Synchronization)new JdbcRequeueSynchronization(this, ct));
                    } else {
                        AtomikosSQLException.throwAtomikosSQLException("The transaction has timed out - try increasing the timeout if needed");
                    }
                }
            }
        }
        catch (InvalidSessionHandleStateException ex) {
            AtomikosSQLException.throwAtomikosSQLException(ex.getMessage(), ex);
        }
        return ret;
    }

    private void close() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": close()...");
        }
        this.forceCloseAllPendingStatements(false);
        this.closed = true;
        this.sessionHandleState.notifySessionClosed();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": closed.");
        }
    }

    private boolean isEnlistedInGlobalTransaction() {
        CompositeTransactionManager compositeTransactionManager = this.getCompositeTransactionManager();
        if (compositeTransactionManager == null) {
            return false;
        }
        CompositeTransaction ct = compositeTransactionManager.getCompositeTransaction();
        return this.sessionHandleState.isActiveInTransaction(ct);
    }

    public static Reapable newInstance(Connection c, SessionHandleState sessionHandleState, HeuristicMessage hmsg) {
        Reapable ret = null;
        AtomikosConnectionProxy proxy = new AtomikosConnectionProxy(c, sessionHandleState, hmsg);
        Set interfaces = PropertyUtils.getAllImplementedInterfaces(c.getClass());
        interfaces.add(Reapable.class);
        interfaces.add(DynamicProxy.class);
        Class[] interfaceClasses = interfaces.toArray(new Class[0]);
        HashSet<Class<Connection>> minimumSetOfInterfaces = new HashSet<Class<Connection>>();
        minimumSetOfInterfaces.add(Reapable.class);
        minimumSetOfInterfaces.add(DynamicProxy.class);
        minimumSetOfInterfaces.add(Connection.class);
        Class[] minimumSetOfInterfaceClasses = minimumSetOfInterfaces.toArray(new Class[0]);
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        classLoaders.add(Thread.currentThread().getContextClassLoader());
        classLoaders.add(c.getClass().getClassLoader());
        classLoaders.add(AtomikosConnectionProxy.class.getClassLoader());
        ret = (Reapable)ClassLoadingHelper.newProxyInstance(classLoaders, (Class[])minimumSetOfInterfaceClasses, (Class[])interfaceClasses, (InvocationHandler)proxy);
        return ret;
    }

    private class JdbcRequeueSynchronization
    implements Synchronization {
        private static final long serialVersionUID = 1L;
        private CompositeTransaction compositeTransaction;
        private AbstractConnectionProxy proxy;
        private boolean afterCompletionDone;

        public JdbcRequeueSynchronization(AbstractConnectionProxy proxy, CompositeTransaction compositeTransaction) {
            this.compositeTransaction = compositeTransaction;
            this.proxy = proxy;
            this.afterCompletionDone = false;
        }

        public void afterCompletion(Object state) {
            if (this.afterCompletionDone) {
                return;
            }
            if (state.equals(TxState.ABORTING)) {
                AtomikosConnectionProxy.this.forceCloseAllPendingStatements(true);
            }
            if (state.equals(TxState.TERMINATED) || state.equals(TxState.HEUR_MIXED) || state.equals(TxState.HEUR_HAZARD) || state.equals(TxState.HEUR_ABORTED) || state.equals(TxState.HEUR_COMMITTED)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug(this.proxy + ": detected termination of transaction " + this.compositeTransaction);
                }
                AtomikosConnectionProxy.this.sessionHandleState.notifyTransactionTerminated(this.compositeTransaction);
                this.afterCompletionDone = true;
                AtomikosConnectionProxy.this.forceCloseAllPendingStatements(false);
            }
        }

        public void beforeCompletion() {
        }

        public boolean equals(Object other) {
            boolean ret = false;
            if (other instanceof JdbcRequeueSynchronization) {
                JdbcRequeueSynchronization o = (JdbcRequeueSynchronization)other;
                ret = this.compositeTransaction.isSameTransaction(o.compositeTransaction);
            }
            return ret;
        }

        public int hashCode() {
            return this.compositeTransaction.hashCode();
        }
    }
}

