/*
 * Decompiled with CFR 0.152.
 */
package expect4j;

import expect4j.BufferChangeLogger;
import expect4j.Consumer;
import expect4j.IOPair;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConsumerImpl
implements Consumer {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerImpl.class);
    public static final int BUFFERMAX = 16384;
    StringBuffer buffer;
    IOPair pair;
    boolean stopRequested = false;
    boolean foundEOF = false;
    List<BufferChangeLogger> bufferChangeLoggers;

    public ConsumerImpl(IOPair pair) {
        this.pair = pair;
        this.buffer = new StringBuffer();
        this.bufferChangeLoggers = Collections.synchronizedList(new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(String data) throws IOException {
        String printStr = null;
        if (logger.isDebugEnabled()) {
            printStr = data;
            printStr = printStr.replaceAll("\\r", "\\\\r");
            printStr = printStr.replaceAll("\\n", "\\\\n");
        }
        ConsumerImpl consumerImpl = this;
        synchronized (consumerImpl) {
            logger.debug("Sending to writer: " + printStr);
            Writer writer = this.pair.getWriter();
            writer.write(data);
            writer.flush();
        }
    }

    @Override
    public void resume() {
        this.resume(-1);
    }

    @Override
    public void stop() {
        logger.trace("Requesting the Consumer to stop processing data");
        this.stopRequested = true;
    }

    @Override
    public boolean foundEOF() {
        return this.foundEOF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerBufferChangeLogger(BufferChangeLogger logger) {
        boolean addedNewLogger = this.bufferChangeLoggers.add(logger);
        if (!addedNewLogger) {
            ConsumerImpl.logger.warn("Asked to register an already-registered logger, skipping duplicate request");
        } else {
            ConsumerImpl consumerImpl = this;
            synchronized (consumerImpl) {
                char[] existingData = this.buffer.toString().toCharArray();
                logger.bufferChanged(existingData, existingData.length);
            }
        }
    }

    @Override
    public void unregisterBufferChangeLogger(BufferChangeLogger logger) {
        boolean removedLogger = this.bufferChangeLoggers.remove(logger);
        if (!removedLogger) {
            ConsumerImpl.logger.warn("Asked to unregister a logger that was not registered, skipping removal request");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyBufferChange(char[] newData, int numChars) {
        List<BufferChangeLogger> list = this.bufferChangeLoggers;
        synchronized (list) {
            Iterator<BufferChangeLogger> iterator = this.bufferChangeLoggers.iterator();
            while (iterator.hasNext()) {
                iterator.next().bufferChanged(newData, numChars);
            }
        }
    }
}

