/*
 * Decompiled with CFR 0.152.
 */
package expect4j;

import expect4j.Closure;
import expect4j.ExpectEmulation;
import expect4j.ExpectState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class TclClosure
implements Closure {
    private static final Logger logger = LoggerFactory.getLogger(TclClosure.class);
    Interp interp;
    TclObject tclCode;

    public TclClosure(Interp interp, TclObject tclCode) {
        this.interp = interp;
        this.tclCode = tclCode;
    }

    @Override
    public void run(ExpectState state) throws Exception {
        int flags = 0;
        String buffer = state.getBuffer();
        logger.trace("Setting var expect_out(buffer) to " + buffer);
        this.interp.setVar("expect_out", "buffer", buffer, flags);
        int group = 0;
        while (true) {
            String match = state.getMatch(group);
            String index = group + ",string";
            ++group;
            if (match == null) break;
            logger.trace("Setting var expect_out(" + index + ") to " + match);
            this.interp.setVar("expect_out", index, match, flags);
        }
        ExpectEmulation.setExpContinue(this.interp, false);
        if (this.tclCode != null && this.tclCode.toString().length() > 0) {
            logger.debug("Running a tcl bit of code: " + this.tclCode.toString());
            try {
                this.interp.eval(this.tclCode, 0);
            }
            catch (TclException e) {
                logger.warn("Exception: " + (Object)((Object)e));
                throw new Exception(this.interp.getResult().toString(), e);
            }
            if (ExpectEmulation.isExpContinue(this.interp)) {
                logger.info("Asked to continue");
                state.exp_continue();
            }
        }
    }

    public String toString() {
        if (this.tclCode != null) {
            return this.tclCode.toString();
        }
        return null;
    }
}

