/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.common.base.Preconditions;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.concurrent.CancellationException;

class GrpcDirectStreamController<RequestT, ResponseT>
implements StreamController {
    private final ClientCall<RequestT, ResponseT> clientCall;
    private final ResponseObserver<ResponseT> responseObserver;
    private boolean hasStarted;
    private boolean autoflowControl = true;
    private int numRequested;
    private volatile CancellationException cancellationException;

    GrpcDirectStreamController(ClientCall<RequestT, ResponseT> clientCall, ResponseObserver<ResponseT> responseObserver) {
        this.clientCall = clientCall;
        this.responseObserver = responseObserver;
    }

    public void cancel() {
        this.cancellationException = new CancellationException("User cancelled stream");
        this.clientCall.cancel(null, (Throwable)this.cancellationException);
    }

    public void disableAutoInboundFlowControl() {
        Preconditions.checkState((!this.hasStarted ? 1 : 0) != 0, (Object)"Can't disable automatic flow control after the stream has started.");
        this.autoflowControl = false;
    }

    public void request(int count) {
        Preconditions.checkState((!this.autoflowControl ? 1 : 0) != 0, (Object)"Autoflow control is enabled.");
        if (!this.hasStarted) {
            this.numRequested += count;
        } else {
            this.clientCall.request(count);
        }
    }

    void start(RequestT request) {
        this.responseObserver.onStart((StreamController)this);
        this.hasStarted = true;
        this.clientCall.start((ClientCall.Listener)new ResponseObserverAdapter(), new Metadata());
        this.clientCall.sendMessage(request);
        this.clientCall.halfClose();
        if (this.autoflowControl) {
            this.clientCall.request(1);
        } else if (this.numRequested > 0) {
            this.clientCall.request(this.numRequested);
        }
    }

    private class ResponseObserverAdapter
    extends ClientCall.Listener<ResponseT> {
        private ResponseObserverAdapter() {
        }

        public void onMessage(ResponseT message) {
            GrpcDirectStreamController.this.responseObserver.onResponse(message);
            if (GrpcDirectStreamController.this.autoflowControl) {
                GrpcDirectStreamController.this.clientCall.request(1);
            }
        }

        public void onClose(Status status, Metadata trailers) {
            if (status.isOk()) {
                GrpcDirectStreamController.this.responseObserver.onComplete();
            } else if (GrpcDirectStreamController.this.cancellationException != null) {
                GrpcDirectStreamController.this.responseObserver.onError((Throwable)GrpcDirectStreamController.this.cancellationException);
            } else {
                GrpcDirectStreamController.this.responseObserver.onError((Throwable)status.asRuntimeException(trailers));
            }
        }
    }
}

