/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.AutoValue_ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@BetaApi
public abstract class ApiMessageHttpRequestFormatter<RequestT extends ApiMessage>
implements HttpRequestFormatter<RequestT> {
    public abstract String getResourceNameField();

    public abstract ResourceNameFactory getResourceNameFactory();

    public abstract Set<String> getQueryParamNames();

    @Override
    public abstract PathTemplate getPathTemplate();

    protected abstract Gson getRequestMarshaller();

    private static <RequestT extends ApiMessage> ApiMessageHttpRequestFormatter<RequestT> create(final RequestT requestInstance, Set<String> queryParams, String resourceNameField, ResourceNameFactory resourceNameFactory, PathTemplate pathTemplate) {
        final Gson baseGson = new GsonBuilder().create();
        TypeAdapter requestTypeAdapter = new TypeAdapter<RequestT>(){

            public void write(JsonWriter out, RequestT value) {
                baseGson.toJson(value, requestInstance.getClass(), out);
            }

            public RequestT read(JsonReader in) {
                return null;
            }
        };
        Gson requestMarshaller = new GsonBuilder().registerTypeAdapter(requestInstance.getClass(), (Object)requestTypeAdapter).create();
        return new AutoValue_ApiMessageHttpRequestFormatter(resourceNameField, resourceNameFactory, queryParams, pathTemplate, requestMarshaller);
    }

    public static <RequestT extends ApiMessage> Builder<RequestT> newBuilder() {
        return new Builder();
    }

    @Override
    public Map<String, List<String>> getQueryParamNames(RequestT apiMessage) {
        Set<String> paramNames = this.getQueryParamNames();
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        Map<String, List<String>> nullableParams = apiMessage.populateFieldsInMap(paramNames);
        for (Map.Entry<String, List<String>> pair : nullableParams.entrySet()) {
            if (pair.getValue() == null || pair.getValue().size() <= 0 || pair.getValue().get(0) == null) continue;
            queryParams.put(pair.getKey(), pair.getValue());
        }
        return queryParams;
    }

    @Override
    public String getRequestBody(ApiMessage apiMessage) {
        ApiMessage body = apiMessage.getApiMessageRequestBody();
        if (body != null) {
            return this.getRequestMarshaller().toJson((Object)body);
        }
        return null;
    }

    @Override
    public String getPath(RequestT apiMessage) {
        Map<String, String> pathParams = this.getPathParams(apiMessage);
        return this.getPathTemplate().instantiate(pathParams);
    }

    private Map<String, String> getPathParams(RequestT apiMessage) {
        String resourceNamePath = apiMessage.getFieldStringValue(this.getResourceNameField());
        if (resourceNamePath == null) {
            throw new IllegalArgumentException(String.format("Resource name field %s is null in message object.", this.getResourceNameField()));
        }
        return this.getResourceNameFactory().parse(resourceNamePath).getFieldValuesMap();
    }

    public static class Builder<RequestT extends ApiMessage> {
        private RequestT requestInstance;
        private String resourceNameField;
        private ResourceNameFactory resourceNameFactory;
        private Set<String> queryParams;
        private PathTemplate pathTemplate;

        private Builder() {
        }

        public Builder<RequestT> setRequestInstance(RequestT requestInstance) {
            this.requestInstance = requestInstance;
            return this;
        }

        public Builder<RequestT> setResourceNameField(String resourceNameField) {
            this.resourceNameField = resourceNameField;
            return this;
        }

        public Builder<RequestT> setResourceNameFactory(ResourceNameFactory resourceNameFactory) {
            this.resourceNameFactory = resourceNameFactory;
            return this;
        }

        public Builder<RequestT> setPathTemplate(PathTemplate pathTemplate) {
            this.pathTemplate = pathTemplate;
            return this;
        }

        public Builder<RequestT> setQueryParams(Set<String> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public ApiMessageHttpRequestFormatter<RequestT> build() {
            return ApiMessageHttpRequestFormatter.create(this.requestInstance, this.queryParams, this.resourceNameField, this.resourceNameFactory, this.pathTemplate);
        }
    }
}

