/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.ResolvedBindings;
import dagger.model.RequestKind;

abstract class BindingExpression {
    private final ResolvedBindings resolvedBindings;
    private final RequestKind requestKind;

    BindingExpression(ResolvedBindings resolvedBindings, RequestKind requestKind) {
        this.resolvedBindings = (ResolvedBindings)Preconditions.checkNotNull((Object)resolvedBindings);
        this.requestKind = (RequestKind)Preconditions.checkNotNull((Object)requestKind);
    }

    final BindingKey bindingKey() {
        return this.resolvedBindings.bindingKey();
    }

    final RequestKind requestKind() {
        return this.requestKind;
    }

    final ResolvedBindings resolvedBindings() {
        return this.resolvedBindings;
    }

    abstract Expression getDependencyExpression(ClassName var1);

    final CodeBlock getComponentMethodImplementation(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ClassName requestingClass) {
        DependencyRequest request = componentMethod.dependencyRequest().get();
        Preconditions.checkArgument((boolean)request.bindingKey().equals(this.bindingKey()));
        Preconditions.checkArgument((boolean)request.kind().equals((Object)this.requestKind()));
        return this.doGetComponentMethodImplementation(componentMethod, requestingClass);
    }

    protected CodeBlock doGetComponentMethodImplementation(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ClassName requestingClass) {
        return CodeBlock.of((String)"return $L;", (Object[])new Object[]{this.getDependencyExpression(requestingClass).codeBlock()});
    }
}

