/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import dagger.internal.codegen.AutoValue_BindingNetwork_ComponentNode;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingDeclaration;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentTreeTraverser;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.ForwardingNetwork;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SubcomponentDeclaration;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public final class BindingNetwork
extends ForwardingNetwork<Node, Edge> {
    static BindingNetwork create(BindingGraph graph) {
        Factory factory = new Factory(graph);
        factory.traverseComponents();
        return factory.bindingNetwork();
    }

    private BindingNetwork(Network<Node, Edge> bindingNetwork) {
        super(ImmutableNetwork.copyOf(bindingNetwork));
    }

    public ImmutableSet<BindingNode> bindingNodes() {
        return this.bindingNodesStream().collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<BindingNode> bindingNodes(BindingKey bindingKey) {
        return this.bindingNodesStream().filter(node -> node.bindingKey().equals(bindingKey)).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<ComponentNode> componentNodes() {
        return this.componentNodeStream().collect(DaggerStreams.toImmutableSet());
    }

    public Optional<ComponentNode> componentNode(ComponentTreeTraverser.ComponentTreePath component) {
        return this.componentNodeStream().filter(node -> node.componentTreePath().equals(component)).findFirst();
    }

    public ImmutableSet<ComponentNode> componentNodes(TypeElement component) {
        return this.componentNodeStream().filter(node -> node.componentTreePath().currentComponent().equals(component)).collect(DaggerStreams.toImmutableSet());
    }

    public ComponentNode rootComponentNode() {
        return this.componentNodeStream().filter(node -> node.componentTreePath().atRoot()).findFirst().get();
    }

    public ImmutableSet<DependencyEdge> dependencyEdges() {
        return this.dependencyEdgeStream().collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableMap<DependencyRequest, DependencyEdge> dependencyEdges(BindingNode bindingNode) {
        return this.outEdges(bindingNode).stream().flatMap(DaggerStreams.instancesOf(DependencyEdge.class)).collect(DaggerStreams.toImmutableMap(DependencyEdge::dependencyRequest, edge -> edge));
    }

    public ImmutableSet<DependencyEdge> dependencyEdges(DependencyRequest dependencyRequest) {
        return this.dependencyEdgeStream().filter(edge -> edge.dependencyRequest().equals(dependencyRequest)).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<DependencyEdge> entryPointEdges() {
        return this.entryPointEdgeStream().collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<DependencyEdge> entryPointEdges(ComponentTreeTraverser.ComponentTreePath component) {
        return this.outEdges((Node)this.componentNode(component).get()).stream().flatMap(DaggerStreams.instancesOf(DependencyEdge.class)).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<BindingNode> entryPointBindingNodes() {
        return this.entryPointEdgeStream().map(edge -> (BindingNode)this.incidentNodes(edge).target()).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<DependencyEdge> entryPointEdgesDependingOnBindingNode(BindingNode bindingNode) {
        MutableNetwork subgraphDependingOnBindingNode = Graphs.inducedSubgraph((Network)this, (Iterable)Graphs.reachableNodes((Graph)Graphs.transpose((Network)this).asGraph(), (Object)bindingNode));
        return ImmutableSet.copyOf((Collection)Sets.intersection(this.entryPointEdges(), (Set)subgraphDependingOnBindingNode.edges()));
    }

    private Stream<BindingNode> bindingNodesStream() {
        return this.nodes().stream().flatMap(DaggerStreams.instancesOf(BindingNode.class));
    }

    private Stream<ComponentNode> componentNodeStream() {
        return this.nodes().stream().flatMap(DaggerStreams.instancesOf(ComponentNode.class));
    }

    private Stream<DependencyEdge> dependencyEdgeStream() {
        return this.edges().stream().flatMap(DaggerStreams.instancesOf(DependencyEdge.class));
    }

    private Stream<DependencyEdge> entryPointEdgeStream() {
        return this.dependencyEdgeStream().filter(DependencyEdge::isEntryPoint);
    }

    private static class Factory
    extends ComponentTreeTraverser {
        private final MutableNetwork<Node, Edge> network = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
        private ComponentNode parentComponent;
        private ComponentNode currentComponent;

        Factory(BindingGraph graph) {
            super(graph);
        }

        @Override
        protected void visitComponent(BindingGraph graph) {
            ComponentNode grandparentNode = this.parentComponent;
            this.parentComponent = this.currentComponent;
            this.currentComponent = ComponentNode.create(this.componentTreePath());
            this.network.addNode((Object)this.currentComponent);
            super.visitComponent(graph);
            this.currentComponent = this.parentComponent;
            this.parentComponent = grandparentNode;
        }

        @Override
        protected void visitSubcomponentFactoryMethod(BindingGraph graph, BindingGraph parent, ExecutableElement factoryMethod) {
            this.network.addEdge((Object)this.parentComponent, (Object)this.currentComponent, (Object)new ChildFactoryMethodEdge(factoryMethod));
            super.visitSubcomponentFactoryMethod(graph, parent, factoryMethod);
        }

        @Override
        protected ComponentTreeTraverser.BindingGraphTraverser bindingGraphTraverser(ComponentTreeTraverser.ComponentTreePath componentPath, DependencyRequest entryPoint) {
            return new BindingGraphVisitor(componentPath, entryPoint);
        }

        BindingNetwork bindingNetwork() {
            return new BindingNetwork((Network)this.network);
        }

        private final class BindingGraphVisitor
        extends ComponentTreeTraverser.BindingGraphTraverser {
            private Node current;

            BindingGraphVisitor(ComponentTreeTraverser.ComponentTreePath componentPath, DependencyRequest entryPoint) {
                super(componentPath, entryPoint);
                this.current = Factory.this.currentComponent;
                Factory.this.network.addNode((Object)this.current);
            }

            @Override
            protected void visitBinding(Binding binding, ComponentDescriptor owningComponent) {
                ContributionBinding contributionBinding;
                Node previous = this.current;
                this.current = this.newBindingNode(this.resolvedBindings(), binding, owningComponent);
                Factory.this.network.addNode((Object)this.current);
                if (binding instanceof ContributionBinding && (contributionBinding = (ContributionBinding)binding).bindingKind().equals((Object)ContributionBinding.Kind.SUBCOMPONENT_BUILDER)) {
                    Factory.this.network.addEdge((Object)this.current, (Object)this.subcomponentNode(contributionBinding, owningComponent), (Object)new SubcomponentBuilderBindingEdge((Iterable)this.resolvedBindings().subcomponentDeclarations()));
                }
                if (Factory.this.network.edgesConnecting((Object)previous, (Object)this.current).stream().flatMap(DaggerStreams.instancesOf(DependencyEdge.class)).noneMatch(e -> e.dependencyRequest().equals(this.dependencyRequest()))) {
                    Factory.this.network.addEdge((Object)previous, (Object)this.current, (Object)new DependencyEdge(this.dependencyRequest(), this.atEntryPoint()));
                    super.visitBinding(binding, owningComponent);
                }
                this.current = previous;
            }

            private ComponentNode subcomponentNode(ContributionBinding binding, ComponentDescriptor subcomponentParent) {
                Preconditions.checkArgument((boolean)binding.bindingKind().equals((Object)ContributionBinding.Kind.SUBCOMPONENT_BUILDER));
                TypeElement builderType = MoreTypes.asTypeElement(binding.key().type());
                TypeElement subcomponentType = MoreElements.asType(builderType.getEnclosingElement());
                ComponentTreeTraverser.ComponentTreePath childPath = this.componentTreePath().pathFromRootToAncestor(subcomponentParent).childPath(subcomponentType);
                ComponentNode childNode = ComponentNode.create(childPath);
                Factory.this.network.addNode((Object)childNode);
                return childNode;
            }

            private BindingNode newBindingNode(ResolvedBindings resolvedBindings, Binding binding, ComponentDescriptor owningComponent) {
                return new BindingNode(this.componentTreePath().pathFromRootToAncestor(owningComponent), binding, Iterables.concat(resolvedBindings.multibindingDeclarations(), resolvedBindings.optionalBindingDeclarations(), resolvedBindings.subcomponentDeclarations()));
            }
        }
    }

    public static abstract class ComponentNode
    implements Node {
        @Override
        public abstract ComponentTreeTraverser.ComponentTreePath componentTreePath();

        private static ComponentNode create(ComponentTreeTraverser.ComponentTreePath component) {
            return new AutoValue_BindingNetwork_ComponentNode(component);
        }
    }

    public static final class BindingNode
    implements Node {
        private final ComponentTreeTraverser.ComponentTreePath component;
        private final Binding binding;
        private final ImmutableSet<BindingDeclaration> associatedDeclarations;

        private BindingNode(ComponentTreeTraverser.ComponentTreePath component, Binding binding, Iterable<BindingDeclaration> associatedDeclarations) {
            this.component = component;
            this.binding = binding;
            this.associatedDeclarations = ImmutableSet.copyOf(associatedDeclarations);
        }

        @Override
        public ComponentTreeTraverser.ComponentTreePath componentTreePath() {
            return this.component;
        }

        Binding binding() {
            return this.binding;
        }

        public BindingKey bindingKey() {
            switch (this.binding.bindingType()) {
                case MEMBERS_INJECTION: {
                    return BindingKey.membersInjection(this.binding.key());
                }
                case PRODUCTION: 
                case PROVISION: {
                    return BindingKey.contribution(this.binding.key());
                }
            }
            throw new AssertionError(this.binding);
        }

        public ImmutableSet<BindingDeclaration> associatedDeclarations() {
            return this.associatedDeclarations;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("component", (Object)this.component).add("binding", (Object)this.binding).add("associatedDeclarations", this.associatedDeclarations).toString();
        }
    }

    public static interface Node {
        public ComponentTreeTraverser.ComponentTreePath componentTreePath();
    }

    public static final class SubcomponentBuilderBindingEdge
    implements Edge {
        private final ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations;

        private SubcomponentBuilderBindingEdge(Iterable<SubcomponentDeclaration> subcomponentDeclarations) {
            this.subcomponentDeclarations = ImmutableSet.copyOf(subcomponentDeclarations);
        }

        public ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations() {
            return this.subcomponentDeclarations;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("subcomponentDeclarations", this.subcomponentDeclarations).toString();
        }
    }

    public static final class ChildFactoryMethodEdge
    implements Edge {
        private final ExecutableElement factoryMethod;

        private ChildFactoryMethodEdge(ExecutableElement factoryMethod) {
            this.factoryMethod = factoryMethod;
        }

        public ExecutableElement factoryMethod() {
            return this.factoryMethod;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("factoryMethod", (Object)this.factoryMethod).toString();
        }
    }

    public static final class DependencyEdge
    implements Edge {
        private final DependencyRequest dependencyRequest;
        private final boolean entryPoint;

        private DependencyEdge(DependencyRequest dependencyRequest, boolean entryPoint) {
            this.dependencyRequest = dependencyRequest;
            this.entryPoint = entryPoint;
        }

        public DependencyRequest dependencyRequest() {
            return this.dependencyRequest;
        }

        public boolean isEntryPoint() {
            return this.entryPoint;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("dependencyRequest", (Object)this.dependencyRequest).add("entryPoint", this.entryPoint).toString();
        }
    }

    public static interface Edge {
    }
}

