/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.Binds;
import dagger.Module;
import dagger.internal.codegen.BindingMethodValidator;
import dagger.internal.codegen.BindsTypeChecker;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProducerModule;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class BindsMethodValidator
extends BindingMethodValidator {
    private final Types types;
    private final BindsTypeChecker bindsTypeChecker;

    BindsMethodValidator(Elements elements, Types types) {
        super(elements, types, Binds.class, (Iterable<? extends Class<? extends Annotation>>)ImmutableSet.of(Module.class, ProducerModule.class), BindingMethodValidator.Abstractness.MUST_BE_ABSTRACT, BindingMethodValidator.ExceptionSuperclass.RUNTIME_EXCEPTION, BindingMethodValidator.AllowsMultibindings.ALLOWS_MULTIBINDINGS);
        this.types = types;
        this.bindsTypeChecker = new BindsTypeChecker(types, elements);
    }

    @Override
    protected void checkMethod(ValidationReport.Builder<ExecutableElement> builder) {
        super.checkMethod(builder);
        this.checkParameters(builder);
    }

    private void checkParameters(ValidationReport.Builder<ExecutableElement> builder) {
        ExecutableElement method = builder.getSubject();
        List<? extends VariableElement> parameters = method.getParameters();
        if (parameters.size() == 1) {
            VariableElement parameter = (VariableElement)Iterables.getOnlyElement(parameters);
            TypeMirror leftHandSide = this.boxIfNecessary(method.getReturnType());
            TypeMirror rightHandSide = parameter.asType();
            ContributionType contributionType = ContributionType.fromBindingMethod(method);
            if (contributionType.equals((Object)ContributionType.SET_VALUES) && !SetType.isSet(leftHandSide)) {
                builder.addError("@Binds @ElementsIntoSet methods must return a Set and take a Set parameter");
            }
            if (!this.bindsTypeChecker.isAssignable(rightHandSide, leftHandSide, contributionType)) {
                builder.addError("@Binds methods must have only one parameter whose type is assignable to the return type");
            }
        } else {
            builder.addError("@Binds methods must have only one parameter whose type is assignable to the return type");
        }
    }

    private TypeMirror boxIfNecessary(TypeMirror maybePrimitive) {
        if (maybePrimitive.getKind().isPrimitive()) {
            return this.types.boxedClass(MoreTypes.asPrimitiveType(maybePrimitive)).asType();
        }
        return maybePrimitive;
    }
}

