/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BoundInstanceBindingExpression;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentInstanceBindingExpression;
import dagger.internal.codegen.ComponentProvisionBindingExpression;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ComponentRequirementFields;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DelegateBindingExpression;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.FrameworkFieldInitializer;
import dagger.internal.codegen.FrameworkInstanceBindingExpression;
import dagger.internal.codegen.FrameworkType;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.MapBindingExpression;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.MembersInjectionBindingExpression;
import dagger.internal.codegen.MembersInjectionMethods;
import dagger.internal.codegen.MembersInjectorFieldInitializer;
import dagger.internal.codegen.OptionalBindingExpression;
import dagger.internal.codegen.OptionalFactories;
import dagger.internal.codegen.PrivateMethodBindingExpression;
import dagger.internal.codegen.ProducerFromProviderFieldInitializer;
import dagger.internal.codegen.ProviderOrProducerFieldInitializer;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ReferenceReleasingManagerFields;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SetBindingExpression;
import dagger.internal.codegen.SimpleMethodBindingExpression;
import dagger.internal.codegen.SubcomponentBuilderBindingExpression;
import dagger.internal.codegen.SubcomponentNames;
import dagger.model.RequestKind;
import java.util.EnumSet;
import java.util.Optional;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

final class ComponentBindingExpressions {
    private final Optional<ComponentBindingExpressions> parent;
    private final BindingGraph graph;
    private final DaggerTypes types;
    private final BindingExpressionFactory bindingExpressionFactory;
    private final Table<BindingKey, RequestKind, BindingExpression> expressions = HashBasedTable.create();

    ComponentBindingExpressions(BindingGraph graph, GeneratedComponentModel generatedComponentModel, SubcomponentNames subcomponentNames, ComponentRequirementFields componentRequirementFields, OptionalFactories optionalFactories, DaggerTypes types, Elements elements, CompilerOptions compilerOptions) {
        this(Optional.empty(), graph, generatedComponentModel, subcomponentNames, componentRequirementFields, new ReferenceReleasingManagerFields(graph, generatedComponentModel), optionalFactories, types, elements, compilerOptions);
    }

    private ComponentBindingExpressions(Optional<ComponentBindingExpressions> parent, BindingGraph graph, GeneratedComponentModel generatedComponentModel, SubcomponentNames subcomponentNames, ComponentRequirementFields componentRequirementFields, ReferenceReleasingManagerFields referenceReleasingManagerFields, OptionalFactories optionalFactories, DaggerTypes types, Elements elements, CompilerOptions compilerOptions) {
        this.parent = parent;
        this.graph = graph;
        this.types = types;
        this.bindingExpressionFactory = new BindingExpressionFactory(graph, generatedComponentModel, subcomponentNames, this, componentRequirementFields, referenceReleasingManagerFields, optionalFactories, types, elements, compilerOptions);
    }

    ComponentBindingExpressions forChildComponent(BindingGraph childGraph, GeneratedComponentModel childComponentModel, ComponentRequirementFields childComponentRequirementFields) {
        return new ComponentBindingExpressions(Optional.of(this), childGraph, childComponentModel, this.bindingExpressionFactory.subcomponentNames, childComponentRequirementFields, this.bindingExpressionFactory.referenceReleasingManagerFields, this.bindingExpressionFactory.optionalFactories, this.bindingExpressionFactory.types, this.bindingExpressionFactory.elements, this.bindingExpressionFactory.compilerOptions);
    }

    Expression getDependencyExpression(BindingKey bindingKey, RequestKind requestKind, ClassName requestingClass) {
        return this.getBindingExpression(bindingKey, requestKind).getDependencyExpression(requestingClass);
    }

    Expression getDependencyExpression(DependencyRequest request, ClassName requestingClass) {
        return this.getDependencyExpression(request.bindingKey(), request.kind(), requestingClass);
    }

    Expression getDependencyExpression(FrameworkDependency frameworkDependency, ClassName requestingClass) {
        return this.getDependencyExpression(frameworkDependency.bindingKey(), frameworkDependency.dependencyRequestKind(), requestingClass);
    }

    Expression getDependencyArgumentExpression(DependencyRequest dependencyRequest, ClassName requestingClass) {
        TypeMirror dependencyType = dependencyRequest.key().type();
        Expression dependencyExpression = this.getDependencyExpression(dependencyRequest, requestingClass);
        if (!Accessibility.isTypeAccessibleFrom(dependencyType, requestingClass.packageName()) && Accessibility.isRawTypeAccessible(dependencyType, requestingClass.packageName())) {
            return dependencyExpression.castTo(this.types.erasure(dependencyType));
        }
        return dependencyExpression;
    }

    CodeBlock getComponentMethodImplementation(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ClassName requestingClass) {
        return this.getBindingExpression(componentMethod.dependencyRequest().get().bindingKey(), componentMethod.dependencyRequest().get().kind()).getComponentMethodImplementation(componentMethod, requestingClass);
    }

    private BindingExpression getBindingExpression(BindingKey bindingKey, RequestKind requestKind) {
        if (this.graph.resolvedBindings().containsKey((Object)bindingKey) && !((ResolvedBindings)this.graph.resolvedBindings().get((Object)bindingKey)).ownedBindings().isEmpty()) {
            if (!this.expressions.contains((Object)bindingKey, (Object)requestKind)) {
                this.expressions.put((Object)bindingKey, (Object)requestKind, (Object)this.bindingExpressionFactory.create(bindingKey, requestKind));
            }
            return (BindingExpression)this.expressions.get((Object)bindingKey, (Object)requestKind);
        }
        return this.parent.map(p -> p.getBindingExpression(bindingKey, requestKind)).orElseThrow(() -> new IllegalStateException(String.format("no expression found for %s-%s", bindingKey, requestKind)));
    }

    private static final class BindingExpressionFactory {
        private static final ImmutableSet<ContributionBinding.Kind> PRIVATE_METHOD_KINDS = ImmutableSet.copyOf(EnumSet.of(ContributionBinding.Kind.SYNTHETIC_MULTIBOUND_SET, ContributionBinding.Kind.SYNTHETIC_MULTIBOUND_MAP, ContributionBinding.Kind.INJECTION, ContributionBinding.Kind.PROVISION));
        private final BindingGraph graph;
        private final GeneratedComponentModel generatedComponentModel;
        private final ComponentBindingExpressions componentBindingExpressions;
        private final ComponentRequirementFields componentRequirementFields;
        private final ReferenceReleasingManagerFields referenceReleasingManagerFields;
        private final SubcomponentNames subcomponentNames;
        private final OptionalFactories optionalFactories;
        private final CompilerOptions compilerOptions;
        private final DaggerTypes types;
        private final Elements elements;
        private final MembersInjectionMethods membersInjectionMethods;

        BindingExpressionFactory(BindingGraph graph, GeneratedComponentModel generatedComponentModel, SubcomponentNames subcomponentNames, ComponentBindingExpressions componentBindingExpressions, ComponentRequirementFields componentRequirementFields, ReferenceReleasingManagerFields referenceReleasingManagerFields, OptionalFactories optionalFactories, DaggerTypes types, Elements elements, CompilerOptions compilerOptions) {
            this.graph = graph;
            this.generatedComponentModel = (GeneratedComponentModel)Preconditions.checkNotNull((Object)generatedComponentModel);
            this.subcomponentNames = (SubcomponentNames)Preconditions.checkNotNull((Object)subcomponentNames);
            this.componentBindingExpressions = componentBindingExpressions;
            this.componentRequirementFields = (ComponentRequirementFields)Preconditions.checkNotNull((Object)componentRequirementFields);
            this.referenceReleasingManagerFields = (ReferenceReleasingManagerFields)Preconditions.checkNotNull((Object)referenceReleasingManagerFields);
            this.optionalFactories = (OptionalFactories)Preconditions.checkNotNull((Object)optionalFactories);
            this.types = types;
            this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
            this.compilerOptions = (CompilerOptions)Preconditions.checkNotNull((Object)compilerOptions);
            this.membersInjectionMethods = new MembersInjectionMethods(generatedComponentModel, componentBindingExpressions, graph, elements, types);
        }

        BindingExpression create(BindingKey bindingKey, RequestKind requestKind) {
            ResolvedBindings resolvedBindings = (ResolvedBindings)this.graph.resolvedBindings().get((Object)bindingKey);
            switch (resolvedBindings.bindingType()) {
                case MEMBERS_INJECTION: {
                    return this.membersInjectionBindingExpression(resolvedBindings, requestKind);
                }
                case PROVISION: {
                    return this.provisionBindingExpression(resolvedBindings, requestKind);
                }
                case PRODUCTION: {
                    return this.frameworkInstanceBindingExpression(resolvedBindings, requestKind);
                }
            }
            throw new AssertionError(resolvedBindings);
        }

        private MembersInjectionBindingExpression membersInjectionBindingExpression(ResolvedBindings resolvedBindings, RequestKind requestKind) {
            return new MembersInjectionBindingExpression(this.frameworkInstanceBindingExpression(resolvedBindings, requestKind), this.generatedComponentModel, this.membersInjectionMethods);
        }

        private FrameworkInstanceBindingExpression frameworkInstanceBindingExpression(ResolvedBindings resolvedBindings, RequestKind requestKind) {
            Optional<MemberSelect> staticMethod = MemberSelect.staticMemberSelect(resolvedBindings);
            return new FrameworkInstanceBindingExpression(resolvedBindings, requestKind, this.componentBindingExpressions, resolvedBindings.bindingType().frameworkType(), staticMethod.isPresent() ? staticMethod::get : this.frameworkFieldInitializer(resolvedBindings), this.types, this.elements);
        }

        private FrameworkFieldInitializer frameworkFieldInitializer(ResolvedBindings resolvedBindings) {
            switch (resolvedBindings.bindingType()) {
                case PROVISION: 
                case PRODUCTION: {
                    return new ProviderOrProducerFieldInitializer(resolvedBindings, this.subcomponentNames, this.generatedComponentModel, this.componentBindingExpressions, this.componentRequirementFields, this.referenceReleasingManagerFields, this.compilerOptions, this.graph, this.optionalFactories);
                }
                case MEMBERS_INJECTION: {
                    return new MembersInjectorFieldInitializer(resolvedBindings, this.generatedComponentModel, this.componentBindingExpressions);
                }
            }
            throw new AssertionError(resolvedBindings);
        }

        private BindingExpression provisionBindingExpression(ResolvedBindings resolvedBindings, RequestKind requestKind) {
            FrameworkInstanceBindingExpression frameworkInstanceBindingExpression = requestKind.equals((Object)RequestKind.PRODUCER) ? this.producerFromProviderInstanceBindingExpression(resolvedBindings, requestKind) : this.frameworkInstanceBindingExpression(resolvedBindings, requestKind);
            BindingExpression inlineBindingExpression = this.inlineProvisionBindingExpression(frameworkInstanceBindingExpression);
            if (this.usePrivateMethod(resolvedBindings.contributionBinding())) {
                return new PrivateMethodBindingExpression(this.generatedComponentModel, this.componentBindingExpressions, inlineBindingExpression, this.referenceReleasingManagerFields, this.compilerOptions, this.types, this.elements);
            }
            return inlineBindingExpression;
        }

        private FrameworkInstanceBindingExpression producerFromProviderInstanceBindingExpression(ResolvedBindings resolvedBindings, RequestKind requestKind) {
            Preconditions.checkArgument((boolean)resolvedBindings.bindingType().frameworkType().equals((Object)FrameworkType.PROVIDER));
            return new FrameworkInstanceBindingExpression(resolvedBindings, requestKind, this.componentBindingExpressions, FrameworkType.PRODUCER, new ProducerFromProviderFieldInitializer(resolvedBindings, this.generatedComponentModel, this.componentBindingExpressions), this.types, this.elements);
        }

        private BindingExpression inlineProvisionBindingExpression(BindingExpression bindingExpression) {
            ProvisionBinding provisionBinding = (ProvisionBinding)bindingExpression.resolvedBindings().contributionBinding();
            switch (provisionBinding.bindingKind()) {
                case COMPONENT: {
                    return new ComponentInstanceBindingExpression(bindingExpression, provisionBinding, this.generatedComponentModel.name(), this.types);
                }
                case COMPONENT_DEPENDENCY: {
                    return new BoundInstanceBindingExpression(bindingExpression, ComponentRequirement.forDependency(provisionBinding.key().type()), this.componentRequirementFields, this.types);
                }
                case COMPONENT_PROVISION: {
                    return new ComponentProvisionBindingExpression(bindingExpression, provisionBinding, this.graph, this.componentRequirementFields, this.compilerOptions, this.types);
                }
                case SUBCOMPONENT_BUILDER: {
                    return new SubcomponentBuilderBindingExpression(bindingExpression, provisionBinding, this.subcomponentNames.get(bindingExpression.bindingKey()), this.types);
                }
                case SYNTHETIC_MULTIBOUND_SET: {
                    return new SetBindingExpression(provisionBinding, this.graph, this.componentBindingExpressions, bindingExpression, this.types, this.elements);
                }
                case SYNTHETIC_MULTIBOUND_MAP: {
                    return new MapBindingExpression(provisionBinding, this.graph, this.componentBindingExpressions, bindingExpression, this.types, this.elements);
                }
                case SYNTHETIC_OPTIONAL_BINDING: {
                    return new OptionalBindingExpression(provisionBinding, bindingExpression, this.componentBindingExpressions, this.types);
                }
                case SYNTHETIC_DELEGATE_BINDING: {
                    return DelegateBindingExpression.create(this.graph, bindingExpression, this.componentBindingExpressions, this.types, this.elements);
                }
                case BUILDER_BINDING: {
                    return new BoundInstanceBindingExpression(bindingExpression, ComponentRequirement.forBinding(provisionBinding), this.componentRequirementFields, this.types);
                }
                case INJECTION: 
                case PROVISION: {
                    if (!this.canUseSimpleMethod(provisionBinding)) break;
                    return new SimpleMethodBindingExpression(this.compilerOptions, provisionBinding, bindingExpression, this.componentBindingExpressions, this.membersInjectionMethods, this.componentRequirementFields, this.types, this.elements);
                }
            }
            return bindingExpression;
        }

        private boolean usePrivateMethod(ContributionBinding binding) {
            return (!binding.scope().isPresent() || this.compilerOptions.experimentalAndroidMode()) && PRIVATE_METHOD_KINDS.contains((Object)binding.bindingKind());
        }

        private boolean canUseSimpleMethod(ContributionBinding binding) {
            return !binding.scope().isPresent() || this.compilerOptions.experimentalAndroidMode() && !this.referenceReleasingManagerFields.requiresReleasableReferences(binding.scope().get());
        }
    }
}

