/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.AbstractComponentWriter;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ComponentRequirementFields;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.KeyFactory;
import dagger.internal.codegen.OptionalFactories;
import dagger.internal.codegen.SubcomponentNames;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

final class ComponentWriter
extends AbstractComponentWriter {
    static TypeSpec.Builder write(DaggerTypes types, Elements elements, KeyFactory keyFactory, CompilerOptions compilerOptions, ClassName name, BindingGraph graph) {
        GeneratedComponentModel generatedComponentModel = GeneratedComponentModel.forComponent(name);
        SubcomponentNames subcomponentNames = new SubcomponentNames(graph, keyFactory);
        ComponentRequirementFields componentRequirementFields = new ComponentRequirementFields();
        OptionalFactories optionalFactories = new OptionalFactories();
        ComponentBindingExpressions bindingExpressions = new ComponentBindingExpressions(graph, generatedComponentModel, subcomponentNames, componentRequirementFields, optionalFactories, types, elements, compilerOptions);
        return new ComponentWriter(types, elements, compilerOptions, graph, generatedComponentModel, subcomponentNames, bindingExpressions, componentRequirementFields, optionalFactories).write();
    }

    private ComponentWriter(DaggerTypes types, Elements elements, CompilerOptions compilerOptions, BindingGraph graph, GeneratedComponentModel generatedComponentModel, SubcomponentNames subcomponentNames, ComponentBindingExpressions bindingExpressions, ComponentRequirementFields componentRequirementFields, OptionalFactories optionalFactories) {
        super(types, elements, compilerOptions, graph, generatedComponentModel, subcomponentNames, optionalFactories, bindingExpressions, componentRequirementFields);
    }

    private void addBuilderFactoryMethod() {
        MethodSpec builderFactoryMethod = MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)(this.graph.componentDescriptor().builderSpec().isPresent() ? ClassName.get((TypeElement)this.graph.componentDescriptor().builderSpec().get().builderDefinitionType()) : this.builderName())).addStatement("return new $T()", new Object[]{this.builderName()}).build();
        this.generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.BUILDER_METHOD, builderFactoryMethod);
    }

    @Override
    protected void addBuilderClass(TypeSpec builder) {
        this.generatedComponentModel.addType(GeneratedComponentModel.TypeSpecKind.COMPONENT_BUILDER, builder);
    }

    @Override
    protected void addFactoryMethods() {
        this.addBuilderFactoryMethod();
        if (this.canInstantiateAllRequirements()) {
            String buildMethodName = this.graph.componentDescriptor().builderSpec().isPresent() ? this.graph.componentDescriptor().builderSpec().get().buildMethod().getSimpleName() : "build";
            this.generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.BUILDER_METHOD, MethodSpec.methodBuilder((String)"create").returns((TypeName)ClassName.get((TypeElement)this.graph.componentType())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addStatement("return new Builder().$L()", new Object[]{buildMethodName}).build());
        }
    }

    private boolean canInstantiateAllRequirements() {
        return !Iterables.any(this.graph.componentRequirements(), dependency -> dependency.requiresAPassedInstance(this.elements, this.types));
    }
}

