/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import dagger.Binds;
import dagger.Provides;
import dagger.internal.codegen.DaggerElements;
import dagger.multibindings.ElementsIntoSet;
import dagger.multibindings.IntoMap;
import dagger.multibindings.IntoSet;
import dagger.producers.Produces;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

final class MultibindingAnnotationsProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private static final ImmutableSet<Class<? extends Annotation>> VALID_BINDING_ANNOTATIONS = ImmutableSet.of(Provides.class, Produces.class, Binds.class);
    private final Messager messager;

    MultibindingAnnotationsProcessingStep(Messager messager) {
        this.messager = messager;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(IntoSet.class, ElementsIntoSet.class, IntoMap.class);
    }

    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        for (Map.Entry entry : elementsByAnnotation.entries()) {
            Element element = (Element)entry.getValue();
            if (DaggerElements.isAnyAnnotationPresent(element, VALID_BINDING_ANNOTATIONS)) continue;
            AnnotationMirror annotation = DaggerElements.getAnnotationMirror((Element)entry.getValue(), (Class)entry.getKey()).get();
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Multibinding annotations may only be on @Provides, @Produces, or @Binds methods", element, annotation);
        }
        return ImmutableSet.of();
    }
}

