/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.InstanceFactory;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.AnnotationExpression;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentProvisionBindingExpression;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ComponentRequirementFields;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.FrameworkFieldInitializer;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.OptionalFactories;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ReferenceReleasingManagerFields;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.Scopes;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.SubcomponentNames;
import dagger.internal.codegen.TypeNames;
import dagger.model.Key;
import dagger.model.Scope;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.releasablereferences.ForReleasableReferences;
import dagger.releasablereferences.ReleasableReferenceManager;
import dagger.releasablereferences.TypedReleasableReferenceManager;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class ProviderOrProducerFieldInitializer
extends FrameworkFieldInitializer {
    private final SubcomponentNames subcomponentNames;
    private final ComponentRequirementFields componentRequirementFields;
    private final ResolvedBindings resolvedBindings;
    private final CompilerOptions compilerOptions;
    private final BindingGraph graph;
    private final OptionalFactories optionalFactories;
    private final ReferenceReleasingManagerFields referenceReleasingManagerFields;

    ProviderOrProducerFieldInitializer(ResolvedBindings resolvedBindings, SubcomponentNames subcomponentNames, GeneratedComponentModel generatedComponentModel, ComponentBindingExpressions componentBindingExpressions, ComponentRequirementFields componentRequirementFields, ReferenceReleasingManagerFields referenceReleasingManagerFields, CompilerOptions compilerOptions, BindingGraph graph, OptionalFactories optionalFactories) {
        super(generatedComponentModel, componentBindingExpressions, resolvedBindings);
        Preconditions.checkArgument((boolean)resolvedBindings.bindingKey().kind().equals((Object)BindingKey.Kind.CONTRIBUTION));
        this.subcomponentNames = (SubcomponentNames)Preconditions.checkNotNull((Object)subcomponentNames);
        this.componentRequirementFields = (ComponentRequirementFields)Preconditions.checkNotNull((Object)componentRequirementFields);
        this.referenceReleasingManagerFields = (ReferenceReleasingManagerFields)Preconditions.checkNotNull((Object)referenceReleasingManagerFields);
        this.resolvedBindings = (ResolvedBindings)Preconditions.checkNotNull((Object)resolvedBindings);
        this.compilerOptions = (CompilerOptions)Preconditions.checkNotNull((Object)compilerOptions);
        this.graph = (BindingGraph)Preconditions.checkNotNull((Object)graph);
        this.optionalFactories = (OptionalFactories)Preconditions.checkNotNull((Object)optionalFactories);
    }

    @Override
    protected CodeBlock getFieldInitialization() {
        ContributionBinding contributionBinding = this.resolvedBindings.contributionBinding();
        switch (contributionBinding.factoryCreationStrategy()) {
            case DELEGATE: {
                CodeBlock delegatingCodeBlock = CodeBlock.of((String)"($T) $L", (Object[])new Object[]{contributionBinding.bindingType().frameworkClass(), this.getDependencyExpression((FrameworkDependency)Iterables.getOnlyElement(contributionBinding.frameworkDependencies()))});
                return this.decorateForScope(delegatingCodeBlock, contributionBinding.scope());
            }
            case SINGLETON_INSTANCE: {
                Preconditions.checkState((boolean)contributionBinding.scope().isPresent());
            }
            case CLASS_CONSTRUCTOR: {
                return this.factoryForContributionBindingInitialization(contributionBinding);
            }
        }
        throw new AssertionError();
    }

    private CodeBlock factoryForContributionBindingInitialization(ContributionBinding binding) {
        TypeName bindingKeyTypeName = TypeName.get((TypeMirror)binding.key().type());
        switch (binding.bindingKind()) {
            case COMPONENT: {
                return CodeBlock.of((String)"$T.<$T>create(this)", (Object[])new Object[]{TypeNames.INSTANCE_FACTORY, bindingKeyTypeName});
            }
            case COMPONENT_DEPENDENCY: {
                return CodeBlock.of((String)"$T.create($L)", (Object[])new Object[]{TypeNames.INSTANCE_FACTORY, this.componentRequirementFields.getExpressionDuringInitialization(ComponentRequirement.forDependency(binding.key().type()), this.generatedComponentModel.name())});
            }
            case COMPONENT_PROVISION: {
                TypeElement dependencyType = this.dependencyTypeForBinding(binding);
                String dependencyVariable = SourceFiles.simpleVariableName(dependencyType);
                String componentMethod = binding.bindingElement().get().getSimpleName().toString();
                CodeBlock invocation = ComponentProvisionBindingExpression.maybeCheckForNull((ProvisionBinding)binding, this.compilerOptions, CodeBlock.of((String)"$L.$L()", (Object[])new Object[]{dependencyVariable, componentMethod}));
                ClassName dependencyClassName = ClassName.get((TypeElement)dependencyType);
                String factoryName = dependencyClassName.toString().replace('.', '_') + "_" + componentMethod;
                MethodSpec.Builder getMethod = MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(bindingKeyTypeName).addStatement("return $L", new Object[]{invocation});
                if (binding.nullableType().isPresent()) {
                    getMethod.addAnnotation(ClassName.get((TypeElement)MoreTypes.asTypeElement(binding.nullableType().get())));
                }
                this.generatedComponentModel.addType(GeneratedComponentModel.TypeSpecKind.COMPONENT_PROVISION_FACTORY, TypeSpec.classBuilder((String)factoryName).addSuperinterface((TypeName)TypeNames.providerOf(bindingKeyTypeName)).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addField((TypeName)dependencyClassName, dependencyVariable, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)dependencyClassName, dependencyVariable, new Modifier[0]).addStatement("this.$1L = $1L", new Object[]{dependencyVariable}).build()).addMethod(getMethod.build()).build());
                this.setFieldTypeReplacement((TypeName)this.generatedComponentModel.name().nestedClass(factoryName));
                return CodeBlock.of((String)"new $L($L)", (Object[])new Object[]{factoryName, this.componentRequirementFields.getExpressionDuringInitialization(ComponentRequirement.forDependency(dependencyType.asType()), this.generatedComponentModel.name())});
            }
            case SUBCOMPONENT_BUILDER: {
                String subcomponentName = this.subcomponentNames.get((ComponentDescriptor)this.graph.componentDescriptor().subcomponentsByBuilderType().get((Object)MoreTypes.asTypeElement(binding.key().type())));
                return CodeBlock.of((String)"$L", (Object[])new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)TypeNames.providerOf(bindingKeyTypeName)).addMethod(MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(bindingKeyTypeName).addStatement("return new $LBuilder()", new Object[]{subcomponentName}).build()).build()});
            }
            case BUILDER_BINDING: {
                return CodeBlock.of((String)"$T.$L($L)", (Object[])new Object[]{InstanceFactory.class, binding.nullableType().isPresent() ? "createNullable" : "create", this.componentRequirementFields.getExpressionDuringInitialization(ComponentRequirement.forBinding(binding), this.generatedComponentModel.name())});
            }
            case INJECTION: 
            case PROVISION: {
                ArrayList arguments = Lists.newArrayListWithCapacity((int)(binding.explicitDependencies().size() + 1));
                if (binding.requiresModuleInstance()) {
                    arguments.add(this.componentRequirementFields.getExpressionDuringInitialization(ComponentRequirement.forModule(binding.contributingModule().get().asType()), this.generatedComponentModel.name()));
                }
                arguments.addAll(this.getBindingDependencyExpressions(binding));
                CodeBlock factoryCreate = CodeBlock.of((String)"$T.create($L)", (Object[])new Object[]{SourceFiles.generatedClassNameForBinding(binding), CodeBlocks.makeParametersCodeBlock(arguments)});
                if (binding.bindingKind().equals((Object)ContributionBinding.Kind.INJECTION) && binding.unresolved().isPresent() && binding.scope().isPresent()) {
                    factoryCreate = CodeBlock.of((String)"($T) $L", (Object[])new Object[]{binding.bindingType().frameworkClass(), factoryCreate});
                } else if (!binding.scope().isPresent()) {
                    this.setFieldTypeReplacement((TypeName)SourceFiles.generatedClassNameForBinding(binding));
                }
                return this.decorateForScope(factoryCreate, binding.scope());
            }
            case COMPONENT_PRODUCTION: {
                TypeElement dependencyType = this.dependencyTypeForBinding(binding);
                FieldSpec dependencyField = FieldSpec.builder((TypeName)ClassName.get((TypeElement)dependencyType), (String)SourceFiles.simpleVariableName(dependencyType), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer(this.componentRequirementFields.getExpressionDuringInitialization(ComponentRequirement.forDependency(dependencyType.asType()), this.generatedComponentModel.name())).build();
                return CodeBlock.of((String)"$L", (Object[])new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)TypeNames.producerOf(bindingKeyTypeName)).addField(dependencyField).addMethod(MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeNames.listenableFutureOf(bindingKeyTypeName)).addStatement("return $N.$L()", new Object[]{dependencyField, binding.bindingElement().get().getSimpleName()}).build()).build()});
            }
            case PRODUCTION: {
                ArrayList arguments = Lists.newArrayListWithCapacity((int)(binding.dependencies().size() + 2));
                if (binding.requiresModuleInstance()) {
                    arguments.add(this.componentRequirementFields.getExpressionDuringInitialization(ComponentRequirement.forModule(binding.contributingModule().get().asType()), this.generatedComponentModel.name()));
                }
                arguments.addAll(this.getBindingDependencyExpressions(binding));
                this.setFieldTypeReplacement((TypeName)SourceFiles.generatedClassNameForBinding(binding));
                return CodeBlock.of((String)"new $T($L)", (Object[])new Object[]{SourceFiles.generatedClassNameForBinding(binding), CodeBlocks.makeParametersCodeBlock(arguments)});
            }
            case SYNTHETIC_MULTIBOUND_SET: {
                return this.factoryForSetMultibindingInitialization(binding);
            }
            case SYNTHETIC_MULTIBOUND_MAP: {
                return this.factoryForMapMultibindingInitialization(binding);
            }
            case SYNTHETIC_RELEASABLE_REFERENCE_MANAGER: {
                return this.factoryForSyntheticReleasableReferenceManagerBindingInitialization(binding);
            }
            case SYNTHETIC_RELEASABLE_REFERENCE_MANAGERS: {
                return this.factoryForSyntheticSetOfReleasableReferenceManagersInitialization(binding);
            }
            case SYNTHETIC_OPTIONAL_BINDING: {
                return this.factoryForSyntheticOptionalBindingInitialization(binding);
            }
        }
        throw new AssertionError(binding);
    }

    private CodeBlock decorateForScope(CodeBlock factoryCreate, Optional<Scope> maybeScope) {
        if (!maybeScope.isPresent()) {
            return factoryCreate;
        }
        Scope scope = maybeScope.get();
        if (this.referenceReleasingManagerFields.requiresReleasableReferences(scope)) {
            return CodeBlock.of((String)"$T.create($L, $L)", (Object[])new Object[]{TypeNames.REFERENCE_RELEASING_PROVIDER, factoryCreate, this.referenceReleasingManagerFields.getExpression(scope, this.generatedComponentModel.name())});
        }
        return CodeBlock.of((String)"$T.provider($L)", (Object[])new Object[]{scope.isReusable() ? TypeNames.SINGLE_CHECK : TypeNames.DOUBLE_CHECK, factoryCreate});
    }

    private TypeElement dependencyTypeForBinding(ContributionBinding binding) {
        return (TypeElement)this.graph.componentDescriptor().dependencyMethodIndex().get((Object)binding.bindingElement().get());
    }

    private CodeBlock factoryForSetMultibindingInitialization(ContributionBinding binding) {
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.", new Object[]{SourceFiles.setFactoryClassName(binding)});
        boolean useRawTypes = this.useRawType();
        if (!useRawTypes) {
            SetType setType = SetType.from(binding.key());
            builder.add("<$T>", new Object[]{setType.elementsAreTypeOf(Produced.class) ? setType.unwrappedElementType(Produced.class) : setType.elementType()});
        }
        int individualProviders = 0;
        int setProviders = 0;
        CodeBlock.Builder builderMethodCalls = CodeBlock.builder();
        for (FrameworkDependency frameworkDependency : binding.frameworkDependencies()) {
            String methodName;
            ContributionType contributionType = ((ResolvedBindings)this.graph.resolvedBindings().get((Object)frameworkDependency.bindingKey())).contributionType();
            String methodNameSuffix = frameworkDependency.frameworkClass().getSimpleName();
            switch (contributionType) {
                case SET: {
                    ++individualProviders;
                    methodName = "add" + methodNameSuffix;
                    break;
                }
                case SET_VALUES: {
                    ++setProviders;
                    methodName = "addCollection" + methodNameSuffix;
                    break;
                }
                default: {
                    throw new AssertionError((Object)(frameworkDependency + " is not a set multibinding"));
                }
            }
            builderMethodCalls.add(".$L($L)", new Object[]{methodName, this.potentiallyCast(useRawTypes, frameworkDependency.frameworkClass(), this.getDependencyExpression(frameworkDependency))});
        }
        builder.add("builder($L, $L)", new Object[]{individualProviders, setProviders});
        builder.add(builderMethodCalls.build());
        return builder.add(".build()", new Object[0]).build();
    }

    private CodeBlock factoryForMapMultibindingInitialization(ContributionBinding binding) {
        ImmutableList<FrameworkDependency> frameworkDependencies = binding.frameworkDependencies();
        ImmutableList.Builder codeBlocks = ImmutableList.builder();
        MapType mapType = MapType.from(binding.key().type());
        CodeBlock.Builder builderCall = CodeBlock.builder().add("$T.", new Object[]{SourceFiles.mapFactoryClassName(binding)});
        boolean useRawTypes = this.useRawType();
        if (!useRawTypes) {
            TypeMirror valueType = mapType.valueType();
            for (Class frameworkClass : ImmutableSet.of(Provider.class, Producer.class, Produced.class)) {
                if (!mapType.valuesAreTypeOf(frameworkClass)) continue;
                valueType = mapType.unwrappedValueType(frameworkClass);
                break;
            }
            builderCall.add("<$T, $T>", new Object[]{mapType.keyType(), valueType});
        }
        if (binding.bindingType().equals((Object)BindingType.PROVISION)) {
            builderCall.add("builder($L)", new Object[]{frameworkDependencies.size()});
        } else {
            builderCall.add("builder()", new Object[0]);
        }
        codeBlocks.add((Object)builderCall.build());
        for (FrameworkDependency frameworkDependency : frameworkDependencies) {
            BindingKey bindingKey = frameworkDependency.bindingKey();
            ContributionBinding contributionBinding = ((ResolvedBindings)this.graph.resolvedBindings().get((Object)bindingKey)).contributionBinding();
            CodeBlock value = this.potentiallyCast(useRawTypes, frameworkDependency.frameworkClass(), this.getDependencyExpression(frameworkDependency));
            codeBlocks.add((Object)CodeBlock.of((String)".put($L, $L)", (Object[])new Object[]{MapKeys.getMapKeyExpression(contributionBinding, this.generatedComponentModel.name()), value}));
        }
        codeBlocks.add((Object)CodeBlock.of((String)".build()", (Object[])new Object[0]));
        return CodeBlocks.concat((Iterable<CodeBlock>)codeBlocks.build());
    }

    private CodeBlock potentiallyCast(boolean shouldCast, Class<?> classToCast, CodeBlock notCasted) {
        if (!shouldCast) {
            return notCasted;
        }
        return CodeBlock.of((String)"($T) $L", (Object[])new Object[]{classToCast, notCasted});
    }

    private boolean useRawType() {
        return !Accessibility.isTypeAccessibleFrom(this.resolvedBindings.key().type(), this.generatedComponentModel.name().packageName());
    }

    private CodeBlock factoryForSyntheticReleasableReferenceManagerBindingInitialization(ContributionBinding binding) {
        CodeBlock managerExpression;
        Scope scope = this.forReleasableReferencesAnnotationValue((AnnotationMirror)binding.key().qualifier().get());
        if (MoreTypes.isTypeOf(TypedReleasableReferenceManager.class, binding.key().type())) {
            TypeMirror metadataType = MoreTypes.asDeclared(binding.key().type()).getTypeArguments().get(0);
            managerExpression = this.typedReleasableReferenceManagerDecoratorExpression(this.referenceReleasingManagerFields.getExpression(scope, this.generatedComponentModel.name()), (AnnotationMirror)scope.releasableReferencesMetadata(metadataType).get());
        } else {
            managerExpression = this.referenceReleasingManagerFields.getExpression(scope, this.generatedComponentModel.name());
        }
        TypeName keyType = TypeName.get((TypeMirror)binding.key().type());
        return CodeBlock.of((String)"$L", (Object[])new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)TypeNames.providerOf(keyType)).addMethod(MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(keyType).addCode("return $L;", new Object[]{managerExpression}).build()).build()});
    }

    private CodeBlock factoryForSyntheticSetOfReleasableReferenceManagersInitialization(ContributionBinding binding) {
        Key key = binding.key();
        SetType keyType = SetType.from(key);
        ImmutableList.Builder managerExpressions = ImmutableList.builder();
        for (Scope scope : this.graph.scopesRequiringReleasableReferenceManagers()) {
            CodeBlock releasableReferenceManagerExpression = this.referenceReleasingManagerFields.getExpression(scope, this.generatedComponentModel.name());
            if (keyType.elementsAreTypeOf(ReleasableReferenceManager.class)) {
                managerExpressions.add((Object)releasableReferenceManagerExpression);
                continue;
            }
            if (keyType.elementsAreTypeOf(TypedReleasableReferenceManager.class)) {
                TypeMirror metadataType = keyType.unwrappedElementType(TypedReleasableReferenceManager.class);
                Optional metadata = scope.releasableReferencesMetadata(metadataType);
                if (!metadata.isPresent()) continue;
                managerExpressions.add((Object)this.typedReleasableReferenceManagerDecoratorExpression(releasableReferenceManagerExpression, (AnnotationMirror)metadata.get()));
                continue;
            }
            throw new IllegalArgumentException("inappropriate key: " + binding);
        }
        TypeName keyTypeName = TypeName.get((TypeMirror)key.type());
        return CodeBlock.of((String)"$L", (Object[])new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)TypeNames.providerOf(keyTypeName)).addMethod(MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(keyTypeName).addCode("return new $T($T.asList($L));", new Object[]{HashSet.class, Arrays.class, CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)managerExpressions.build())}).build()).build()});
    }

    private CodeBlock typedReleasableReferenceManagerDecoratorExpression(CodeBlock managerExpression, AnnotationMirror metadata) {
        return CodeBlock.of((String)"new $T<$T>($L, $L)", (Object[])new Object[]{TypeNames.TYPED_RELEASABLE_REFERENCE_MANAGER_DECORATOR, metadata.getAnnotationType(), managerExpression, new AnnotationExpression(metadata).getAnnotationInstanceExpression()});
    }

    private Scope forReleasableReferencesAnnotationValue(AnnotationMirror annotation) {
        Preconditions.checkArgument((boolean)MoreTypes.isTypeOf(ForReleasableReferences.class, annotation.getAnnotationType()));
        return Scopes.scope(MoreElements.asType(MoreTypes.asDeclared(MoreAnnotationMirrors.getTypeValue(annotation, "value")).asElement()));
    }

    private CodeBlock factoryForSyntheticOptionalBindingInitialization(ContributionBinding binding) {
        if (binding.explicitDependencies().isEmpty()) {
            Verify.verify((boolean)binding.bindingType().equals((Object)BindingType.PROVISION), (String)"Absent optional bindings should be provisions: %s", (Object)binding);
            return this.optionalFactories.absentOptionalProvider(binding);
        }
        return this.optionalFactories.presentOptionalFactory(binding, this.getDependencyExpression((FrameworkDependency)Iterables.getOnlyElement(binding.frameworkDependencies())));
    }
}

