/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.squareup.javapoet.TypeName;
import dagger.Lazy;
import dagger.MembersInjector;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.TypeNames;
import dagger.model.RequestKind;
import dagger.producers.Produced;
import dagger.producers.Producer;
import java.util.Optional;
import javax.inject.Provider;
import javax.lang.model.type.TypeMirror;

final class RequestKinds {
    private static final ImmutableMap<RequestKind, Class<?>> FRAMEWORK_CLASSES = ImmutableMap.of((Object)RequestKind.PROVIDER, Provider.class, (Object)RequestKind.LAZY, Lazy.class, (Object)RequestKind.MEMBERS_INJECTOR, MembersInjector.class, (Object)RequestKind.PRODUCER, Producer.class, (Object)RequestKind.PRODUCED, Produced.class);

    static TypeMirror requestType(RequestKind requestKind, TypeMirror type, DaggerTypes types) {
        switch (requestKind) {
            case INSTANCE: {
                return type;
            }
            case PROVIDER_OF_LAZY: {
                return types.wrapType(RequestKinds.requestType(RequestKind.LAZY, type, types), Provider.class);
            }
            case FUTURE: {
                return types.wrapType(type, ListenableFuture.class);
            }
        }
        return types.wrapType(type, RequestKinds.frameworkClass(requestKind).get());
    }

    static TypeName requestTypeName(RequestKind requestKind, TypeName keyType) {
        switch (requestKind) {
            case INSTANCE: {
                return keyType;
            }
            case PROVIDER: {
                return TypeNames.providerOf(keyType);
            }
            case LAZY: {
                return TypeNames.lazyOf(keyType);
            }
            case PROVIDER_OF_LAZY: {
                return TypeNames.providerOf((TypeName)TypeNames.lazyOf(keyType));
            }
            case PRODUCER: {
                return TypeNames.producerOf(keyType);
            }
            case PRODUCED: {
                return TypeNames.producedOf(keyType);
            }
            case FUTURE: {
                return TypeNames.listenableFutureOf(keyType);
            }
            case MEMBERS_INJECTOR: {
                return TypeNames.membersInjectorOf(keyType);
            }
        }
        throw new AssertionError(requestKind);
    }

    static Optional<Class<?>> frameworkClass(RequestKind requestKind) {
        return Optional.ofNullable((Class)FRAMEWORK_CLASSES.get((Object)requestKind));
    }

    private RequestKinds() {
    }
}

