/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.SetType;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Collection;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

abstract class ContributionBinding
extends Binding
implements ContributionType.HasContributionType {
    static final Function<ContributionBinding, Kind> KIND = new Function<ContributionBinding, Kind>(){

        public Kind apply(ContributionBinding binding) {
            return binding.bindingKind();
        }
    };
    static final Predicate<ContributionBinding> REQUIRES_MODULE_INSTANCE = new Predicate<ContributionBinding>(){

        public boolean apply(ContributionBinding bindingDeclaration) {
            return bindingDeclaration.requiresModuleInstance();
        }
    };

    ContributionBinding() {
    }

    abstract Optional<DeclaredType> nullableType();

    abstract Optional<Equivalence.Wrapper<AnnotationMirror>> wrappedMapKey();

    final Optional<AnnotationMirror> mapKey() {
        return MoreAnnotationMirrors.unwrapOptionalEquivalence(this.wrappedMapKey());
    }

    protected abstract Kind bindingKind();

    boolean requiresModuleInstance() {
        if (!this.bindingElement().isPresent() || !this.contributingModule().isPresent()) {
            return false;
        }
        Set<Modifier> modifiers = ((Element)this.bindingElement().get()).getModifiers();
        return !modifiers.contains((Object)Modifier.ABSTRACT) && !modifiers.contains((Object)Modifier.STATIC);
    }

    FactoryCreationStrategy factoryCreationStrategy() {
        switch (this.bindingKind()) {
            case SYNTHETIC_DELEGATE_BINDING: {
                return FactoryCreationStrategy.DELEGATE;
            }
            case PROVISION: {
                return this.implicitDependencies().isEmpty() && !this.requiresModuleInstance() ? FactoryCreationStrategy.ENUM_INSTANCE : FactoryCreationStrategy.CLASS_CONSTRUCTOR;
            }
            case INJECTION: 
            case SYNTHETIC_MULTIBOUND_SET: 
            case SYNTHETIC_MULTIBOUND_MAP: {
                return this.implicitDependencies().isEmpty() ? FactoryCreationStrategy.ENUM_INSTANCE : FactoryCreationStrategy.CLASS_CONSTRUCTOR;
            }
        }
        return FactoryCreationStrategy.CLASS_CONSTRUCTOR;
    }

    final TypeMirror factoryType() {
        switch (this.contributionType()) {
            case MAP: {
                return MapType.from(this.key()).unwrappedValueType(this.bindingType().frameworkClass());
            }
            case SET: {
                return SetType.from(this.key()).elementType();
            }
            case SET_VALUES: 
            case UNIQUE: {
                return this.key().type();
            }
        }
        throw new AssertionError();
    }

    static ImmutableSetMultimap<Object, ContributionBinding> indexMapBindingsByMapKey(Set<ContributionBinding> mapBindings) {
        return ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(mapBindings, (Function)new Function<ContributionBinding, Object>(){

            public Object apply(ContributionBinding mapBinding) {
                AnnotationMirror mapKey = (AnnotationMirror)mapBinding.mapKey().get();
                Optional<? extends AnnotationValue> unwrappedValue = MapKeys.unwrapValue(mapKey);
                return unwrappedValue.isPresent() ? ((AnnotationValue)unwrappedValue.get()).getValue() : mapKey;
            }
        }));
    }

    static ImmutableSetMultimap<Equivalence.Wrapper<DeclaredType>, ContributionBinding> indexMapBindingsByAnnotationType(Set<ContributionBinding> mapBindings) {
        return ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(mapBindings, (Function)new Function<ContributionBinding, Equivalence.Wrapper<DeclaredType>>(){

            public Equivalence.Wrapper<DeclaredType> apply(ContributionBinding mapBinding) {
                return MoreTypes.equivalence().wrap((Object)((AnnotationMirror)mapBinding.mapKey().get()).getAnnotationType());
            }
        }));
    }

    @CanIgnoreReturnValue
    static abstract class Builder<B extends Builder<B>> {
        Builder() {
        }

        abstract B contributionType(ContributionType var1);

        abstract B bindingElement(Element var1);

        abstract B contributingModule(TypeElement var1);

        abstract B key(Key var1);

        abstract B dependencies(Iterable<DependencyRequest> var1);

        abstract B dependencies(DependencyRequest ... var1);

        abstract B nullableType(Optional<DeclaredType> var1);

        abstract B wrappedMapKey(Optional<Equivalence.Wrapper<AnnotationMirror>> var1);

        abstract B bindingKind(Kind var1);
    }

    static enum FactoryCreationStrategy {
        ENUM_INSTANCE,
        CLASS_CONSTRUCTOR,
        DELEGATE;

    }

    static enum Kind {
        SYNTHETIC_MAP,
        SYNTHETIC_MULTIBOUND_SET,
        SYNTHETIC_MULTIBOUND_MAP,
        SYNTHETIC_DELEGATE_BINDING,
        SYNTHETIC_OPTIONAL_BINDING,
        INJECTION,
        PROVISION,
        COMPONENT,
        COMPONENT_PROVISION,
        SUBCOMPONENT_BUILDER,
        IMMEDIATE,
        FUTURE_PRODUCTION,
        COMPONENT_PRODUCTION;

        static final Predicate<Kind> IS_SYNTHETIC_MULTIBINDING_KIND;

        static Kind forMultibindingKey(Key key) {
            if (SetType.isSet(key)) {
                return SYNTHETIC_MULTIBOUND_SET;
            }
            if (MapType.isMap(key)) {
                return SYNTHETIC_MULTIBOUND_MAP;
            }
            throw new IllegalArgumentException(String.format("key is not for a set or map: %s", key));
        }

        static {
            IS_SYNTHETIC_MULTIBINDING_KIND = Predicates.in((Collection)Sets.immutableEnumSet((Enum)SYNTHETIC_MULTIBOUND_SET, (Enum[])new Kind[]{SYNTHETIC_MULTIBOUND_MAP}));
        }
    }
}

