/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.AutoValue_FrameworkDependency;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.BindingTypeMapper;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.SourceFiles;
import java.util.Collection;
import java.util.Iterator;

abstract class FrameworkDependency {
    FrameworkDependency() {
    }

    abstract BindingKey bindingKey();

    abstract BindingType bindingType();

    final Class<?> frameworkClass() {
        return this.bindingType().frameworkClass();
    }

    abstract ImmutableSet<DependencyRequest> dependencyRequests();

    static ImmutableSet<FrameworkDependency> frameworkDependenciesForBinding(Binding binding) {
        BindingTypeMapper bindingTypeMapper = BindingTypeMapper.forBindingType(binding.bindingType());
        ImmutableSet.Builder frameworkDependencies = ImmutableSet.builder();
        for (Collection requests : FrameworkDependency.groupByUnresolvedKey(binding)) {
            frameworkDependencies.add((Object)new AutoValue_FrameworkDependency((BindingKey)Iterables.getOnlyElement((Iterable)FluentIterable.from((Iterable)requests).transform(DependencyRequest.BINDING_KEY_FUNCTION).toSet()), bindingTypeMapper.getBindingType(requests), (ImmutableSet<DependencyRequest>)ImmutableSet.copyOf((Collection)requests)));
        }
        return frameworkDependencies.build();
    }

    static ImmutableMap<DependencyRequest, FrameworkDependency> indexByDependencyRequest(Iterable<FrameworkDependency> dependencies) {
        ImmutableMap.Builder frameworkDependencyMap = ImmutableMap.builder();
        for (FrameworkDependency dependency : dependencies) {
            for (DependencyRequest request : dependency.dependencyRequests()) {
                frameworkDependencyMap.put((Object)request, (Object)dependency);
            }
        }
        return frameworkDependencyMap.build();
    }

    private static ImmutableList<Collection<DependencyRequest>> groupByUnresolvedKey(Binding binding) {
        ImmutableSetMultimap.Builder dependenciesByKeyBuilder = ImmutableSetMultimap.builder();
        Iterator<DependencyRequest> dependencies = binding.implicitDependencies().iterator();
        Binding unresolved = binding.unresolved().isPresent() ? (Binding)binding.unresolved().get() : binding;
        Iterator<DependencyRequest> unresolvedDependencies = unresolved.implicitDependencies().iterator();
        while (dependencies.hasNext()) {
            dependenciesByKeyBuilder.put((Object)unresolvedDependencies.next().bindingKey(), (Object)dependencies.next());
        }
        return ImmutableList.copyOf((Collection)dependenciesByKeyBuilder.orderValuesBy(SourceFiles.DEPENDENCY_ORDERING).build().asMap().values());
    }
}

