/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import dagger.internal.codegen.AutoValue_ResolvedBindings;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MultibindingDeclaration;
import dagger.internal.codegen.OptionalBindingDeclaration;
import dagger.internal.codegen.Scope;
import dagger.internal.codegen.SubcomponentDeclaration;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

abstract class ResolvedBindings
implements BindingType.HasBindingType,
ContributionType.HasContributionType,
Key.HasKey {
    static final Function<ResolvedBindings, Set<ContributionBinding>> CONTRIBUTION_BINDINGS = new Function<ResolvedBindings, Set<ContributionBinding>>(){

        public Set<ContributionBinding> apply(ResolvedBindings resolvedBindings) {
            return resolvedBindings.contributionBindings();
        }
    };

    ResolvedBindings() {
    }

    abstract BindingKey bindingKey();

    abstract ComponentDescriptor owningComponent();

    abstract ImmutableSetMultimap<ComponentDescriptor, ContributionBinding> allContributionBindings();

    abstract ImmutableMap<ComponentDescriptor, MembersInjectionBinding> allMembersInjectionBindings();

    @Override
    public Key key() {
        return this.bindingKey().key();
    }

    abstract ImmutableSet<MultibindingDeclaration> multibindingDeclarations();

    abstract ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations();

    abstract ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations();

    ImmutableSet<? extends Binding> bindings() {
        switch (this.bindingKey().kind()) {
            case CONTRIBUTION: {
                return this.contributionBindings();
            }
            case MEMBERS_INJECTION: {
                return ImmutableSet.copyOf((Collection)this.membersInjectionBinding().asSet());
            }
        }
        throw new AssertionError(this.bindingKey());
    }

    Binding binding() {
        return (Binding)Iterables.getOnlyElement(this.bindings());
    }

    ImmutableList<Map.Entry<ComponentDescriptor, ? extends Binding>> bindingsByComponent() {
        return new ImmutableList.Builder().addAll((Iterable)this.allContributionBindings().entries()).addAll((Iterable)this.allMembersInjectionBindings().entrySet()).build();
    }

    boolean isEmpty() {
        return this.bindings().isEmpty() && this.multibindingDeclarations().isEmpty() && this.subcomponentDeclarations().isEmpty();
    }

    ImmutableSet<? extends Binding> ownedBindings() {
        switch (this.bindingKey().kind()) {
            case CONTRIBUTION: {
                return this.ownedContributionBindings();
            }
            case MEMBERS_INJECTION: {
                return ImmutableSet.copyOf((Collection)this.ownedMembersInjectionBinding().asSet());
            }
        }
        throw new AssertionError(this.bindingKey());
    }

    ImmutableSet<ContributionBinding> contributionBindings() {
        return ImmutableSet.copyOf((Collection)this.allContributionBindings().values());
    }

    ImmutableSet<ContributionBinding> ownedContributionBindings() {
        return this.allContributionBindings().get((Object)this.owningComponent());
    }

    ComponentDescriptor owningComponent(ContributionBinding binding) {
        Preconditions.checkArgument((boolean)this.contributionBindings().contains((Object)binding), (String)"binding is not resolved for %s: %s", (Object[])new Object[]{this.bindingKey(), binding});
        return (ComponentDescriptor)Iterables.getOnlyElement((Iterable)this.allContributionBindings().inverse().get((Object)binding));
    }

    Optional<MembersInjectionBinding> membersInjectionBinding() {
        ImmutableSet membersInjectionBindings = FluentIterable.from((Iterable)this.allMembersInjectionBindings().values()).toSet();
        return membersInjectionBindings.isEmpty() ? Optional.absent() : Optional.of((Object)Iterables.getOnlyElement((Iterable)membersInjectionBindings));
    }

    Optional<MembersInjectionBinding> ownedMembersInjectionBinding() {
        return Optional.fromNullable((Object)this.allMembersInjectionBindings().get((Object)this.owningComponent()));
    }

    static ResolvedBindings forContributionBindings(BindingKey bindingKey, ComponentDescriptor owningComponent, Multimap<ComponentDescriptor, ? extends ContributionBinding> contributionBindings, Iterable<MultibindingDeclaration> multibindings, Iterable<SubcomponentDeclaration> subcomponentDeclarations, Iterable<OptionalBindingDeclaration> optionalBindingDeclarations) {
        Preconditions.checkArgument((boolean)bindingKey.kind().equals((Object)BindingKey.Kind.CONTRIBUTION));
        return new AutoValue_ResolvedBindings(bindingKey, owningComponent, (ImmutableSetMultimap<ComponentDescriptor, ContributionBinding>)ImmutableSetMultimap.copyOf(contributionBindings), (ImmutableMap<ComponentDescriptor, MembersInjectionBinding>)ImmutableMap.of(), (ImmutableSet<MultibindingDeclaration>)ImmutableSet.copyOf(multibindings), (ImmutableSet<SubcomponentDeclaration>)ImmutableSet.copyOf(subcomponentDeclarations), (ImmutableSet<OptionalBindingDeclaration>)ImmutableSet.copyOf(optionalBindingDeclarations));
    }

    static ResolvedBindings forMembersInjectionBinding(BindingKey bindingKey, ComponentDescriptor owningComponent, MembersInjectionBinding ownedMembersInjectionBinding) {
        Preconditions.checkArgument((boolean)bindingKey.kind().equals((Object)BindingKey.Kind.MEMBERS_INJECTION));
        return new AutoValue_ResolvedBindings(bindingKey, owningComponent, (ImmutableSetMultimap<ComponentDescriptor, ContributionBinding>)ImmutableSetMultimap.of(), (ImmutableMap<ComponentDescriptor, MembersInjectionBinding>)ImmutableMap.of((Object)owningComponent, (Object)ownedMembersInjectionBinding), (ImmutableSet<MultibindingDeclaration>)ImmutableSet.of(), (ImmutableSet<SubcomponentDeclaration>)ImmutableSet.of(), (ImmutableSet<OptionalBindingDeclaration>)ImmutableSet.of());
    }

    static ResolvedBindings noBindings(BindingKey bindingKey, ComponentDescriptor owningComponent) {
        return new AutoValue_ResolvedBindings(bindingKey, owningComponent, (ImmutableSetMultimap<ComponentDescriptor, ContributionBinding>)ImmutableSetMultimap.of(), (ImmutableMap<ComponentDescriptor, MembersInjectionBinding>)ImmutableMap.of(), (ImmutableSet<MultibindingDeclaration>)ImmutableSet.of(), (ImmutableSet<SubcomponentDeclaration>)ImmutableSet.of(), (ImmutableSet<OptionalBindingDeclaration>)ImmutableSet.of());
    }

    ResolvedBindings asInheritedIn(ComponentDescriptor owningComponent) {
        return new AutoValue_ResolvedBindings(this.bindingKey(), owningComponent, this.allContributionBindings(), this.allMembersInjectionBindings(), this.multibindingDeclarations(), this.subcomponentDeclarations(), this.optionalBindingDeclarations());
    }

    boolean isMultibindingContribution() {
        return this.contributionBindings().size() == 1 && this.contributionBinding().contributionType().isMultibinding();
    }

    ContributionBinding contributionBinding() {
        return (ContributionBinding)Iterables.getOnlyElement(this.contributionBindings());
    }

    @Override
    public BindingType bindingType() {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (String)"empty bindings for %s", (Object[])new Object[]{this.bindingKey()});
        if (!(!this.bindings().isEmpty() || this.multibindingDeclarations().isEmpty() && this.subcomponentDeclarations().isEmpty())) {
            return BindingType.PROVISION;
        }
        ImmutableSet<BindingType> bindingTypes = this.bindingTypes();
        Preconditions.checkState((bindingTypes.size() == 1 ? 1 : 0) != 0, (String)"conflicting binding types: %s", (Object[])new Object[]{this.bindings()});
        return (BindingType)((Object)Iterables.getOnlyElement(bindingTypes));
    }

    ImmutableSet<BindingType> bindingTypes() {
        return FluentIterable.from(this.bindings()).transform(BindingType.BINDING_TYPE).toSet();
    }

    @Override
    public ContributionType contributionType() {
        return this.contributionBinding().contributionType();
    }

    Optional<String> bindingPackage() {
        ImmutableSet.Builder bindingPackagesBuilder = ImmutableSet.builder();
        for (Binding binding : this.bindings()) {
            bindingPackagesBuilder.addAll((Iterable)binding.bindingPackage().asSet());
        }
        ImmutableSet bindingPackages = bindingPackagesBuilder.build();
        switch (bindingPackages.size()) {
            case 0: {
                return Optional.absent();
            }
            case 1: {
                return Optional.of((Object)bindingPackages.iterator().next());
            }
        }
        throw new IllegalArgumentException();
    }

    Class<?> frameworkClass() {
        return this.bindingType().frameworkClass();
    }

    Optional<Scope> scope() {
        return ((Binding)Iterables.getOnlyElement(this.bindings())).scope();
    }
}

