/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.ErrorCode;
import com.google.firebase.FirebaseException;
import com.google.firebase.auth.AuthErrorCode;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.internal.AbstractHttpErrorHandler;
import com.google.firebase.internal.Nullable;
import java.io.IOException;
import java.util.Map;

final class AuthErrorHandler
extends AbstractHttpErrorHandler<FirebaseAuthException> {
    private static final Map<String, AuthError> ERROR_CODES = ImmutableMap.builder().put((Object)"CONFIGURATION_NOT_FOUND", (Object)new AuthError(ErrorCode.NOT_FOUND, "No IdP configuration found corresponding to the provided identifier", AuthErrorCode.CONFIGURATION_NOT_FOUND)).put((Object)"DUPLICATE_EMAIL", (Object)new AuthError(ErrorCode.ALREADY_EXISTS, "The user with the provided email already exists", AuthErrorCode.EMAIL_ALREADY_EXISTS)).put((Object)"DUPLICATE_LOCAL_ID", (Object)new AuthError(ErrorCode.ALREADY_EXISTS, "The user with the provided uid already exists", AuthErrorCode.UID_ALREADY_EXISTS)).put((Object)"EMAIL_EXISTS", (Object)new AuthError(ErrorCode.ALREADY_EXISTS, "The user with the provided email already exists", AuthErrorCode.EMAIL_ALREADY_EXISTS)).put((Object)"INVALID_DYNAMIC_LINK_DOMAIN", (Object)new AuthError(ErrorCode.INVALID_ARGUMENT, "The provided dynamic link domain is not configured or authorized for the current project", AuthErrorCode.INVALID_DYNAMIC_LINK_DOMAIN)).put((Object)"PHONE_NUMBER_EXISTS", (Object)new AuthError(ErrorCode.ALREADY_EXISTS, "The user with the provided phone number already exists", AuthErrorCode.PHONE_NUMBER_ALREADY_EXISTS)).put((Object)"TENANT_NOT_FOUND", (Object)new AuthError(ErrorCode.NOT_FOUND, "No tenant found for the given identifier", AuthErrorCode.TENANT_NOT_FOUND)).put((Object)"UNAUTHORIZED_DOMAIN", (Object)new AuthError(ErrorCode.INVALID_ARGUMENT, "The domain of the continue URL is not whitelisted", AuthErrorCode.UNAUTHORIZED_CONTINUE_URL)).put((Object)"USER_NOT_FOUND", (Object)new AuthError(ErrorCode.NOT_FOUND, "No user record found for the given identifier", AuthErrorCode.USER_NOT_FOUND)).build();
    private final JsonFactory jsonFactory;

    AuthErrorHandler(JsonFactory jsonFactory) {
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
    }

    @Override
    protected FirebaseAuthException createException(FirebaseException base) {
        String response = this.getResponse(base);
        AuthServiceErrorResponse parsed = this.safeParse(response);
        AuthError errorInfo = ERROR_CODES.get(parsed.getCode());
        if (errorInfo != null) {
            return new FirebaseAuthException(errorInfo.getErrorCode(), errorInfo.buildMessage(parsed), base.getCause(), base.getHttpResponse(), errorInfo.getAuthErrorCode());
        }
        return new FirebaseAuthException(base);
    }

    private String getResponse(FirebaseException base) {
        if (base.getHttpResponse() == null) {
            return null;
        }
        return base.getHttpResponse().getContent();
    }

    private AuthServiceErrorResponse safeParse(String response) {
        AuthServiceErrorResponse parsed = new AuthServiceErrorResponse();
        if (!Strings.isNullOrEmpty((String)response)) {
            try {
                this.jsonFactory.createJsonParser(response).parse((Object)parsed);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return parsed;
    }

    private static class AuthServiceErrorResponse {
        @Key(value="error")
        private GenericJson error;

        private AuthServiceErrorResponse() {
        }

        @Nullable
        public String getCode() {
            String message = this.getMessage();
            if (Strings.isNullOrEmpty((String)message)) {
                return null;
            }
            int separator = message.indexOf(58);
            if (separator != -1) {
                return message.substring(0, separator);
            }
            return message;
        }

        @Nullable
        public String getDetail() {
            String message = this.getMessage();
            if (Strings.isNullOrEmpty((String)message)) {
                return null;
            }
            int separator = message.indexOf(58);
            if (separator != -1) {
                return message.substring(separator + 1).trim();
            }
            return null;
        }

        private String getMessage() {
            if (this.error == null) {
                return null;
            }
            return (String)this.error.get((Object)"message");
        }
    }

    private static class AuthError {
        private final ErrorCode errorCode;
        private final String message;
        private final AuthErrorCode authErrorCode;

        AuthError(ErrorCode errorCode, String message, AuthErrorCode authErrorCode) {
            this.errorCode = errorCode;
            this.message = message;
            this.authErrorCode = authErrorCode;
        }

        ErrorCode getErrorCode() {
            return this.errorCode;
        }

        AuthErrorCode getAuthErrorCode() {
            return this.authErrorCode;
        }

        String buildMessage(AuthServiceErrorResponse response) {
            StringBuilder builder = new StringBuilder(this.message).append(" (").append(response.getCode()).append(")");
            String detail = response.getDetail();
            if (!Strings.isNullOrEmpty((String)detail)) {
                builder.append(": ").append(detail);
            } else {
                builder.append(".");
            }
            return builder.toString();
        }
    }
}

