/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.HasBeforeSelectionHandlers;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.layout.client.Layout;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IndexedPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.WidgetCollection;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabLayoutPanel
extends ResizeComposite
implements HasWidgets,
ProvidesResize,
IndexedPanel,
HasBeforeSelectionHandlers<Integer>,
HasSelectionHandlers<Integer> {
    private static final int BIG_ENOUGH_TO_NOT_WRAP = 16384;
    private WidgetCollection children = new WidgetCollection(this);
    private FlowPanel tabBar = new FlowPanel();
    private ArrayList<Tab> tabs = new ArrayList();
    private final double barHeight;
    private final Style.Unit barUnit;
    private LayoutPanel panel;
    private int selectedIndex = -1;

    public TabLayoutPanel(double barHeight, Style.Unit barUnit) {
        this.barHeight = barHeight;
        this.barUnit = barUnit;
        this.panel = new LayoutPanel();
        this.initWidget(this.panel);
        this.panel.add(this.tabBar);
        this.panel.setWidgetLeftRight(this.tabBar, 0.0, Style.Unit.PX, 0.0, Style.Unit.PX);
        this.panel.setWidgetTopHeight(this.tabBar, 0.0, Style.Unit.PX, barHeight, barUnit);
        this.panel.setWidgetVerticalPosition(this.tabBar, Layout.Alignment.END);
        this.tabBar.getElement().getStyle().setWidth(16384.0, Style.Unit.PX);
        this.tabBar.setStyleName("gwt-TabLayoutPanelTabs");
        this.setStyleName("gwt-TabLayoutPanel");
    }

    @Override
    public void add(Widget w) {
        this.insert(w, this.getWidgetCount());
    }

    public void add(Widget child, String text) {
        this.insert(child, text, this.getWidgetCount());
    }

    public void add(Widget child, String text, boolean asHtml) {
        this.insert(child, text, asHtml, this.getWidgetCount());
    }

    public void add(Widget child, Widget tab) {
        this.insert(child, tab, this.getWidgetCount());
    }

    @Override
    public HandlerRegistration addBeforeSelectionHandler(BeforeSelectionHandler<Integer> handler) {
        return this.addHandler(handler, BeforeSelectionEvent.getType());
    }

    @Override
    public HandlerRegistration addSelectionHandler(SelectionHandler<Integer> handler) {
        return this.addHandler(handler, SelectionEvent.getType());
    }

    @Override
    public void clear() {
        Iterator<Widget> it = this.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Widget getTabWidget(int index) {
        this.checkIndex(index);
        return this.tabs.get(index).getWidget();
    }

    public Widget getTabWidget(Widget child) {
        this.checkChild(child);
        return this.getTabWidget(this.getWidgetIndex(child));
    }

    @Override
    public Widget getWidget(int index) {
        this.checkIndex(index);
        return this.children.get(index);
    }

    @Override
    public int getWidgetCount() {
        return this.children.size();
    }

    @Override
    public int getWidgetIndex(Widget child) {
        return this.children.indexOf(child);
    }

    public void insert(Widget child, int beforeIndex) {
        this.insert(child, "", beforeIndex);
    }

    public void insert(Widget child, String text, boolean asHtml, int beforeIndex) {
        Label contents = asHtml ? new HTML(text) : new Label(text);
        this.insert(child, contents, beforeIndex);
    }

    public void insert(Widget child, String text, int beforeIndex) {
        this.insert(child, text, false, beforeIndex);
    }

    public void insert(Widget child, Widget tab, int beforeIndex) {
        this.insert(child, new Tab(tab), beforeIndex);
    }

    @Override
    public Iterator<Widget> iterator() {
        return this.children.iterator();
    }

    @Override
    public boolean remove(int index) {
        if (index < 0 || index >= this.getWidgetCount()) {
            return false;
        }
        this.tabBar.remove(index);
        this.panel.remove(this.children.get(index));
        this.children.remove(index);
        this.tabs.remove(index);
        if (index == this.selectedIndex) {
            this.selectedIndex = -1;
            if (this.getWidgetCount() > 0) {
                this.selectTab(0);
            }
        } else if (index < this.selectedIndex) {
            --this.selectedIndex;
        }
        return true;
    }

    @Override
    public boolean remove(Widget w) {
        int index = this.children.indexOf(w);
        if (index == -1) {
            return false;
        }
        return this.remove(index);
    }

    public void selectTab(int index) {
        com.google.gwt.dom.client.Element container;
        Widget child;
        this.checkIndex(index);
        if (index == this.selectedIndex) {
            return;
        }
        BeforeSelectionEvent<Integer> event = BeforeSelectionEvent.fire(this, index);
        if (event != null && event.isCanceled()) {
            return;
        }
        if (this.selectedIndex != -1) {
            child = this.children.get(this.selectedIndex);
            container = this.panel.getWidgetContainerElement(child);
            container.getStyle().setDisplay(Style.Display.NONE);
            child.setVisible(false);
            this.tabs.get(this.selectedIndex).setSelected(false);
        }
        child = this.children.get(index);
        container = this.panel.getWidgetContainerElement(child);
        container.getStyle().clearDisplay();
        child.setVisible(true);
        this.tabs.get(index).setSelected(true);
        this.selectedIndex = index;
        SelectionEvent.fire(this, index);
    }

    public void selectTab(Widget child) {
        this.selectTab(this.getWidgetIndex(child));
    }

    public void setTabHTML(int index, String html) {
        this.checkIndex(index);
        this.tabs.get(index).setWidget(new HTML(html));
    }

    public void setTabText(int index, String text) {
        this.checkIndex(index);
        this.tabs.get(index).setWidget(new Label(text));
    }

    private void checkChild(Widget child) {
        assert (this.children.contains(child));
    }

    private void checkIndex(int index) {
        assert (index >= 0 && index < this.children.size()) : "Index out of bounds";
    }

    private void insert(final Widget child, Tab tab, int beforeIndex) {
        assert (beforeIndex >= 0 && beforeIndex <= this.getWidgetCount()) : "beforeIndex out of bounds";
        int idx = this.getWidgetIndex(child);
        if (idx != -1) {
            this.remove(child);
            if (idx < beforeIndex) {
                --beforeIndex;
            }
        }
        this.children.insert(child, beforeIndex);
        this.tabs.add(beforeIndex, tab);
        this.tabBar.insert(tab.asWidget(), beforeIndex);
        tab.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TabLayoutPanel.this.selectTab(child);
            }
        });
        this.panel.insert(child, beforeIndex);
        this.layoutChild(child);
        if (this.selectedIndex == -1) {
            this.selectTab(0);
        }
    }

    private void layoutChild(Widget child) {
        this.panel.setWidgetLeftRight(child, 0.0, Style.Unit.PX, 0.0, Style.Unit.PX);
        this.panel.setWidgetTopBottom(child, this.barHeight, this.barUnit, 0.0, Style.Unit.PX);
        this.panel.getWidgetContainerElement(child).getStyle().setDisplay(Style.Display.NONE);
        child.setVisible(false);
    }

    private static class Tab
    extends SimplePanel {
        private com.google.gwt.dom.client.Element inner = Document.get().createDivElement();

        public Tab(Widget child) {
            super(Document.get().createDivElement());
            this.getElement().appendChild(this.inner);
            this.setWidget(child);
            this.setStyleName("gwt-TabLayoutPanelTab");
            this.inner.setClassName("gwt-TabLayoutPanelTabInner");
            this.getElement().getStyle().setFloat(Style.Float.LEFT);
        }

        public HandlerRegistration addClickHandler(ClickHandler handler) {
            return this.addDomHandler(handler, ClickEvent.getType());
        }

        public Widget asWidget() {
            return this;
        }

        public void setSelected(boolean selected) {
            if (selected) {
                this.addStyleDependentName("selected");
            } else {
                this.removeStyleDependentName("selected");
            }
        }

        protected Element getContainerElement() {
            return (Element)this.inner.cast();
        }
    }
}

