/*
 * Decompiled with CFR 0.152.
 */
package javaemul.internal;

import javaemul.internal.ArrayStamper;

public class ArrayHelper {
    public static final int ARRAY_PROCESS_BATCH_SIZE = 10000;

    public static <T> T[] clone(T[] array, int fromIndex, int toIndex) {
        Object[] result = ArrayHelper.unsafeClone(array, fromIndex, toIndex);
        return ArrayStamper.stampJavaTypeInfo(result, array);
    }

    public static native Object[] unsafeClone(Object var0, int var1, int var2);

    public static <T> T[] createFrom(T[] array, int length) {
        Object result = ArrayHelper.createNativeArray(length);
        return ArrayStamper.stampJavaTypeInfo(result, array);
    }

    private static native Object createNativeArray(int var0);

    public static native int getLength(Object var0);

    public static native void setLength(Object var0, int var1);

    public static native void removeFrom(Object var0, int var1, int var2);

    public static native void insertTo(Object var0, int var1, Object var2);

    public static void insertTo(Object array, int index, Object[] values) {
        ArrayHelper.copy(values, 0, array, index, values.length, false);
    }

    public static void copy(Object array, int srcOfs, Object dest, int destOfs, int len) {
        ArrayHelper.copy(array, srcOfs, dest, destOfs, len, true);
    }

    private static void copy(Object src, int srcOfs, Object dest, int destOfs, int len, boolean overwrite) {
        if (src == dest) {
            src = ArrayHelper.unsafeClone(src, srcOfs, srcOfs + len);
            srcOfs = 0;
        }
        int batchStart = srcOfs;
        int end = srcOfs + len;
        while (batchStart < end) {
            int batchEnd = Math.min(batchStart + 10000, end);
            len = batchEnd - batchStart;
            ArrayHelper.applySplice(dest, destOfs, overwrite ? len : 0, ArrayHelper.unsafeClone(src, batchStart, batchEnd));
            batchStart = batchEnd;
            destOfs += len;
        }
    }

    private static native void applySplice(Object var0, int var1, int var2, Object var3);
}

