/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.googlecode.wickedcharts.highcharts.options.DateTimeLabelFormat;
import java.io.IOException;
import java.util.Map;

public class DateTimeLabelFormatSerializer
extends JsonSerializer<DateTimeLabelFormat> {
    public void serialize(DateTimeLabelFormat value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        StringBuilder dateTimeFormatBuilder = new StringBuilder();
        dateTimeFormatBuilder.append("{");
        for (Map.Entry<DateTimeLabelFormat.DateTimeProperties, String> property : value.getProperties().entrySet()) {
            dateTimeFormatBuilder.append(" " + property.getKey().toCode() + ": '" + property.getValue() + "',");
        }
        int lastCommaPosition = dateTimeFormatBuilder.lastIndexOf(",");
        if (lastCommaPosition != -1) {
            dateTimeFormatBuilder.deleteCharAt(lastCommaPosition);
        }
        dateTimeFormatBuilder.append(" }");
        jgen.writeRawValue(dateTimeFormatBuilder.toString());
    }
}

