/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.h2.command.Prepared;
import org.h2.constraint.Constraint;
import org.h2.engine.DbObject;
import org.h2.engine.Right;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.result.SearchRow;
import org.h2.result.SimpleRow;
import org.h2.result.SimpleRowValue;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.SchemaObjectBase;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.PlanItem;
import org.h2.table.TableView;
import org.h2.util.New;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Table
extends SchemaObjectBase {
    public static final int TYPE_CACHED = 0;
    public static final int TYPE_MEMORY = 1;
    public static final String TABLE_LINK = "TABLE LINK";
    public static final String SYSTEM_TABLE = "SYSTEM TABLE";
    public static final String TABLE = "TABLE";
    public static final String VIEW = "VIEW";
    public static final String EXTERNAL_TABLE_ENGINE = "EXTERNAL";
    protected Column[] columns;
    protected int memoryPerRow;
    protected CompareMode compareMode;
    protected boolean isHidden;
    private final HashMap<String, Column> columnMap = New.hashMap();
    private boolean persistIndexes;
    private boolean persistData;
    private ArrayList<TriggerObject> triggers;
    private ArrayList<Constraint> constraints;
    private ArrayList<Sequence> sequences;
    private ArrayList<TableView> views;
    private boolean checkForeignKeyConstraints = true;
    private boolean onCommitDrop;
    private boolean onCommitTruncate;
    private Row nullRow;

    public Table(Schema schema, int n, String string, boolean bl, boolean bl2) {
        this.initSchemaObjectBase(schema, n, string, "table");
        this.persistIndexes = bl;
        this.persistData = bl2;
        this.compareMode = schema.getDatabase().getCompareMode();
    }

    @Override
    public void rename(String string) {
        super.rename(string);
        for (int i = 0; this.constraints != null && i < this.constraints.size(); ++i) {
            Constraint constraint = this.constraints.get(i);
            constraint.rebuild();
        }
    }

    public abstract void lock(Session var1, boolean var2, boolean var3);

    public abstract void close(Session var1);

    public abstract void unlock(Session var1);

    public abstract Index addIndex(Session var1, String var2, int var3, IndexColumn[] var4, IndexType var5, boolean var6, String var7);

    public abstract void removeRow(Session var1, Row var2);

    public abstract void truncate(Session var1);

    public abstract void addRow(Session var1, Row var2);

    public abstract void checkSupportAlter();

    public abstract String getTableType();

    public abstract Index getScanIndex(Session var1);

    public abstract Index getUniqueIndex();

    public abstract ArrayList<Index> getIndexes();

    public abstract boolean isLockedExclusively();

    public abstract long getMaxDataModificationId();

    public abstract boolean isDeterministic();

    public abstract boolean canGetRowCount();

    public boolean canReference() {
        return true;
    }

    public abstract boolean canDrop();

    public abstract long getRowCount(Session var1);

    public abstract long getRowCountApproximation();

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError();
    }

    public void addDependencies(HashSet<DbObject> hashSet) {
        if (this.sequences != null) {
            for (Sequence object : this.sequences) {
                hashSet.add(object);
            }
        }
        ExpressionVisitor expressionVisitor = ExpressionVisitor.get(7);
        expressionVisitor.setDependencies(hashSet);
        for (Column column : this.columns) {
            column.isEverything(expressionVisitor);
        }
    }

    @Override
    public ArrayList<DbObject> getChildren() {
        ArrayList<DbObject> arrayList = New.arrayList();
        ArrayList<Index> arrayList2 = this.getIndexes();
        if (arrayList2 != null) {
            arrayList.addAll(arrayList2);
        }
        if (this.constraints != null) {
            arrayList.addAll(this.constraints);
        }
        if (this.triggers != null) {
            arrayList.addAll(this.triggers);
        }
        if (this.sequences != null) {
            arrayList.addAll(this.sequences);
        }
        if (this.views != null) {
            arrayList.addAll(this.views);
        }
        ArrayList<Right> arrayList3 = this.database.getAllRights();
        for (Right right : arrayList3) {
            if (right.getGrantedTable() != this) continue;
            arrayList.add(right);
        }
        return arrayList;
    }

    protected void setColumns(Column[] columnArray) {
        this.columns = columnArray;
        if (this.columnMap.size() > 0) {
            this.columnMap.clear();
        }
        int n = 1;
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = columnArray[i];
            int n2 = column.getType();
            if (n2 == -1) {
                throw DbException.get(50004, column.getSQL());
            }
            n += DataType.getDataType((int)n2).memory;
            column.setTable(this, i);
            String string = column.getName();
            if (this.columnMap.get(string) != null) {
                throw DbException.get(42121, string);
            }
            this.columnMap.put(string, column);
        }
        this.memoryPerRow = n;
    }

    public void renameColumn(Column column, String string) {
        for (Column column2 : this.columns) {
            if (column2 == column || !column2.getName().equals(string)) continue;
            throw DbException.get(42121, string);
        }
        this.columnMap.remove(column.getName());
        column.rename(string);
        this.columnMap.put(string, column);
    }

    public boolean isLockedExclusivelyBy(Session session) {
        return false;
    }

    public void updateRows(Prepared prepared, Session session, RowList rowList) {
        Row row;
        int n = 0;
        rowList.reset();
        while (rowList.hasNext()) {
            if ((++n & 0x7F) == 0) {
                prepared.checkCanceled();
            }
            row = rowList.next();
            rowList.next();
            this.removeRow(session, row);
            session.log(this, (short)1, row);
        }
        rowList.reset();
        while (rowList.hasNext()) {
            if ((++n & 0x7F) == 0) {
                prepared.checkCanceled();
            }
            rowList.next();
            row = rowList.next();
            this.addRow(session, row);
            session.log(this, (short)0, row);
        }
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        Object object;
        while (this.views != null && this.views.size() > 0) {
            object = this.views.get(0);
            this.views.remove(0);
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
        while (this.triggers != null && this.triggers.size() > 0) {
            object = this.triggers.get(0);
            this.triggers.remove(0);
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
        while (this.constraints != null && this.constraints.size() > 0) {
            object = this.constraints.get(0);
            this.constraints.remove(0);
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
        for (Right right : this.database.getAllRights()) {
            if (right.getGrantedTable() != this) continue;
            this.database.removeDatabaseObject(session, right);
        }
        this.database.removeMeta(session, this.getId());
        while (this.sequences != null && this.sequences.size() > 0) {
            object = this.sequences.get(0);
            this.sequences.remove(0);
            if (this.isTemporary() || this.database.getDependentTable((SchemaObject)object, this) != null) continue;
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
    }

    public void checkColumnIsNotReferenced(Column column) {
        for (int i = 0; this.constraints != null && i < this.constraints.size(); ++i) {
            Constraint constraint = this.constraints.get(i);
            if (!constraint.containsColumn(column)) continue;
            throw DbException.get(90083, constraint.getSQL());
        }
        ArrayList<Index> arrayList = this.getIndexes();
        for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
            Index index = arrayList.get(i);
            if (index.getColumns().length == 1 || index.getCreateSQL() == null || index.getColumnIndex(column) < 0) continue;
            throw DbException.get(90083, index.getSQL());
        }
    }

    public Row getTemplateRow() {
        return new Row(new Value[this.columns.length], this.memoryPerRow);
    }

    public SearchRow getTemplateSimpleRow(boolean bl) {
        if (bl) {
            return new SimpleRowValue(this.columns.length);
        }
        return new SimpleRow(new Value[this.columns.length]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Row getNullRow() {
        Table table = this;
        synchronized (table) {
            if (this.nullRow == null) {
                this.nullRow = new Row(new Value[this.columns.length], 1);
                for (int i = 0; i < this.columns.length; ++i) {
                    this.nullRow.setValue(i, ValueNull.INSTANCE);
                }
            }
            return this.nullRow;
        }
    }

    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public int getType() {
        return 0;
    }

    public Column getColumn(int n) {
        return this.columns[n];
    }

    public Column getColumn(String string) {
        Column column = this.columnMap.get(string);
        if (column == null) {
            throw DbException.get(42122, string);
        }
        return column;
    }

    public PlanItem getBestPlanItem(Session session, int[] nArray) {
        PlanItem planItem = new PlanItem();
        planItem.setIndex(this.getScanIndex(session));
        planItem.cost = planItem.getIndex().getCost(session, null);
        ArrayList<Index> arrayList = this.getIndexes();
        for (int i = 1; arrayList != null && nArray != null && i < arrayList.size(); ++i) {
            Index index = arrayList.get(i);
            double d = index.getCost(session, nArray);
            if (!(d < planItem.cost)) continue;
            planItem.cost = d;
            planItem.setIndex(index);
        }
        return planItem;
    }

    public Index findPrimaryKey() {
        ArrayList<Index> arrayList = this.getIndexes();
        for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
            Index index = arrayList.get(i);
            if (!index.getIndexType().isPrimaryKey()) continue;
            return index;
        }
        return null;
    }

    public Index getPrimaryKey() {
        Index index = this.findPrimaryKey();
        if (index != null) {
            return index;
        }
        throw DbException.get(42112, "PRIMARY_KEY_");
    }

    public void validateConvertUpdateSequence(Session session, Row row) {
        for (int i = 0; i < this.columns.length; ++i) {
            Value value;
            Value value2 = row.getValue(i);
            Column column = this.columns[i];
            if (column.getComputed()) {
                value2 = null;
                value = column.computeValue(session, row);
            }
            if ((value = column.validateConvertUpdateSequence(session, value2)) == value2) continue;
            row.setValue(i, value);
        }
    }

    private void remove(ArrayList<? extends DbObject> arrayList, DbObject dbObject) {
        int n;
        if (arrayList != null && (n = arrayList.indexOf(dbObject)) >= 0) {
            arrayList.remove(n);
        }
    }

    public void removeIndex(Index index) {
        ArrayList<Index> arrayList = this.getIndexes();
        if (arrayList != null) {
            this.remove(arrayList, index);
            if (index.getIndexType().isPrimaryKey()) {
                for (Column column : index.getColumns()) {
                    column.setPrimaryKey(false);
                }
            }
        }
    }

    void removeView(TableView tableView) {
        this.remove(this.views, tableView);
    }

    public void removeConstraint(Constraint constraint) {
        this.remove(this.constraints, constraint);
    }

    public void removeSequence(Session session, Sequence sequence) {
        this.remove(this.sequences, sequence);
    }

    public void removeTrigger(TriggerObject triggerObject) {
        this.remove(this.triggers, triggerObject);
    }

    public void addView(TableView tableView) {
        this.views = this.add(this.views, tableView);
    }

    public void addConstraint(Constraint constraint) {
        if (this.constraints == null || this.constraints.indexOf(constraint) < 0) {
            this.constraints = this.add(this.constraints, constraint);
        }
    }

    public ArrayList<Constraint> getConstraints() {
        return this.constraints;
    }

    public void addSequence(Sequence sequence) {
        this.sequences = this.add(this.sequences, sequence);
    }

    public void addTrigger(TriggerObject triggerObject) {
        this.triggers = this.add(this.triggers, triggerObject);
    }

    private <T> ArrayList<T> add(ArrayList<T> arrayList, T t) {
        if (arrayList == null) {
            arrayList = New.arrayList();
        }
        arrayList.add(t);
        return arrayList;
    }

    public void fire(Session session, int n, boolean bl) {
        if (this.triggers != null) {
            for (TriggerObject triggerObject : this.triggers) {
                triggerObject.fire(session, n, bl);
            }
        }
    }

    public boolean hasSelectTrigger() {
        if (this.triggers != null) {
            for (TriggerObject triggerObject : this.triggers) {
                if (!triggerObject.isSelectTrigger()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean fireRow() {
        return this.constraints != null && this.constraints.size() > 0 || this.triggers != null && this.triggers.size() > 0;
    }

    public boolean fireBeforeRow(Session session, Row row, Row row2) {
        boolean bl = this.fireRow(session, row, row2, true, false);
        this.fireConstraints(session, row, row2, true);
        return bl;
    }

    private void fireConstraints(Session session, Row row, Row row2, boolean bl) {
        if (this.constraints != null) {
            for (Constraint constraint : this.constraints) {
                if (constraint.isBefore() != bl) continue;
                constraint.checkRow(session, this, row, row2);
            }
        }
    }

    public void fireAfterRow(Session session, Row row, Row row2, boolean bl) {
        this.fireRow(session, row, row2, false, bl);
        if (!bl) {
            this.fireConstraints(session, row, row2, false);
        }
    }

    private boolean fireRow(Session session, Row row, Row row2, boolean bl, boolean bl2) {
        if (this.triggers != null) {
            for (TriggerObject triggerObject : this.triggers) {
                boolean bl3 = triggerObject.fireRow(session, row, row2, bl, bl2);
                if (!bl3) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isGlobalTemporary() {
        return false;
    }

    public boolean canTruncate() {
        return false;
    }

    public void setCheckForeignKeyConstraints(Session session, boolean bl, boolean bl2) {
        if (bl && bl2) {
            for (int i = 0; this.constraints != null && i < this.constraints.size(); ++i) {
                Constraint constraint = this.constraints.get(i);
                constraint.checkExistingData(session);
            }
        }
        this.checkForeignKeyConstraints = bl;
    }

    public boolean getCheckForeignKeyConstraints() {
        return this.checkForeignKeyConstraints;
    }

    public Index getIndexForColumn(Column column, boolean bl) {
        ArrayList<Index> arrayList = this.getIndexes();
        for (int i = 1; arrayList != null && i < arrayList.size(); ++i) {
            int n;
            Index index = arrayList.get(i);
            if (!index.canGetFirstOrLast() || (n = index.getColumnIndex(column)) != 0) continue;
            return index;
        }
        return null;
    }

    public boolean getOnCommitDrop() {
        return this.onCommitDrop;
    }

    public void setOnCommitDrop(boolean bl) {
        this.onCommitDrop = bl;
    }

    public boolean getOnCommitTruncate() {
        return this.onCommitTruncate;
    }

    public void setOnCommitTruncate(boolean bl) {
        this.onCommitTruncate = bl;
    }

    public void removeIndexOrTransferOwnership(Session session, Index index) {
        boolean bl = false;
        for (int i = 0; this.constraints != null && i < this.constraints.size(); ++i) {
            Constraint constraint = this.constraints.get(i);
            if (!constraint.usesIndex(index)) continue;
            constraint.setIndexOwner(index);
            this.database.update(session, constraint);
            bl = true;
        }
        if (!bl) {
            this.database.removeSchemaObject(session, index);
        }
    }

    public ArrayList<Session> checkDeadlock(Session session, Session session2, Set<Session> set) {
        return null;
    }

    public boolean isPersistIndexes() {
        return this.persistIndexes;
    }

    public boolean isPersistData() {
        return this.persistData;
    }

    public int compareTypeSave(Value value, Value value2) {
        int n = Value.getHigherOrder(value.getType(), value2.getType());
        value = value.convertTo(n);
        value2 = value2.convertTo(n);
        return value.compareTypeSave(value2, this.compareMode);
    }

    public CompareMode getCompareMode() {
        return this.compareMode;
    }

    public void checkWritingAllowed() {
        this.database.checkWritingAllowed();
    }

    public Value getDefaultValue(Session session, Column column) {
        Expression expression = column.getDefaultExpression();
        Value value = expression == null ? column.validateConvertUpdateSequence(session, null) : expression.getValue(session);
        return column.convert(value);
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }
}

