/*
 * Decompiled with CFR 0.152.
 */
package org.h2.android;

import android.content.ContentValues;
import android.database.Cursor;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import org.h2.android.H2CursorDriver;
import org.h2.android.H2Query;
import org.h2.android.H2Statement;
import org.h2.android.H2TransactionListener;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Engine;
import org.h2.engine.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H2Database {
    public static final int CONFLICT_ABORT = 2;
    public static final int CONFLICT_FAIL = 3;
    public static final int CONFLICT_IGNORE = 4;
    public static final int CONFLICT_NONE = 0;
    public static final int CONFLICT_REPLACE = 5;
    public static final int CONFLICT_ROLLBACK = 1;
    public static final int CREATE_IF_NECESSARY = 0x10000000;
    public static final int NO_LOCALIZED_COLLATORS = 16;
    public static final int OPEN_READONLY = 1;
    public static final int OPEN_READWRITE = 0;
    private final Session session;

    private H2Database(Session session) {
        this.session = session;
    }

    public static H2Database create(CursorFactory cursorFactory) {
        ConnectionInfo connectionInfo = new ConnectionInfo("mem:");
        Session session = Engine.getInstance().createSession(connectionInfo);
        return new H2Database(session);
    }

    public static H2Database openDatabase(String string, CursorFactory cursorFactory, int n) {
        ConnectionInfo connectionInfo = new ConnectionInfo(string);
        if ((n & 0) != 0) {
            // empty if block
        }
        if ((n & 0x10000000) == 0) {
            connectionInfo.setProperty("IFEXISTS", "TRUE");
        }
        Session session = Engine.getInstance().createSession(connectionInfo);
        return new H2Database(session);
    }

    public static H2Database openOrCreateDatabase(File file, CursorFactory cursorFactory) {
        return H2Database.openDatabase(file.getPath(), cursorFactory, 0x10000000);
    }

    public static H2Database openOrCreateDatabase(String string, CursorFactory cursorFactory) {
        return H2Database.openDatabase(string, cursorFactory, 0x10000000);
    }

    public void beginTransaction() {
        this.session.setAutoCommit(false);
    }

    public void beginTransactionWithListener(H2TransactionListener h2TransactionListener) {
        this.session.setAutoCommit(false);
    }

    public void close() {
        this.session.close();
    }

    public H2Statement compileStatement(String string) {
        return new H2Statement(this.session.prepare(string));
    }

    public int delete(String string, String string2, String[] stringArray) {
        return 0;
    }

    public void endTransaction() {
    }

    public void execSQL(String string, Object[] objectArray) {
    }

    public void execSQL(String string) {
    }

    public static String findEditTable(String string) {
        return null;
    }

    public long getMaximumSize() {
        return Long.MAX_VALUE;
    }

    public long getPageSize() {
        return 0L;
    }

    public String getPath() {
        return null;
    }

    public Map<String, String> getSyncedTables() {
        return null;
    }

    public int getVersion() {
        return 0;
    }

    public boolean inTransaction() {
        return false;
    }

    public long insert(String string, String string2, ContentValues contentValues) {
        return 0L;
    }

    public long insertOrThrow(String string, String string2, ContentValues contentValues) {
        return 0L;
    }

    public long insertWithOnConflict(String string, String string2, ContentValues contentValues, int n) {
        return 0L;
    }

    public boolean isDbLockedByCurrentThread() {
        return false;
    }

    public boolean isDbLockedByOtherThreads() {
        return false;
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void markTableSyncable(String string, String string2) {
    }

    public void markTableSyncable(String string, String string2, String string3) {
    }

    public boolean needUpgrade(int n) {
        return false;
    }

    public Cursor query(boolean bl, String string, String[] stringArray, String string2, String[] stringArray2, String string3, String string4, String string5, String string6) {
        return null;
    }

    public Cursor query(String string, String[] stringArray, String string2, String[] stringArray2, String string3, String string4, String string5) {
        return null;
    }

    public Cursor query(String string, String[] stringArray, String string2, String[] stringArray2, String string3, String string4, String string5, String string6) {
        return null;
    }

    public Cursor queryWithFactory(CursorFactory cursorFactory, boolean bl, String string, String[] stringArray, String string2, String[] stringArray2, String string3, String string4, String string5, String string6) {
        return null;
    }

    public Cursor rawQuery(String string, String[] stringArray) {
        return null;
    }

    public Cursor rawQueryWithFactory(CursorFactory cursorFactory, String string, String[] stringArray, String string2) {
        return null;
    }

    public static int releaseMemory() {
        return 0;
    }

    public long replace(String string, String string2, ContentValues contentValues) {
        return 0L;
    }

    public long replaceOrThrow(String string, String string2, ContentValues contentValues) {
        return 0L;
    }

    public void setLocale(Locale locale) {
    }

    public void setLockingEnabled(boolean bl) {
    }

    public long setMaximumSize(long l) {
        return 0L;
    }

    public void setPageSize(long l) {
    }

    public void setTransactionSuccessful() {
    }

    public void setVersion(int n) {
    }

    public int update(String string, ContentValues contentValues, String string2, String[] stringArray) {
        return 0;
    }

    public int updateWithOnConflict(String string, ContentValues contentValues, String string2, String[] stringArray, int n) {
        return 0;
    }

    public boolean yieldIfContended() {
        return false;
    }

    public boolean yieldIfContendedSafely(long l) {
        return false;
    }

    public boolean yieldIfContendedSafely() {
        return false;
    }

    public static interface CursorFactory {
        public Cursor newCursor(H2Database var1, H2CursorDriver var2, String var3, H2Query var4);
    }
}

