/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.HashMap;
import org.h2.command.Parser;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectListColumnResolver;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;

public class ExpressionColumn
extends Expression {
    private Database database;
    private String schemaName;
    private String tableAlias;
    private String columnName;
    private ColumnResolver columnResolver;
    private int queryLevel;
    private Column column;
    private boolean evaluatable;

    public ExpressionColumn(Database database, Column column) {
        this.database = database;
        this.column = column;
    }

    public ExpressionColumn(Database database, String string, String string2, String string3) {
        this.database = database;
        this.schemaName = string;
        this.tableAlias = string2;
        this.columnName = string3;
    }

    public String getSQL() {
        String string = this.column != null ? this.column.getSQL() : Parser.quoteIdentifier(this.columnName);
        if (this.tableAlias != null) {
            string = Parser.quoteIdentifier(this.tableAlias) + "." + string;
        }
        if (this.schemaName != null) {
            string = Parser.quoteIdentifier(this.schemaName) + "." + string;
        }
        return string;
    }

    public TableFilter getTableFilter() {
        return this.columnResolver == null ? null : this.columnResolver.getTableFilter();
    }

    public void mapColumns(ColumnResolver columnResolver, int n) {
        if (this.tableAlias != null && !this.tableAlias.equals(columnResolver.getTableAlias())) {
            return;
        }
        if (this.schemaName != null && !this.schemaName.equals(columnResolver.getSchemaName())) {
            return;
        }
        for (Column column : columnResolver.getColumns()) {
            if (!this.columnName.equals(column.getName())) continue;
            this.mapColumn(columnResolver, column, n);
            return;
        }
        Column[] columnArray = columnResolver.getSystemColumns();
        for (int i = 0; columnArray != null && i < columnArray.length; ++i) {
            Column column = columnArray[i];
            if (!this.columnName.equals(column.getName())) continue;
            this.mapColumn(columnResolver, column, n);
            return;
        }
    }

    private void mapColumn(ColumnResolver columnResolver, Column column, int n) {
        if (this.columnResolver == null) {
            this.queryLevel = n;
            this.column = column;
            this.columnResolver = columnResolver;
        } else if (this.queryLevel == n && this.columnResolver != columnResolver && !(columnResolver instanceof SelectListColumnResolver)) {
            throw DbException.get(90059, this.columnName);
        }
    }

    public Expression optimize(Session session) {
        if (this.columnResolver == null) {
            Object object;
            Schema schema = session.getDatabase().findSchema(this.tableAlias == null ? session.getCurrentSchemaName() : this.tableAlias);
            if (schema != null && (object = schema.findConstant(this.columnName)) != null) {
                return ((Constant)object).getValue();
            }
            object = this.columnName;
            if (this.tableAlias != null) {
                object = this.tableAlias + "." + (String)object;
                if (this.schemaName != null) {
                    object = this.schemaName + "." + (String)object;
                }
            }
            throw DbException.get(42122, (String)object);
        }
        return this.columnResolver.optimize(this, this.column);
    }

    public void updateAggregate(Session session) {
        Value value = this.columnResolver.getValue(this.column);
        Select select = this.columnResolver.getSelect();
        if (select == null) {
            throw DbException.get(90016, this.getSQL());
        }
        HashMap<Expression, Object> hashMap = select.getCurrentGroup();
        if (hashMap == null) {
            return;
        }
        Value value2 = (Value)hashMap.get(this);
        if (value2 == null) {
            hashMap.put(this, value);
        } else if (!this.database.areEqual(value, value2)) {
            throw DbException.get(90016, this.getSQL());
        }
    }

    public Value getValue(Session session) {
        Value value;
        Object object;
        Select select = this.columnResolver.getSelect();
        if (select != null && (object = select.getCurrentGroup()) != null && (value = (Value)((HashMap)object).get(this)) != null) {
            return value;
        }
        object = this.columnResolver.getValue(this.column);
        if (object == null) {
            this.columnResolver.getValue(this.column);
            throw DbException.get(90016, this.getSQL());
        }
        return object;
    }

    public int getType() {
        return this.column.getType();
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        if (this.columnResolver != null && tableFilter == this.columnResolver.getTableFilter()) {
            this.evaluatable = bl;
        }
    }

    public Column getColumn() {
        return this.column;
    }

    public int getScale() {
        return this.column.getScale();
    }

    public long getPrecision() {
        return this.column.getPrecision();
    }

    public int getDisplaySize() {
        return this.column.getDisplaySize();
    }

    public String getOriginalColumnName() {
        return this.columnName;
    }

    public String getOriginalTableAliasName() {
        return this.tableAlias;
    }

    public String getColumnName() {
        return this.columnName != null ? this.columnName : this.column.getName();
    }

    public String getSchemaName() {
        Table table = this.column.getTable();
        return table == null ? null : table.getSchema().getName();
    }

    public String getTableName() {
        Table table = this.column.getTable();
        return table == null ? null : table.getName();
    }

    public String getAlias() {
        return this.column == null ? null : this.column.getName();
    }

    public boolean isAutoIncrement() {
        return this.column.getSequence() != null;
    }

    public int getNullable() {
        return this.column.isNullable() ? 1 : 0;
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 1: {
                return false;
            }
            case 2: 
            case 5: 
            case 8: {
                return true;
            }
            case 0: {
                return this.queryLevel < expressionVisitor.getQueryLevel();
            }
            case 3: {
                if (this.database.getSettings().nestedJoins) {
                    if (expressionVisitor.getQueryLevel() < this.queryLevel) {
                        return true;
                    }
                    if (this.getTableFilter() == null) {
                        return false;
                    }
                    return this.getTableFilter().isEvaluatable();
                }
                return this.evaluatable || expressionVisitor.getQueryLevel() < this.queryLevel;
            }
            case 4: {
                expressionVisitor.addDataModificationId(this.column.getTable().getMaxDataModificationId());
                return true;
            }
            case 6: {
                return this.columnResolver != expressionVisitor.getResolver();
            }
            case 7: {
                expressionVisitor.addDependency(this.column.getTable());
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    public int getCost() {
        return 2;
    }

    public void createIndexConditions(Session session, TableFilter tableFilter) {
        TableFilter tableFilter2 = this.getTableFilter();
        if (tableFilter == tableFilter2 && this.column.getType() == 1) {
            IndexCondition indexCondition = IndexCondition.get(0, this, ValueExpression.get(ValueBoolean.get(true)));
            tableFilter.addIndexCondition(indexCondition);
        }
    }

    public Expression getNotIfPossible(Session session) {
        return new Comparison(session, 0, this, ValueExpression.get(ValueBoolean.get(false)));
    }
}

