/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.command.CommandInterface;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.util.MathUtils;
import org.h2.value.DataType;

public class JdbcParameterMetaData
extends TraceObject
implements ParameterMetaData {
    private JdbcPreparedStatement prep;
    private int paramCount;
    private ArrayList<? extends ParameterInterface> parameters;

    JdbcParameterMetaData(Trace trace, JdbcPreparedStatement jdbcPreparedStatement, CommandInterface commandInterface, int n) {
        this.setTrace(trace, 11, n);
        this.prep = jdbcPreparedStatement;
        this.parameters = commandInterface.getParameters();
        this.paramCount = this.parameters.size();
    }

    public int getParameterCount() throws SQLException {
        try {
            this.debugCodeCall("getParameterCount");
            this.checkClosed();
            return this.paramCount;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getParameterMode(int n) throws SQLException {
        try {
            this.debugCodeCall("getParameterMode", n);
            this.getParameter(n);
            return 1;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getParameterType(int n) throws SQLException {
        try {
            this.debugCodeCall("getParameterType", n);
            ParameterInterface parameterInterface = this.getParameter(n);
            int n2 = parameterInterface.getType();
            if (n2 == -1) {
                n2 = 13;
            }
            return DataType.getDataType((int)n2).sqlType;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getPrecision(int n) throws SQLException {
        try {
            this.debugCodeCall("getPrecision", n);
            ParameterInterface parameterInterface = this.getParameter(n);
            return MathUtils.convertLongToInt(parameterInterface.getPrecision());
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getScale(int n) throws SQLException {
        try {
            this.debugCodeCall("getScale", n);
            ParameterInterface parameterInterface = this.getParameter(n);
            return parameterInterface.getScale();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int isNullable(int n) throws SQLException {
        try {
            this.debugCodeCall("isNullable", n);
            return this.getParameter(n).getNullable();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isSigned(int n) throws SQLException {
        try {
            this.debugCodeCall("isSigned", n);
            this.getParameter(n);
            return true;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String getParameterClassName(int n) throws SQLException {
        try {
            this.debugCodeCall("getParameterClassName", n);
            ParameterInterface parameterInterface = this.getParameter(n);
            int n2 = parameterInterface.getType();
            if (n2 == -1) {
                n2 = 13;
            }
            return DataType.getTypeClassName(n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String getParameterTypeName(int n) throws SQLException {
        try {
            this.debugCodeCall("getParameterTypeName", n);
            ParameterInterface parameterInterface = this.getParameter(n);
            int n2 = parameterInterface.getType();
            if (n2 == -1) {
                n2 = 13;
            }
            return DataType.getDataType((int)n2).name;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private ParameterInterface getParameter(int n) throws SQLException {
        this.checkClosed();
        if (n < 1 || n > this.paramCount) {
            throw DbException.getInvalidValueException("param", n);
        }
        return this.parameters.get(n - 1);
    }

    private void checkClosed() throws SQLException {
        this.prep.checkClosed();
    }

    public String toString() {
        return this.getTraceObjectName() + ": parameterCount=" + this.paramCount;
    }
}

