/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.ConditionInConstantSet;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.index.IndexCondition;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionIn
extends Condition {
    private final Database database;
    private Expression left;
    private final ArrayList<Expression> valueList;
    private int queryLevel;

    public ConditionIn(Database database, Expression expression, ArrayList<Expression> arrayList) {
        this.database = database;
        this.left = expression;
        this.valueList = arrayList;
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.left.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Expression expression : this.valueList) {
            Value value2 = expression.getValue(session);
            if (value2 == ValueNull.INSTANCE) {
                bl2 = true;
                continue;
            }
            bl = Comparison.compareNotNull(this.database, value, value2 = value2.convertTo(value.getType()), 0);
            if (!bl) continue;
            break;
        }
        if (!bl && bl2) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(bl);
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.left.mapColumns(columnResolver, n);
        for (Expression expression : this.valueList) {
            expression.mapColumns(columnResolver, n);
        }
        this.queryLevel = Math.max(n, this.queryLevel);
    }

    @Override
    public Expression optimize(Session session) {
        Expression expression;
        int n;
        this.left = this.left.optimize(session);
        boolean bl = this.left.isConstant();
        if (bl && this.left == ValueExpression.getNull()) {
            return this.left;
        }
        boolean bl2 = true;
        boolean bl3 = true;
        int n2 = this.valueList.size();
        for (n = 0; n < n2; ++n) {
            expression = this.valueList.get(n);
            if ((expression = expression.optimize(session)).isConstant() && expression.getValue(session) != ValueNull.INSTANCE) {
                bl3 = false;
            }
            if (bl2 && !expression.isConstant()) {
                bl2 = false;
            }
            if (this.left instanceof ExpressionColumn && expression instanceof Parameter) {
                ((Parameter)expression).setColumn(((ExpressionColumn)this.left).getColumn());
            }
            this.valueList.set(n, expression);
        }
        if (bl && bl2) {
            return ValueExpression.get(this.getValue(session));
        }
        if (n2 == 1) {
            Expression expression2 = this.valueList.get(0);
            expression = new Comparison(session, 0, this.left, expression2);
            expression = expression.optimize(session);
            return expression;
        }
        if (bl2 && !bl3) {
            n = this.left.getType();
            if (n == -1) {
                return this;
            }
            expression = new ConditionInConstantSet(session, this.left, this.valueList);
            expression = expression.optimize(session);
            return expression;
        }
        return this;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        if (session.getDatabase().getSettings().optimizeInList) {
            ExpressionVisitor expressionVisitor = ExpressionVisitor.getNotFromResolverVisitor(tableFilter);
            for (Expression expression : this.valueList) {
                if (expression.isEverything(expressionVisitor)) continue;
                return;
            }
            tableFilter.addIndexCondition(IndexCondition.getInList(expressionColumn, this.valueList));
            return;
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        for (Expression expression : this.valueList) {
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        statementBuilder.append(this.left.getSQL()).append(" IN(");
        for (Expression expression : this.valueList) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expression.getSQL());
        }
        return statementBuilder.append("))").toString();
    }

    @Override
    public void updateAggregate(Session session) {
        this.left.updateAggregate(session);
        for (Expression expression : this.valueList) {
            expression.updateAggregate(session);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (!this.left.isEverything(expressionVisitor)) {
            return false;
        }
        return this.areAllValues(expressionVisitor);
    }

    private boolean areAllValues(ExpressionVisitor expressionVisitor) {
        for (Expression expression : this.valueList) {
            if (expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCost() {
        int n = this.left.getCost();
        for (Expression expression : this.valueList) {
            n += expression.getCost();
        }
        return n;
    }

    @Override
    public boolean isDisjunctive() {
        return true;
    }

    Expression getAdditional(Comparison comparison) {
        Expression expression = comparison.getIfEquals(this.left);
        if (expression != null) {
            this.valueList.add(expression);
            return this;
        }
        return null;
    }
}

