/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.layout;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.FSTextBreaker;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.LineBreakContext;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.layout.TextUtil;
import com.openhtmltopdf.render.FSFont;

public class Breaker {
    public static final char SOFT_HYPHEN = '\u00ad';
    public static final TextBreakerSupplier STANDARD_CHARACTER_BREAKER = new CharacterBreakerSupplier();
    public static final TextBreakerSupplier STANDARD_LINE_BREAKER = new LineBreakerSupplier();

    public static void breakFirstLetter(LayoutContext c, LineBreakContext context, int avail, CalculatedStyle style) {
        FSFont font = style.getFSFont(c);
        float letterSpacing = style.hasLetterSpacing() ? style.getFloatPropertyProportionalWidth(CSSName.LETTER_SPACING, 0.0f, c) : 0.0f;
        context.setEnd(Breaker.getFirstLetterEnd(context.getMaster(), context.getStart()));
        context.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), font, context.getCalculatedSubstring()) + (int)letterSpacing);
        if (context.getWidth() > avail) {
            context.setNeedsNewLine(true);
            context.setUnbreakable(true);
        }
    }

    private static int getFirstLetterEnd(String text, int start) {
        int currentChar;
        boolean letterFound = false;
        int end = text.length();
        for (int i = start; i < end; i += Character.charCount(currentChar)) {
            currentChar = text.codePointAt(i);
            if (TextUtil.isFirstLetterSeparatorChar(currentChar)) continue;
            if (letterFound) {
                return i;
            }
            letterFound = true;
        }
        return end;
    }

    public static void breakText(LayoutContext c, LineBreakContext context, int avail, CalculatedStyle style) {
        float letterSpacing;
        FSFont font = style.getFSFont(c);
        IdentValue whitespace = style.getWhitespace();
        float f = letterSpacing = style.hasLetterSpacing() ? style.getFloatPropertyProportionalWidth(CSSName.LETTER_SPACING, 0.0f, c) : 0.0f;
        if (whitespace == IdentValue.NOWRAP) {
            context.setEnd(context.getLast());
            context.setWidth(Breaker.getTextWidthWithLetterSpacing(c, font, context.getCalculatedSubstring(), letterSpacing));
            return;
        }
        if (whitespace == IdentValue.PRE || whitespace == IdentValue.PRE_WRAP || whitespace == IdentValue.PRE_LINE) {
            int n = context.getStartSubstring().indexOf("\n");
            if (n > -1) {
                context.setEnd(context.getStart() + n + 1);
                context.setWidth(Breaker.getTextWidthWithLetterSpacing(c, font, context.getCalculatedSubstring(), letterSpacing));
                context.setNeedsNewLine(true);
                context.setEndsOnNL(true);
            } else if (whitespace == IdentValue.PRE) {
                context.setEnd(context.getLast());
                context.setWidth(Breaker.getTextWidthWithLetterSpacing(c, font, context.getCalculatedSubstring(), letterSpacing));
            }
        }
        if (whitespace == IdentValue.PRE || context.isNeedsNewLine() && context.getWidth() <= avail) {
            return;
        }
        context.setEndsOnNL(false);
        Breaker.doBreakText(c, context, avail, style, false);
    }

    private static void doBreakText(LayoutContext c, LineBreakContext context, int avail, CalculatedStyle style, boolean tryToBreakAnywhere) {
        Breaker.doBreakText(c, context, avail, style, STANDARD_CHARACTER_BREAKER, STANDARD_LINE_BREAKER, tryToBreakAnywhere);
    }

    public static void doBreakText(LayoutContext c, LineBreakContext context, int avail, CalculatedStyle style, TextBreakerSupplier characterBreaker, TextBreakerSupplier lineBreaker, boolean tryToBreakAnywhere) {
        float extraSpacing;
        FSFont font = style.getFSFont(c);
        float letterSpacing = style.hasLetterSpacing() ? style.getFloatPropertyProportionalWidth(CSSName.LETTER_SPACING, 0.0f, c) : 0.0f;
        String currentString = context.getStartSubstring();
        FSTextBreaker iterator = tryToBreakAnywhere ? characterBreaker.getBreaker(currentString, c.getSharedContext()) : lineBreaker.getBreaker(currentString, c.getSharedContext());
        int lastWrap = 0;
        AppBreakOpportunity current = new AppBreakOpportunity();
        AppBreakOpportunity prev = new AppBreakOpportunity();
        current.right = iterator.next();
        while (current.right > 0 && current.graphicsLength <= avail) {
            current.copyTo(prev);
            String subString = currentString.substring(current.left, current.right);
            extraSpacing = (float)(current.right - current.left) * letterSpacing;
            int normalSplitWidth = (int)((float)c.getTextRenderer().getWidth(c.getFontContext(), font, subString) + extraSpacing);
            if (currentString.charAt(current.right - 1) == '\u00ad') {
                current.isSoftHyphenBreak = true;
                int withTrailingHyphenSplitWidth = (int)((float)c.getTextRenderer().getWidth(c.getFontContext(), font, subString + '-') + extraSpacing + letterSpacing);
                current.withHyphenGraphicsLength = current.graphicsLength + withTrailingHyphenSplitWidth;
                if (current.withHyphenGraphicsLength > avail) {
                    current.graphicsLength = current.withHyphenGraphicsLength;
                    lastWrap = current.left;
                    current.left = current.right;
                    current.right = iterator.next();
                    break;
                }
            } else {
                current.isSoftHyphenBreak = false;
                current.withHyphenGraphicsLength += normalSplitWidth;
            }
            current.graphicsLength += normalSplitWidth;
            lastWrap = current.left;
            current.left = current.right;
            current.right = iterator.next();
        }
        if (current.graphicsLength <= avail) {
            lastWrap = current.left;
            current.copyTo(prev);
            current.right = currentString.length();
            float extraSpacing2 = (float)(current.right - current.left) * letterSpacing;
            current.graphicsLength = (int)((float)current.graphicsLength + ((float)c.getTextRenderer().getWidth(c.getFontContext(), font, currentString.substring(current.left)) + extraSpacing2));
        }
        if (current.graphicsLength <= avail) {
            context.setWidth(current.graphicsLength);
            context.setEnd(context.getMaster().length());
            return;
        }
        context.setNeedsNewLine(true);
        if (lastWrap == 0 && style.getWordWrap() == IdentValue.BREAK_WORD && !tryToBreakAnywhere) {
            Breaker.doBreakText(c, context, avail, style, characterBreaker, lineBreaker, true);
            return;
        }
        if (lastWrap != 0) {
            if (prev.isSoftHyphenBreak) {
                context.setEndsOnSoftHyphen(true);
                context.setWidth(prev.withHyphenGraphicsLength);
            } else {
                context.setWidth(prev.graphicsLength);
            }
            context.setEnd(context.getStart() + lastWrap);
        } else {
            if (current.left == 0) {
                current.left = currentString.length();
            }
            context.setEnd(context.getStart() + current.left);
            context.setUnbreakable(true);
            if (current.left == currentString.length()) {
                String text = context.getCalculatedSubstring();
                extraSpacing = (float)text.length() * letterSpacing;
                context.setWidth((int)((float)c.getTextRenderer().getWidth(c.getFontContext(), font, text) + extraSpacing));
            } else {
                context.setWidth(current.graphicsLength);
            }
        }
    }

    public static FSTextBreaker getCharacterBreakStream(String currentString, SharedContext sharedContext) {
        FSTextBreaker i = sharedContext.getCharacterBreaker();
        i.setText(currentString);
        return i;
    }

    public static FSTextBreaker getLineBreakStream(String s, SharedContext shared) {
        FSTextBreaker i = shared.getLineBreaker();
        i.setText(s);
        return i;
    }

    public static int getTextWidthWithLetterSpacing(CssContext c, FSFont font, String text, float letterSpacing) {
        float extraSpace = (float)text.length() * letterSpacing;
        return (int)((float)c.getTextRenderer().getWidth(c.getFontContext(), font, text) + extraSpace);
    }

    public static interface TextBreakerSupplier {
        public FSTextBreaker getBreaker(String var1, SharedContext var2);
    }

    private static class AppBreakOpportunity {
        int left;
        int right;
        int graphicsLength;
        int withHyphenGraphicsLength;
        boolean isSoftHyphenBreak;

        private AppBreakOpportunity() {
        }

        void copyTo(AppBreakOpportunity other) {
            other.left = this.left;
            other.right = this.right;
            other.graphicsLength = this.graphicsLength;
            other.withHyphenGraphicsLength = this.withHyphenGraphicsLength;
            other.isSoftHyphenBreak = this.isSoftHyphenBreak;
        }
    }

    private static class CharacterBreakerSupplier
    implements TextBreakerSupplier {
        private CharacterBreakerSupplier() {
        }

        @Override
        public FSTextBreaker getBreaker(String str, SharedContext sharedContext) {
            return Breaker.getCharacterBreakStream(str, sharedContext);
        }
    }

    private static class LineBreakerSupplier
    implements TextBreakerSupplier {
        private LineBreakerSupplier() {
        }

        @Override
        public FSTextBreaker getBreaker(String str, SharedContext sharedContext) {
            return Breaker.getLineBreakStream(str, sharedContext);
        }
    }
}

