/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;

class T4CInputStream
extends OracleInputStream {
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Tue_Jan_24_08:54:31_PST_2006";

    T4CInputStream(OracleStatement oracleStatement, int n, Accessor accessor) {
        super(oracleStatement, n, accessor);
    }

    public boolean isNull() throws IOException {
        if (!this.statement.connection.useFetchSizeWithLongColumn) {
            return super.isNull();
        }
        boolean bl = false;
        try {
            int n = this.statement.currentRow;
            if (n < 0) {
                n = 0;
            }
            if (n >= this.statement.validRows) {
                return true;
            }
            bl = this.accessor.isNull(n);
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBytes() throws IOException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            T4CInputStream t4CInputStream = this;
            synchronized (t4CInputStream) {
                int n = 0;
                try {
                    n = this.accessor.readStream(this.buf, this.chunkSize);
                }
                catch (SQLException sQLException) {
                    throw new IOException(sQLException.getMessage());
                }
                catch (IOException iOException) {
                    try {
                        ((T4CConnection)this.statement.connection).handleIOException(iOException);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw iOException;
                }
                return n;
            }
        }
    }
}

