/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.OWLRealInterval;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.RestrictedRealDatatype;
import com.clarkparsia.pellet.datatypes.XSDDecimal;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDInteger
implements Datatype<Number> {
    private static final XSDInteger instance;
    private static final Logger log;
    private final RestrictedRealDatatype dataRange;
    private final int hashCode;
    private final ATermAppl name = ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#integer");

    public static XSDInteger getInstance() {
        return instance;
    }

    private XSDInteger() {
        this.hashCode = this.name.hashCode();
        this.dataRange = new RestrictedRealDatatype(this, OWLRealInterval.allIntegers());
    }

    @Override
    public RestrictedDatatype<Number> asDataRange() {
        return this.dataRange;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(input)) {
            throw new IllegalArgumentException();
        }
        if (!input.getArgument(2).equals(this.name)) {
            throw new IllegalArgumentException();
        }
        String lexicalForm = ATermUtils.getLiteralValue(input);
        try {
            DatatypeConverter.parseInteger((String)lexicalForm);
        }
        catch (NumberFormatException e) {
            log.severe(String.format("Number format exception (%s) cause while parsing integer %s", e.getMessage(), lexicalForm));
            throw new InvalidLiteralException(this.name, lexicalForm);
        }
        return XSDDecimal.getInstance().getCanonicalRepresentation(ATermUtils.makeTypedLiteral(lexicalForm, XSDDecimal.getInstance().getName()));
    }

    public List<Datatype<?>> getDerivedFrom() {
        return Collections.singletonList(XSDDecimal.getInstance());
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return XSDDecimal.getInstance();
    }

    @Override
    public Number getValue(ATermAppl literal) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(literal)) {
            throw new IllegalArgumentException();
        }
        if (!literal.getArgument(2).equals(this.name)) {
            throw new IllegalArgumentException();
        }
        String lexicalForm = ATermUtils.getLiteralValue(literal);
        try {
            return OWLRealUtils.getCanonicalObject(DatatypeConverter.parseInteger((String)lexicalForm));
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.name, lexicalForm);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    static {
        log = Logger.getLogger(XSDInteger.class.getCanonicalName());
        instance = new XSDInteger();
    }
}

