/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import javax.xml.bind.DatatypeConverter;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDShort
extends AbstractDerivedIntegerType {
    private static final XSDShort instance = new XSDShort();

    public static XSDShort getInstance() {
        return instance;
    }

    private XSDShort() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#short"), (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
    }

    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            int n = DatatypeConverter.parseInt((String)lexicalForm);
            if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return (short)n;
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }
}

