/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.exceptions.DatatypeReasonerException;
import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.exceptions.InternalReasonerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataRangeBindingHelper
implements BindingHelper {
    private static final Logger log = Logger.getLogger(DataRangeBindingHelper.class.getCanonicalName());
    private DatatypeReasoner dtReasoner;
    private DataRangeAtom atom;
    private boolean hasNext;

    public DataRangeBindingHelper(ABox abox, DataRangeAtom atom) {
        this.dtReasoner = abox.getDatatypeReasoner();
        this.atom = atom;
        this.hasNext = false;
    }

    public Collection<AtomVariable> getBindableVars(Collection<AtomVariable> bound) {
        return Collections.emptySet();
    }

    public Collection<AtomVariable> getPrerequisiteVars(Collection<AtomVariable> bound) {
        return VariableUtils.getVars(this.atom);
    }

    @Override
    public void rebind(VariableBinding newBinding) {
        Literal dValue = newBinding.get((AtomDObject)this.atom.getArgument());
        if (dValue == null) {
            throw new InternalReasonerException("DataRangeBindingHelper cannot generate bindings for " + this.atom);
        }
        try {
            this.hasNext = this.dtReasoner.isSatisfiable(Collections.singleton(this.atom.getPredicate()), dValue.getValue());
        }
        catch (DatatypeReasonerException e) {
            String msg = "Unexpected datatype reasoner exception: " + e.getMessage();
            log.severe(msg);
            throw new InternalReasonerException(e);
        }
    }

    @Override
    public boolean selectNextBinding() {
        if (this.hasNext) {
            this.hasNext = false;
            return true;
        }
        return false;
    }

    @Override
    public void setCurrentBinding(VariableBinding currentBinding) {
    }

    public String toString() {
        return this.atom.toString();
    }
}

