/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.AtomObject;
import com.clarkparsia.pellet.rules.model.AtomObjectVisitor;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.RuleAtomVisitor;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import com.clarkparsia.pellet.rules.rete.Compiler;
import com.clarkparsia.pellet.rules.rete.TermTuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesToReteTranslator {
    private static Logger log = ABox.log;
    private ABox abox;

    public RulesToReteTranslator(ABox abox) {
        this.abox = abox;
    }

    public TermTuple translateAtom(RuleAtom atom, DependencySet ds) {
        AtomTranslator translator = new AtomTranslator(ds);
        atom.accept(translator);
        return translator.getResult();
    }

    public Pair<ATermAppl, DependencySet> translateAtomObject(AtomObject obj) {
        AtomObjectTranslator translator = new AtomObjectTranslator();
        obj.accept(translator);
        return new Pair<ATermAppl, DependencySet>(translator.getResult(), translator.getDependency());
    }

    public List<TermTuple> translateAtoms(Collection<? extends RuleAtom> atoms, DependencySet ds) {
        ArrayList<TermTuple> result = new ArrayList<TermTuple>(atoms.size());
        for (RuleAtom ruleAtom : atoms) {
            TermTuple triple = this.translateAtom(ruleAtom, ds);
            if (triple == null) {
                return null;
            }
            result.add(triple);
        }
        return result;
    }

    public com.clarkparsia.pellet.rules.rete.Rule translateRule(Rule rule) {
        com.clarkparsia.pellet.rules.rete.Rule reteRule;
        DependencySet ds = DependencySet.INDEPENDENT;
        List<TermTuple> head = this.translateAtoms(rule.getHead(), ds);
        List<TermTuple> body = this.translateAtoms(rule.getBody(), ds);
        if (head == null || body == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Not translating rule " + rule + " to rete format.");
            }
            reteRule = null;
        } else {
            reteRule = new com.clarkparsia.pellet.rules.rete.Rule(body, head);
        }
        return reteRule;
    }

    private class AtomTranslator
    implements RuleAtomVisitor {
        private DependencySet ds = null;
        private TermTuple result = null;

        public AtomTranslator(DependencySet ds) {
            this.ds = ds;
        }

        public TermTuple getResult() {
            return this.result;
        }

        public void visit(BuiltInAtom atom) {
            log.fine("Not translating built-in " + atom + " to rete triple.");
        }

        public void visit(ClassAtom atom) {
            Pair<ATermAppl, DependencySet> arg = RulesToReteTranslator.this.translateAtomObject((AtomObject)atom.getArgument());
            DependencySet mergedDS = this.ds;
            if (arg.second != DependencySet.INDEPENDENT) {
                mergedDS = this.ds.union((DependencySet)arg.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            this.result = new TermTuple(mergedDS, Compiler.TYPE, (ATermAppl)arg.first, (ATermAppl)atom.getPredicate());
        }

        public void visit(DataRangeAtom atom) {
            log.fine("Not translating data range atom " + atom + " to rete triple.");
        }

        public void visit(DatavaluedPropertyAtom atom) {
            Pair<ATermAppl, DependencySet> arg1 = RulesToReteTranslator.this.translateAtomObject((AtomObject)atom.getArgument1());
            Pair<ATermAppl, DependencySet> arg2 = RulesToReteTranslator.this.translateAtomObject((AtomObject)atom.getArgument2());
            DependencySet mergedDS = this.ds;
            if (arg1.second != DependencySet.INDEPENDENT) {
                mergedDS = this.ds.union((DependencySet)arg1.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            if (arg2.second != DependencySet.INDEPENDENT) {
                mergedDS = this.ds.union((DependencySet)arg2.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            this.result = new TermTuple(mergedDS, (ATermAppl)atom.getPredicate(), (ATermAppl)arg1.first, (ATermAppl)arg2.first);
        }

        public void visit(DifferentIndividualsAtom atom) {
            Pair<ATermAppl, DependencySet> arg1 = RulesToReteTranslator.this.translateAtomObject((AtomObject)atom.getArgument1());
            Pair<ATermAppl, DependencySet> arg2 = RulesToReteTranslator.this.translateAtomObject((AtomObject)atom.getArgument2());
            DependencySet mergedDS = this.ds;
            if (arg1.second != DependencySet.INDEPENDENT) {
                mergedDS = this.ds.union((DependencySet)arg1.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            if (arg2.second != DependencySet.INDEPENDENT) {
                mergedDS = this.ds.union((DependencySet)arg2.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            this.result = new TermTuple(mergedDS, Compiler.DIFF_FROM, (ATermAppl)arg1.first, (ATermAppl)arg2.first);
        }

        public void visit(IndividualPropertyAtom atom) {
            Pair<ATermAppl, DependencySet> arg1 = RulesToReteTranslator.this.translateAtomObject((AtomObject)atom.getArgument1());
            Pair<ATermAppl, DependencySet> arg2 = RulesToReteTranslator.this.translateAtomObject((AtomObject)atom.getArgument2());
            DependencySet mergedDS = this.ds;
            if (arg1.second != DependencySet.INDEPENDENT) {
                mergedDS = this.ds.union((DependencySet)arg1.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            if (arg2.second != DependencySet.INDEPENDENT) {
                mergedDS = this.ds.union((DependencySet)arg2.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            this.result = new TermTuple(mergedDS, (ATermAppl)atom.getPredicate(), (ATermAppl)arg1.first, (ATermAppl)arg2.first);
        }

        public void visit(SameIndividualAtom atom) {
            Pair<ATermAppl, DependencySet> arg1 = RulesToReteTranslator.this.translateAtomObject((AtomObject)atom.getArgument1());
            Pair<ATermAppl, DependencySet> arg2 = RulesToReteTranslator.this.translateAtomObject((AtomObject)atom.getArgument2());
            DependencySet mergedDS = this.ds;
            if (arg1.second != DependencySet.INDEPENDENT) {
                mergedDS = this.ds.union((DependencySet)arg1.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            if (arg2.second != DependencySet.INDEPENDENT) {
                mergedDS = this.ds.union((DependencySet)arg2.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            this.result = new TermTuple(mergedDS, Compiler.SAME_AS, (ATermAppl)arg1.first, (ATermAppl)arg2.first);
        }
    }

    private class AtomObjectTranslator
    implements AtomObjectVisitor {
        private DependencySet dependency = DependencySet.INDEPENDENT;
        private ATermAppl result = null;

        private AtomObjectTranslator() {
        }

        public DependencySet getDependency() {
            return this.dependency;
        }

        public ATermAppl getResult() {
            return this.result;
        }

        public void visit(AtomDConstant constant) {
            ATermAppl canonical;
            ATermAppl literal = constant.getValue();
            try {
                canonical = RulesToReteTranslator.this.abox.getKB().getDatatypeReasoner().getCanonicalRepresentation(literal);
            }
            catch (InvalidLiteralException e) {
                String msg = String.format("Invalid literal (%s) in SWRL data constant: %s", literal, e.getMessage());
                if (PelletOptions.INVALID_LITERAL_AS_INCONSISTENCY) {
                    log.fine(msg);
                    canonical = literal;
                }
                log.severe(msg);
                throw new InternalReasonerException(msg, e);
            }
            catch (UnrecognizedDatatypeException e) {
                String msg = String.format("Unrecognized datatype in literal appearing (%s) in SWRL data constant: %s", literal, e.getMessage());
                log.severe(msg);
                throw new InternalReasonerException(msg, e);
            }
            this.result = canonical;
        }

        public void visit(AtomDVariable variable) {
            this.result = ATermUtils.makeVar(variable.getName());
        }

        public void visit(AtomIConstant constant) {
            RulesToReteTranslator.this.abox.copyOnWrite();
            Individual individual = RulesToReteTranslator.this.abox.getIndividual((ATerm)constant.getValue());
            if (individual.isMerged()) {
                this.dependency = individual.getMergeDependency(true);
                individual = individual.getSame();
            }
            this.result = individual.getName();
        }

        public void visit(AtomIVariable variable) {
            this.result = ATermUtils.makeVar(variable.getName());
        }
    }
}

