/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.builtins.BinaryTester;
import com.clarkparsia.pellet.rules.builtins.BuiltIn;
import com.clarkparsia.pellet.rules.builtins.ComparisonTesters;
import com.clarkparsia.pellet.rules.builtins.Function;
import com.clarkparsia.pellet.rules.builtins.StringFunctionAdapter;
import com.clarkparsia.pellet.rules.builtins.StringToStringFunction;
import com.clarkparsia.pellet.rules.builtins.Tester;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.utils.ATermUtils;

public class StringOperators {
    public static final Tester contains = new Contains();
    public static final Tester containsIgnoreCase = new ContainsIgnoreCase();
    public static final Tester endsWith = new EndsWith();
    public static final Function lowerCase = new StringFunctionAdapter(new LowerCase());
    public static final Tester matches = new Matches();
    public static final Function normalizeSpace = new StringFunctionAdapter(new NormalizeSpace());
    public static final Function replace = new StringFunctionAdapter(new Replace());
    public static final Tester startsWith = new StartsWith();
    public static final Function stringConcat = new StringFunctionAdapter(new StringConcat());
    public static final Tester stringEqualIgnoreCase = new StringEqualIgnoreCase();
    public static final Function stringLength = new StringLength();
    public static final Function substring = new StringFunctionAdapter(new SubString());
    public static final Function substringAfter = new StringFunctionAdapter(new SubStringAfter());
    public static final Function substringBefore = new StringFunctionAdapter(new SubStringBefore());
    public static final BuiltIn tokenize = new Tokenize();
    public static final Function translate = new StringFunctionAdapter(new Translate());
    public static final Function upperCase = new StringFunctionAdapter(new UpperCase());

    private static class UpperCase
    implements StringToStringFunction {
        private UpperCase() {
        }

        public String apply(String ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0].toUpperCase();
        }
    }

    private static class Translate
    implements StringToStringFunction {
        private Translate() {
        }

        public String apply(String ... args) {
            if (args.length != 3) {
                return null;
            }
            String src = args[1];
            String dst = args[2];
            StringBuffer result = new StringBuffer();
            for (char c : args[0].toCharArray()) {
                int replPos = src.indexOf(c);
                if (replPos < 0) {
                    result.append(c);
                    continue;
                }
                if (replPos >= dst.length()) continue;
                result.append(dst.charAt(replPos));
            }
            return result.toString();
        }
    }

    private static class Tokenize
    implements BuiltIn {
        public BindingHelper createHelper(BuiltInAtom atom) {
            return new TokenizeBindingHelper(atom);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class TokenizeBindingHelper
        implements BindingHelper {
            private BuiltInAtom atom;
            private AtomDObject head;
            private String match;
            private Iterator<String> tokens;

            public TokenizeBindingHelper(BuiltInAtom atom) {
                this.atom = atom;
                this.head = null;
                this.match = null;
                this.tokens = null;
            }

            @Override
            public Collection<? extends AtomVariable> getBindableVars(Collection<AtomVariable> bound) {
                this.head = null;
                for (AtomDObject obj : this.atom.getAllArguments()) {
                    if (this.head == null) {
                        this.head = obj;
                        if (VariableUtils.isVariable(this.head)) continue;
                        return Collections.emptySet();
                    }
                    if (!this.head.equals(obj)) continue;
                    return Collections.emptySet();
                }
                if (this.head == null) {
                    return Collections.emptySet();
                }
                return Collections.singleton((AtomVariable)((Object)this.head));
            }

            @Override
            public Collection<? extends AtomVariable> getPrerequisiteVars(Collection<AtomVariable> bound) {
                Collection<AtomVariable> vars = VariableUtils.getVars(this.atom);
                vars.removeAll(this.getBindableVars(bound));
                return vars;
            }

            @Override
            public void rebind(VariableBinding newBinding) {
                if (this.atom.getAllArguments().size() < 3) {
                    this.tokens = null;
                    return;
                }
                Literal matchLit = newBinding.get((AtomDObject)this.atom.getAllArguments().get(0));
                if (matchLit != null) {
                    this.match = ATermUtils.getLiteralValue(matchLit.getTerm());
                }
                String splittingString = ATermUtils.getLiteralValue(newBinding.get((AtomDObject)this.atom.getAllArguments().get(1)).getTerm());
                String splittingPattern = ATermUtils.getLiteralValue(newBinding.get((AtomDObject)this.atom.getAllArguments().get(2)).getTerm());
                String[] splits = splittingString.split(splittingPattern);
                this.tokens = Arrays.asList(splits).iterator();
                if (this.match != null) {
                    while (this.tokens.hasNext()) {
                        String token = this.tokens.next();
                        if (!token.equals(this.match)) continue;
                        this.tokens = Collections.singleton(token).iterator();
                        break;
                    }
                }
            }

            @Override
            public boolean selectNextBinding() {
                if (this.tokens != null && this.tokens.hasNext()) {
                    this.match = this.tokens.next();
                    return true;
                }
                return false;
            }

            @Override
            public void setCurrentBinding(VariableBinding currentBinding) {
                if (VariableUtils.isVariable(this.head)) {
                    ATermAppl resultTerm = ATermUtils.makePlainLiteral(this.match);
                    Literal resultLit = currentBinding.getABox().addLiteral(resultTerm);
                    currentBinding.set(this.head, resultLit);
                }
            }
        }
    }

    private static class SubStringBefore
    implements StringToStringFunction {
        private SubStringBefore() {
        }

        public String apply(String ... args) {
            if (args.length != 2) {
                return null;
            }
            if (args[1].equals("")) {
                return "";
            }
            int index = args[0].indexOf(args[1]);
            if (index < 0) {
                return "";
            }
            return args[0].substring(0, index);
        }
    }

    private static class SubStringAfter
    implements StringToStringFunction {
        private SubStringAfter() {
        }

        public String apply(String ... args) {
            if (args.length != 2) {
                return null;
            }
            if (args[1].equals("")) {
                return "";
            }
            int index = args[0].indexOf(args[1]);
            if (index < 0) {
                return "";
            }
            return args[0].substring(index + args[1].length());
        }
    }

    private static class SubString
    implements StringToStringFunction {
        private SubString() {
        }

        public String apply(String ... args) {
            if (args.length < 2 || args.length > 3) {
                return null;
            }
            long beginIndex = 0L;
            long endIndex = args[0].length();
            try {
                Double beginDouble = new Double(args[1]);
                long begin = beginDouble.isNaN() || beginDouble > 2.147483647E9 ? Integer.MAX_VALUE : Math.round(beginDouble);
                long count = Integer.MAX_VALUE;
                if (args.length == 3) {
                    Double countDouble = new Double(args[2]);
                    count = countDouble.isNaN() || countDouble < 0.0 ? 0L : Math.round(countDouble);
                }
                beginIndex = Math.min((long)args[0].length(), Math.max(0L, begin - 1L));
                endIndex = Math.min((long)args[0].length(), Math.max(beginIndex, begin + count - 1L));
            }
            catch (NumberFormatException e) {
                return "";
            }
            if (beginIndex > Integer.MAX_VALUE) {
                beginIndex = Integer.MAX_VALUE;
            }
            if (endIndex > Integer.MAX_VALUE) {
                endIndex = Integer.MAX_VALUE;
            }
            return args[0].substring((int)beginIndex, (int)endIndex);
        }
    }

    private static class StringLength
    implements Function {
        private StringLength() {
        }

        public Literal apply(ABox abox, Literal expected, Literal ... args) {
            if (args.length != 1) {
                return null;
            }
            String val = ATermUtils.getLiteralValue(args[0].getTerm());
            String length = Integer.toString(val.length());
            Literal result = abox.addLiteral(ATermUtils.makeTypedLiteral(length, "http://www.w3.org/2001/XMLSchema#integer"));
            return ComparisonTesters.expectedIfEquals(expected, result);
        }
    }

    private static class StringEqualIgnoreCase
    extends BinaryTester {
        private StringEqualIgnoreCase() {
        }

        protected boolean test(Literal l1, Literal l2) {
            ATermAppl l1name = l1.getName();
            ATermAppl l2name = l2.getName();
            String l1str = ATermUtils.getLiteralValue(l1name);
            String l2str = ATermUtils.getLiteralValue(l2name);
            return l1str.equalsIgnoreCase(l2str);
        }
    }

    private static class StringConcat
    implements StringToStringFunction {
        private StringConcat() {
        }

        public String apply(String ... args) {
            StringBuffer resultBuffer = new StringBuffer();
            for (String arg : args) {
                resultBuffer.append(arg);
            }
            return resultBuffer.toString();
        }
    }

    private static class StartsWith
    extends BinaryTester {
        private StartsWith() {
        }

        protected boolean test(Literal l1, Literal l2) {
            ATermAppl l1name = l1.getTerm();
            ATermAppl l2name = l2.getTerm();
            String l1str = ATermUtils.getLiteralValue(l1name);
            String l2str = ATermUtils.getLiteralValue(l2name);
            return l1str.startsWith(l2str);
        }
    }

    private static class Replace
    implements StringToStringFunction {
        private Replace() {
        }

        public String apply(String ... args) {
            if (args.length != 3) {
                return null;
            }
            String from = args[1];
            String to = args[2];
            return args[0].replace(from, to);
        }
    }

    private static class NormalizeSpace
    implements StringToStringFunction {
        private NormalizeSpace() {
        }

        public String apply(String ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0].trim().replaceAll("\\s+", " ");
        }
    }

    private static class Matches
    extends BinaryTester {
        private Matches() {
        }

        protected boolean test(Literal l1, Literal l2) {
            ATermAppl l1name = l1.getTerm();
            ATermAppl l2name = l2.getTerm();
            String l1str = ATermUtils.getLiteralValue(l1name);
            String l2str = ATermUtils.getLiteralValue(l2name);
            boolean result = false;
            try {
                result = Pattern.matches(l2str, l1str);
            }
            catch (PatternSyntaxException e) {
                ABox.log.info("Bad regex from builtin rule: " + l2);
            }
            return result;
        }
    }

    private static class LowerCase
    implements StringToStringFunction {
        private LowerCase() {
        }

        public String apply(String ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0].toLowerCase();
        }
    }

    private static class EndsWith
    extends BinaryTester {
        private EndsWith() {
        }

        protected boolean test(Literal l1, Literal l2) {
            ATermAppl l1name = l1.getTerm();
            ATermAppl l2name = l2.getTerm();
            String l1str = ATermUtils.getLiteralValue(l1name);
            String l2str = ATermUtils.getLiteralValue(l2name);
            return l1str.endsWith(l2str);
        }
    }

    private static class ContainsIgnoreCase
    extends BinaryTester {
        private ContainsIgnoreCase() {
        }

        protected boolean test(Literal l1, Literal l2) {
            ATermAppl l1name = l1.getTerm();
            ATermAppl l2name = l2.getTerm();
            String l1str = ATermUtils.getLiteralValue(l1name).toLowerCase();
            String l2str = ATermUtils.getLiteralValue(l2name).toLowerCase();
            return l1str.contains(l2str);
        }
    }

    private static class Contains
    extends BinaryTester {
        private Contains() {
        }

        protected boolean test(Literal l1, Literal l2) {
            ATermAppl l1name = l1.getTerm();
            ATermAppl l2name = l2.getTerm();
            String l1str = ATermUtils.getLiteralValue(l1name);
            String l2str = ATermUtils.getLiteralValue(l2name);
            return l1str.contains(l2str);
        }
    }
}

