/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import com.clarkparsia.pellet.sparqldl.engine.QueryCost;
import com.clarkparsia.pellet.sparqldl.engine.QueryPlan;
import com.clarkparsia.pellet.sparqldl.engine.QuerySizeEstimator;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.SetUtils;

public class IncrementalQueryPlan
extends QueryPlan {
    private static final Logger log = Logger.getLogger(IncrementalQueryPlan.class.getName());
    public final Stack<Integer> explored;
    private final List<QueryAtom> atoms;
    private int size;
    private QueryCost cost;

    public IncrementalQueryPlan(Query query) {
        super(query);
        QuerySizeEstimator.computeSizeEstimate(query);
        this.explored = new Stack();
        this.atoms = query.getAtoms();
        this.size = this.atoms.size();
        this.cost = new QueryCost(query.getKB());
        this.reset();
    }

    public QueryAtom next(ResultBinding binding) {
        int best = -1;
        QueryAtom bestAtom = null;
        double bestCost = Double.POSITIVE_INFINITY;
        block0: for (int i = 0; i < this.size; ++i) {
            if (this.explored.contains(i)) continue;
            QueryAtom atom = this.atoms.get(i);
            QueryAtom atom2 = atom.apply(binding);
            if (atom2.getPredicate().equals((Object)QueryPredicate.NotKnown) && !atom2.isGround()) {
                for (int j = 0; j < this.atoms.size(); ++j) {
                    QueryAtom nextAtom;
                    if (i == j || this.explored.contains(j) || !SetUtils.intersects((nextAtom = this.atoms.get(j)).getArguments(), atom2.getArguments())) continue;
                    if (!log.isLoggable(Level.FINE)) continue block0;
                    log.fine("Unbound vars for not");
                    continue block0;
                }
            }
            double atomCost = this.cost.estimate(atom2);
            if (log.isLoggable(Level.FINER)) {
                log.finer("Atom=" + atom + ", cost=" + this.cost + ", best cost=" + bestCost);
            }
            if (!(atomCost <= bestCost)) continue;
            bestCost = atomCost;
            bestAtom = atom2;
            best = i;
        }
        if (best == -1) {
            throw new InternalReasonerException("Cannot find a valid atom in " + this.atoms + " where explored=" + this.explored);
        }
        this.explored.add(best);
        if (log.isLoggable(Level.FINER)) {
            StringBuffer indent = new StringBuffer();
            for (int j = 0; j < this.explored.size(); ++j) {
                indent.append(" ");
            }
            String treePrint = indent.toString() + bestAtom + " : " + bestCost;
            log.finer(treePrint);
        }
        return bestAtom;
    }

    public boolean hasNext() {
        return this.explored.size() < this.size;
    }

    public void back() {
        this.explored.pop();
    }

    public void reset() {
        this.explored.clear();
    }
}

