/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.model.Core;
import com.clarkparsia.pellet.sparqldl.model.NotKnownQueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.UnionQueryAtom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.KBOperation;
import org.mindswap.pellet.utils.SizeEstimate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryCost {
    private double staticCost;
    private double branchCount;
    private KnowledgeBase kb;
    private SizeEstimate estimate;

    public QueryCost(KnowledgeBase kb) {
        this.kb = kb;
        this.estimate = kb.getSizeEstimate();
    }

    public double estimate(List<QueryAtom> atoms) {
        return this.estimate(atoms, new HashSet<ATermAppl>());
    }

    public double estimate(List<QueryAtom> atoms, Collection<ATermAppl> bound) {
        QueryAtom atom;
        int i;
        double totalStaticCount = 1.0;
        double totalBranchCount = 1.0;
        this.branchCount = 1.0;
        this.staticCost = 1.0;
        int n = atoms.size();
        HashSet<ATermAppl> lastBound = new HashSet<ATermAppl>(bound);
        ArrayList<HashSet<ATermAppl>> boundList = new ArrayList<HashSet<ATermAppl>>(n);
        for (i = 0; i < n; ++i) {
            atom = atoms.get(i);
            boundList.add(lastBound);
            lastBound = new HashSet<ATermAppl>(lastBound);
            lastBound.addAll(atom.getArguments());
        }
        for (i = n - 1; i >= 0; --i) {
            atom = atoms.get(i);
            this.estimate(atom, (Collection<ATermAppl>)((Collection)boundList.get(i)));
            totalBranchCount *= this.branchCount;
            totalStaticCount = this.staticCost + this.branchCount * totalStaticCount;
        }
        this.staticCost = totalStaticCount;
        this.branchCount = totalBranchCount;
        return this.staticCost;
    }

    public double estimate(QueryAtom atom) {
        return this.estimate(atom, new HashSet<ATermAppl>());
    }

    public double estimate(QueryAtom atom, Collection<ATermAppl> bound) {
        boolean direct = false;
        boolean strict = false;
        List<ATermAppl> arguments = atom.getArguments();
        for (ATermAppl a : arguments) {
            if (!this.isConstant(a)) continue;
            bound.add(a);
        }
        block0 : switch (atom.getPredicate()) {
            case DirectType: {
                direct = true;
            }
            case Type: {
                ATermAppl instance = arguments.get(0);
                ATermAppl clazz = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this.staticCost = direct ? (double)this.estimate.getCost(KBOperation.IS_DIRECT_TYPE) : (double)this.estimate.getCost(KBOperation.IS_TYPE);
                    this.branchCount = 1.0;
                    break;
                }
                if (bound.contains(clazz)) {
                    this.staticCost = direct ? (double)this.estimate.getCost(KBOperation.GET_DIRECT_INSTANCES) : (double)this.estimate.getCost(KBOperation.GET_INSTANCES);
                    this.branchCount = this.isConstant(clazz) ? (double)this.estimate.size(clazz) : this.estimate.avgInstancesPerClass(direct);
                    break;
                }
                if (bound.contains(instance)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_TYPES);
                    this.branchCount = this.isConstant(instance) ? (double)this.estimate.classesPerInstance(instance, direct) : this.estimate.avgClassesPerInstance(direct);
                    break;
                }
                this.staticCost = (long)this.estimate.getClassCount() * (direct ? this.estimate.getCost(KBOperation.GET_DIRECT_INSTANCES) : this.estimate.getCost(KBOperation.GET_INSTANCES));
                this.branchCount = (double)this.estimate.getClassCount() * this.estimate.avgInstancesPerClass(direct);
                break;
            }
            case Annotation: 
            case PropertyValue: {
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.HAS_PROPERTY_VALUE);
                    this.branchCount = 1.0;
                    break;
                }
                ATermAppl subject = arguments.get(0);
                ATermAppl predicate = arguments.get(1);
                ATermAppl object = arguments.get(2);
                if (bound.contains(predicate)) {
                    if (bound.contains(subject)) {
                        this.staticCost = this.estimate.getCost(KBOperation.GET_PROPERTY_VALUE);
                        this.branchCount = this.isConstant(predicate) ? this.estimate.avg(predicate) : this.estimate.avgSubjectsPerProperty();
                        break;
                    }
                    if (bound.contains(object)) {
                        this.staticCost = this.estimate.getCost(KBOperation.GET_PROPERTY_VALUE);
                        if (this.isConstant(predicate)) {
                            if (this.kb.isObjectProperty((ATerm)predicate)) {
                                this.branchCount = this.estimate.avg(this.inv(predicate));
                                break;
                            }
                            this.branchCount = this.estimate.avgSubjectsPerProperty();
                            break;
                        }
                        this.branchCount = this.estimate.avgSubjectsPerProperty();
                        break;
                    }
                    this.staticCost = (double)this.estimate.getCost(KBOperation.GET_PROPERTY_VALUE) + (this.isConstant(predicate) ? this.estimate.avg(predicate) : this.estimate.avgSubjectsPerProperty()) * (double)this.estimate.getCost(KBOperation.GET_PROPERTY_VALUE);
                    this.branchCount = this.isConstant(predicate) ? (double)this.estimate.size(predicate) : this.estimate.avgPairsPerProperty();
                    break;
                }
                if (bound.contains(subject) || bound.contains(object)) {
                    this.staticCost = (long)this.estimate.getPropertyCount() * this.estimate.getCost(KBOperation.GET_PROPERTY_VALUE);
                    this.branchCount = (double)this.estimate.getPropertyCount() * this.estimate.avgSubjectsPerProperty();
                    break;
                }
                this.staticCost = (double)this.estimate.getPropertyCount() * ((double)this.estimate.getCost(KBOperation.GET_PROPERTY_VALUE) + this.estimate.avgSubjectsPerProperty() * (double)this.estimate.getCost(KBOperation.GET_PROPERTY_VALUE));
                this.branchCount = this.estimate.avgPairsPerProperty() * (double)this.estimate.getPropertyCount();
                break;
            }
            case SameAs: {
                ATermAppl saLHS = arguments.get(0);
                ATermAppl saRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_SAME_AS);
                    this.branchCount = 1.0;
                    break;
                }
                if (bound.contains(saLHS) || bound.contains(saRHS)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_SAMES);
                    if (bound.contains(saLHS)) {
                        this.branchCount = this.isConstant(saLHS) ? this.estimate.sames(saLHS) : this.estimate.avgSamesPerInstance();
                        break;
                    }
                    this.branchCount = this.isConstant(saRHS) ? this.estimate.sames(saRHS) : this.estimate.avgSamesPerInstance();
                    break;
                }
                this.staticCost = (long)this.estimate.getInstanceCount() * this.estimate.getCost(KBOperation.GET_SAMES);
                this.branchCount = (double)this.estimate.getInstanceCount() * this.estimate.avgSamesPerInstance();
                break;
            }
            case DifferentFrom: {
                ATermAppl dfLHS = arguments.get(0);
                ATermAppl dfRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_DIFFERENT_FROM);
                    this.branchCount = 1.0;
                    break;
                }
                if (bound.contains(dfLHS) || bound.contains(dfRHS)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_DIFFERENTS);
                    if (bound.contains(dfLHS)) {
                        this.branchCount = this.isConstant(dfLHS) ? this.estimate.differents(dfLHS) : this.estimate.avgDifferentsPerInstance();
                        break;
                    }
                    this.branchCount = this.isConstant(dfRHS) ? this.estimate.differents(dfRHS) : this.estimate.avgDifferentsPerInstance();
                    break;
                }
                this.staticCost = (long)this.estimate.getInstanceCount() * this.estimate.getCost(KBOperation.GET_DIFFERENTS);
                this.branchCount = (double)this.estimate.getInstanceCount() * this.estimate.avgDifferentsPerInstance();
                break;
            }
            case DirectSubClassOf: {
                direct = true;
            }
            case StrictSubClassOf: {
                strict = true;
            }
            case SubClassOf: {
                ATermAppl clazzLHS = arguments.get(0);
                ATermAppl clazzRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this.staticCost = strict ? (direct ? (double)this.estimate.getCost(KBOperation.GET_DIRECT_SUB_OR_SUPERCLASSES) : (double)(this.estimate.getCost(KBOperation.IS_SUBCLASS_OF) + this.estimate.getCost(KBOperation.GET_EQUIVALENT_CLASSES))) : (double)this.estimate.getCost(KBOperation.IS_SUBCLASS_OF);
                    this.branchCount = 1.0;
                    break;
                }
                if (bound.contains(clazzLHS) || bound.contains(clazzRHS)) {
                    if (strict && !direct) {
                        this.staticCost = this.estimate.getCost(KBOperation.GET_SUB_OR_SUPERCLASSES) + this.estimate.getCost(KBOperation.GET_EQUIVALENT_CLASSES);
                    } else {
                        double d = this.staticCost = direct ? (double)this.estimate.getCost(KBOperation.GET_DIRECT_SUB_OR_SUPERCLASSES) : (double)this.estimate.getCost(KBOperation.GET_SUB_OR_SUPERCLASSES);
                    }
                    if (bound.contains(clazzLHS)) {
                        double d = this.branchCount = this.isConstant(clazzLHS) ? this.estimate.superClasses(clazzLHS, direct) : this.estimate.avgSuperClasses(direct);
                        if (!strict) break;
                        this.branchCount -= this.isConstant(clazzLHS) ? this.estimate.equivClasses(clazzLHS) : this.estimate.avgEquivClasses();
                        this.branchCount = Math.max(this.branchCount, 0.0);
                        break;
                    }
                    double d = this.branchCount = this.isConstant(clazzRHS) ? this.estimate.superClasses(clazzRHS, direct) : this.estimate.avgSuperClasses(direct);
                    if (!strict) break;
                    this.branchCount -= this.isConstant(clazzRHS) ? this.estimate.equivClasses(clazzRHS) : this.estimate.avgEquivClasses();
                    this.branchCount = Math.max(this.branchCount, 0.0);
                    break;
                }
                this.staticCost = strict && !direct ? (double)(this.estimate.getCost(KBOperation.GET_SUB_OR_SUPERCLASSES) + this.estimate.getCost(KBOperation.GET_EQUIVALENT_CLASSES)) : (direct ? (double)this.estimate.getCost(KBOperation.GET_DIRECT_SUB_OR_SUPERCLASSES) : (double)this.estimate.getCost(KBOperation.GET_SUB_OR_SUPERCLASSES));
                this.staticCost *= (double)this.estimate.getClassCount();
                this.branchCount = (double)this.estimate.getClassCount() * this.estimate.avgSubClasses(direct);
                if (!strict) break;
                this.branchCount -= this.estimate.avgEquivClasses();
                this.branchCount = Math.max(this.branchCount, 0.0);
                break;
            }
            case EquivalentClass: {
                ATermAppl eqcLHS = arguments.get(0);
                ATermAppl eqcRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_EQUIVALENT_CLASS);
                    this.branchCount = 1.0;
                    break;
                }
                if (bound.contains(eqcLHS) || bound.contains(eqcRHS)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_EQUIVALENT_CLASSES);
                    if (bound.contains(eqcLHS)) {
                        this.branchCount = this.isConstant(eqcLHS) ? this.estimate.equivClasses(eqcLHS) : this.estimate.avgEquivClasses();
                        break;
                    }
                    this.branchCount = this.isConstant(eqcRHS) ? this.estimate.equivClasses(eqcRHS) : this.estimate.avgEquivClasses();
                    break;
                }
                this.staticCost = (long)this.estimate.getClassCount() * this.estimate.getCost(KBOperation.GET_EQUIVALENT_CLASSES);
                this.branchCount = (double)this.estimate.getClassCount() * this.estimate.avgEquivClasses();
                break;
            }
            case DisjointWith: {
                ATermAppl dwLHS = arguments.get(0);
                ATermAppl dwRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_DISJOINT_WITH);
                    this.branchCount = 1.0;
                    break;
                }
                if (bound.contains(dwLHS) || bound.contains(dwRHS)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_DISJOINT_CLASSES);
                    if (bound.contains(dwLHS)) {
                        this.branchCount = this.isConstant(dwLHS) ? this.estimate.disjoints(dwLHS) : this.estimate.avgDisjointClasses();
                        break;
                    }
                    this.branchCount = this.isConstant(dwRHS) ? this.estimate.disjoints(dwRHS) : this.estimate.avgDisjointClasses();
                    break;
                }
                this.staticCost = (long)this.estimate.getClassCount() * this.estimate.getCost(KBOperation.GET_DISJOINT_CLASSES);
                this.branchCount = (double)this.estimate.getClassCount() * this.estimate.avgDisjointClasses();
                break;
            }
            case ComplementOf: {
                ATermAppl coLHS = arguments.get(0);
                ATermAppl coRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_COMPLEMENT_OF);
                    this.branchCount = 1.0;
                    break;
                }
                if (bound.contains(coLHS) || bound.contains(coRHS)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_COMPLEMENT_CLASSES);
                    if (bound.contains(coLHS)) {
                        this.branchCount = this.isConstant(coLHS) ? this.estimate.complements(coLHS) : this.estimate.avgComplementClasses();
                        break;
                    }
                    this.branchCount = this.isConstant(coRHS) ? this.estimate.complements(coRHS) : this.estimate.avgComplementClasses();
                    break;
                }
                this.staticCost = (long)this.estimate.getClassCount() * this.estimate.getCost(KBOperation.GET_COMPLEMENT_CLASSES);
                this.branchCount = (double)this.estimate.getClassCount() * this.estimate.avgComplementClasses();
                break;
            }
            case DirectSubPropertyOf: {
                direct = true;
            }
            case StrictSubPropertyOf: {
                strict = true;
            }
            case SubPropertyOf: {
                ATermAppl spLHS = arguments.get(0);
                ATermAppl spRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this.staticCost = strict ? (direct ? (double)this.estimate.getCost(KBOperation.GET_DIRECT_SUB_OR_SUPERPROPERTIES) : (double)(this.estimate.getCost(KBOperation.IS_SUBPROPERTY_OF) + this.estimate.getCost(KBOperation.GET_EQUIVALENT_PROPERTIES))) : (double)this.estimate.getCost(KBOperation.IS_SUBPROPERTY_OF);
                    this.branchCount = 1.0;
                    break;
                }
                if (bound.contains(spLHS) || bound.contains(spRHS)) {
                    if (strict && !direct) {
                        this.staticCost = this.estimate.getCost(KBOperation.GET_SUB_OR_SUPERPROPERTIES) + this.estimate.getCost(KBOperation.GET_EQUIVALENT_PROPERTIES);
                    } else {
                        double d = this.staticCost = direct ? (double)this.estimate.getCost(KBOperation.GET_DIRECT_SUB_OR_SUPERPROPERTIES) : (double)this.estimate.getCost(KBOperation.GET_SUB_OR_SUPERPROPERTIES);
                    }
                    if (bound.contains(spLHS)) {
                        double d = this.branchCount = this.isConstant(spLHS) ? this.estimate.superProperties(spLHS, direct) : this.estimate.avgSuperProperties(direct);
                        if (!strict) break;
                        this.branchCount -= this.isConstant(spLHS) ? this.estimate.equivProperties(spLHS) : this.estimate.avgEquivProperties();
                        this.branchCount = Math.max(this.branchCount, 0.0);
                        break;
                    }
                    double d = this.branchCount = this.isConstant(spRHS) ? this.estimate.superProperties(spRHS, direct) : this.estimate.avgSuperProperties(direct);
                    if (!strict) break;
                    this.branchCount -= this.isConstant(spRHS) ? this.estimate.equivProperties(spRHS) : this.estimate.avgEquivProperties();
                    this.branchCount = Math.max(this.branchCount, 0.0);
                    break;
                }
                this.staticCost = strict && !direct ? (double)(this.estimate.getCost(KBOperation.GET_SUB_OR_SUPERPROPERTIES) + this.estimate.getCost(KBOperation.GET_EQUIVALENT_PROPERTIES)) : (direct ? (double)this.estimate.getCost(KBOperation.GET_DIRECT_SUB_OR_SUPERPROPERTIES) : (double)this.estimate.getCost(KBOperation.GET_SUB_OR_SUPERPROPERTIES));
                this.staticCost *= (double)this.estimate.getPropertyCount();
                this.branchCount = (double)this.estimate.getPropertyCount() * this.estimate.avgSubProperties(direct);
                if (!strict) break;
                this.branchCount -= this.estimate.avgEquivProperties();
                this.branchCount = Math.max(this.branchCount, 0.0);
                break;
            }
            case EquivalentProperty: {
                ATermAppl eqpLHS = arguments.get(0);
                ATermAppl eqpRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_EQUIVALENT_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                if (bound.contains(eqpLHS) || bound.contains(eqpRHS)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_EQUIVALENT_PROPERTIES);
                    if (bound.contains(eqpLHS)) {
                        this.branchCount = this.isConstant(eqpLHS) ? this.estimate.equivProperties(eqpLHS) : this.estimate.avgEquivProperties();
                        break;
                    }
                    this.branchCount = this.isConstant(eqpRHS) ? this.estimate.equivProperties(eqpRHS) : this.estimate.avgEquivProperties();
                    break;
                }
                this.staticCost = (long)this.estimate.getPropertyCount() * this.estimate.getCost(KBOperation.GET_EQUIVALENT_PROPERTIES);
                this.branchCount = (double)this.estimate.getPropertyCount() * this.estimate.avgEquivProperties();
                break;
            }
            case Domain: {
                ATermAppl domLHS = arguments.get(0);
                ATermAppl domRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_DOMAIN);
                    this.branchCount = 1.0;
                    break;
                }
                if (bound.contains(domLHS) || bound.contains(domRHS)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_DOMAINS);
                    if (bound.contains(domLHS)) {
                        this.branchCount = this.isConstant(domLHS) ? this.estimate.equivProperties(domLHS) : this.estimate.avgEquivProperties();
                        break;
                    }
                    this.branchCount = this.isConstant(domRHS) ? this.estimate.equivClasses(domRHS) : this.estimate.avgEquivClasses();
                    break;
                }
                this.staticCost = (long)this.estimate.getPropertyCount() * this.estimate.getCost(KBOperation.GET_DOMAINS);
                this.branchCount = (double)this.estimate.getPropertyCount() * this.estimate.avgEquivProperties();
                break;
            }
            case Range: {
                ATermAppl rangeLHS = arguments.get(0);
                ATermAppl rangeRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_RANGE);
                    this.branchCount = 1.0;
                    break;
                }
                if (bound.contains(rangeLHS) || bound.contains(rangeRHS)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_RANGES);
                    if (bound.contains(rangeLHS)) {
                        this.branchCount = this.isConstant(rangeLHS) ? this.estimate.equivProperties(rangeLHS) : this.estimate.avgEquivProperties();
                        break;
                    }
                    this.branchCount = this.isConstant(rangeRHS) ? this.estimate.equivClasses(rangeRHS) : this.estimate.avgEquivClasses();
                    break;
                }
                this.staticCost = (long)this.estimate.getPropertyCount() * this.estimate.getCost(KBOperation.GET_RANGES);
                this.branchCount = (double)this.estimate.getPropertyCount() * this.estimate.avgEquivProperties();
                break;
            }
            case InverseOf: {
                ATermAppl ioLHS = arguments.get(0);
                ATermAppl ioRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_INVERSE_OF);
                    this.branchCount = 1.0;
                    break;
                }
                if (bound.contains(ioLHS) || bound.contains(ioRHS)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_INVERSES);
                    if (bound.contains(ioLHS)) {
                        this.branchCount = this.isConstant(ioLHS) ? this.estimate.inverses(ioLHS) : this.estimate.avgInverseProperties();
                        break;
                    }
                    this.branchCount = this.isConstant(ioRHS) ? this.estimate.inverses(ioRHS) : this.estimate.avgInverseProperties();
                    break;
                }
                this.staticCost = (long)this.estimate.getPropertyCount() * this.estimate.getCost(KBOperation.GET_INVERSES);
                this.branchCount = (double)this.estimate.getPropertyCount() * this.estimate.avgInverseProperties();
                break;
            }
            case ObjectProperty: {
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_OBJECT_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                this.staticCost = this.estimate.getCost(KBOperation.GET_OBJECT_PROPERTIES);
                this.branchCount = this.estimate.getObjectPropertyCount();
                break;
            }
            case DatatypeProperty: {
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_DATATYPE_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                this.staticCost = this.estimate.getCost(KBOperation.GET_DATATYPE_PROPERTIES);
                this.branchCount = this.estimate.getDataPropertyCount();
                break;
            }
            case Functional: {
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_FUNCTIONAL_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                this.staticCost = this.estimate.getCost(KBOperation.GET_FUNCTIONAL_PROPERTIES);
                this.branchCount = this.estimate.getFunctionalPropertyCount();
                break;
            }
            case InverseFunctional: {
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_INVERSE_FUNCTIONAL_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                this.staticCost = this.estimate.getCost(KBOperation.GET_INVERSE_FUNCTIONAL_PROPERTIES);
                this.branchCount = this.estimate.getInverseFunctionalPropertyCount();
                break;
            }
            case Transitive: {
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_TRANSITIVE_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                this.staticCost = this.estimate.getCost(KBOperation.GET_TRANSITIVE_PROPERTIES);
                this.branchCount = this.estimate.getTransitivePropertyCount();
                break;
            }
            case Symmetric: {
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_SYMMETRIC_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                this.staticCost = this.estimate.getCost(KBOperation.GET_SYMMETRIC_PROPERTIES);
                this.branchCount = this.estimate.getSymmetricPropertyCount();
                break;
            }
            case Asymmetric: {
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_ASYMMETRIC_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                this.staticCost = this.estimate.getCost(KBOperation.GET_ASYMMETRIC_PROPERTIES);
                this.branchCount = this.estimate.getSymmetricPropertyCount();
                break;
            }
            case Reflexive: {
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_REFLEXIVE_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                this.staticCost = this.estimate.getCost(KBOperation.GET_REFLEXIVE_PROPERTIES);
                this.branchCount = this.estimate.getSymmetricPropertyCount();
                break;
            }
            case Irreflexive: {
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_IRREFLEXIVE_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                this.staticCost = this.estimate.getCost(KBOperation.GET_IRREFLEXIVE_PROPERTIES);
                this.branchCount = this.estimate.getSymmetricPropertyCount();
                break;
            }
            case NotKnown: {
                this.estimate(((NotKnownQueryAtom)atom).getAtoms(), bound);
                break;
            }
            case Union: {
                double totalStaticCount = 1.0;
                double totalBranchCount = 1.0;
                for (List<QueryAtom> atoms : ((UnionQueryAtom)atom).getUnion()) {
                    this.estimate(atoms, bound);
                    totalBranchCount += this.branchCount;
                    totalStaticCount += this.staticCost;
                }
                this.staticCost = totalStaticCount;
                this.branchCount = totalBranchCount;
                break;
            }
            case UndistVarCore: {
                double b;
                if (bound.containsAll(arguments)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_TYPE);
                    this.branchCount = 1.0;
                    break;
                }
                Core core = (Core)atom;
                int n = core.getDistVars().size();
                this.branchCount = b = Math.pow(this.estimate.avgInstancesPerClass(false), n);
                switch (QueryEngine.getStrategy(atom)) {
                    case ALLFAST: 
                    case SIMPLE: {
                        this.staticCost = (double)((long)n * this.estimate.getCost(KBOperation.GET_INSTANCES)) + b * (double)this.estimate.getCost(KBOperation.IS_TYPE);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Not yet implemented.");
            }
            case Datatype: {
                this.staticCost = 1.0;
                this.branchCount = 1.0;
                break;
            }
            default: {
                throw new UnsupportedFeatureException("Unknown atom type " + (Object)((Object)atom.getPredicate()) + ".");
            }
        }
        return this.staticCost;
    }

    public double getBranchCount() {
        return this.branchCount;
    }

    public double getStaticCost() {
        return this.staticCost;
    }

    private ATermAppl inv(ATermAppl pred) {
        return this.kb.getRBox().getRole((ATerm)pred).getInverse().getName();
    }

    private boolean isConstant(ATermAppl a) {
        return !ATermUtils.isVar(a);
    }
}

