/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.utils;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityHashSet<T>
extends AbstractSet<T>
implements Set<T>,
Cloneable {
    private static final Object VALUE = new Object();
    private transient IdentityHashMap<T, Object> map;

    public IdentityHashSet() {
        this.map = new IdentityHashMap();
    }

    public IdentityHashSet(Collection<? extends T> c) {
        this.map = new IdentityHashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public IdentityHashSet(int size) {
        this.map = new IdentityHashMap(size);
    }

    @Override
    public boolean add(T element) {
        return this.map.put(element, VALUE) == null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            IdentityHashSet newSet = (IdentityHashSet)super.clone();
            newSet.map = (IdentityHashMap)this.map.clone();
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean remove(Object element) {
        return this.map.remove(element) != VALUE;
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

