/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeList
implements Iterable<Edge> {
    private List<Edge> list;

    public EdgeList() {
        this.list = new ArrayList<Edge>();
    }

    public EdgeList(int size) {
        this.list = new ArrayList<Edge>(size);
    }

    public EdgeList(EdgeList edges) {
        this.list = new ArrayList<Edge>(edges.list);
    }

    public EdgeList(List<Edge> edges) {
        this.list = edges;
    }

    public EdgeList(Edge edge) {
        this.list = Collections.singletonList(edge);
    }

    public void addEdgeList(EdgeList edges) {
        if (edges == null) {
            return;
        }
        this.list.addAll(edges.list);
    }

    public void addEdge(Edge e) {
        this.list.add(e);
    }

    public EdgeList unmodifiable() {
        return new EdgeList(Collections.unmodifiableList(this.list));
    }

    public boolean removeEdge(Edge edge) {
        return this.list.remove(edge);
    }

    public Edge edgeAt(int i) {
        return this.list.get(i);
    }

    public int size() {
        return this.list.size();
    }

    public EdgeList sort() {
        EdgeList sorted = new EdgeList(this);
        Collections.sort(sorted.list, new Comparator<Edge>(){

            @Override
            public int compare(Edge e1, Edge e2) {
                return e1.getDepends().max() - e2.getDepends().max();
            }
        });
        return sorted;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<Edge> iterator() {
        return this.list.iterator();
    }

    private EdgeList findEdges(Role role, Individual from, Node to) {
        EdgeList result = new EdgeList();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge e = this.list.get(i);
            if (from != null && !from.equals(e.getFrom()) || role != null && !e.getRole().isSubRoleOf(role) || to != null && !to.equals(e.getTo())) continue;
            result.addEdge(e);
        }
        return result;
    }

    public EdgeList getEdgesFromTo(Individual from, Node to) {
        return this.findEdges(null, from, to);
    }

    public EdgeList getEdgesFrom(Individual from) {
        return this.findEdges(null, from, null);
    }

    public EdgeList getEdgesTo(Node to) {
        return this.findEdges(null, null, to);
    }

    public EdgeList getEdges(Role role) {
        EdgeList result = new EdgeList();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge e = this.list.get(i);
            if (!e.getRole().isSubRoleOf(role)) continue;
            result.addEdge(e);
        }
        return result;
    }

    public EdgeList getEdgesContaining(Node node) {
        EdgeList result = new EdgeList();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge e = this.list.get(i);
            if (!e.getFrom().equals(node) && !e.getTo().equals(node)) continue;
            result.addEdge(e);
        }
        return result;
    }

    public Set<Role> getRoles() {
        HashSet<Role> result = new HashSet<Role>();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge edge = this.list.get(i);
            result.add(edge.getRole());
        }
        return result;
    }

    public Set<ATermAppl> getNeighborNames(Individual node) {
        HashSet<ATermAppl> result = new HashSet<ATermAppl>();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge edge = this.list.get(i);
            result.add(edge.getNeighbor(node).getName());
        }
        return result;
    }

    public EdgeList getEdges(Role role, Node node) {
        EdgeList result = new EdgeList();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge e = this.list.get(i);
            if (!e.getRole().isSubRoleOf(role) || !e.getTo().equals(node) && !e.getFrom().equals(node)) continue;
            result.addEdge(e);
        }
        return result;
    }

    public Set<Node> getNeighbors(Node node) {
        HashSet<Node> result = new HashSet<Node>();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge edge = this.list.get(i);
            result.add(edge.getNeighbor(node));
        }
        return result;
    }

    public Set<Node> getFilteredNeighbors(Individual node, ATermAppl c) {
        HashSet<Node> result = new HashSet<Node>();
        String lang = null;
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge edge = this.list.get(i);
            Node neighbor = edge.getNeighbor(node);
            if (!ATermUtils.isTop(c) && !neighbor.hasType((ATerm)c)) continue;
            if (neighbor instanceof Literal) {
                Literal lit = (Literal)neighbor;
                if (lang == null) {
                    lang = lit.getLang();
                    result.add(neighbor);
                    continue;
                }
                if (!lang.equals(lit.getLang())) continue;
                result.add(neighbor);
                continue;
            }
            result.add(neighbor);
        }
        return result;
    }

    public boolean hasEdgeFrom(Individual from) {
        return this.hasEdge(from, null, null);
    }

    public boolean hasEdgeFrom(Individual from, Role role) {
        return this.hasEdge(from, role, null);
    }

    public boolean hasEdgeTo(Node to) {
        return this.hasEdge(null, null, to);
    }

    public boolean hasEdgeTo(Role role, Node to) {
        return this.hasEdge(null, role, to);
    }

    public boolean hasEdge(Role role) {
        return this.hasEdge(null, role, null);
    }

    public boolean hasEdge(Individual from, Role role, Node to) {
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge e = this.list.get(i);
            if (from != null && !from.equals(e.getFrom()) || role != null && !e.getRole().isSubRoleOf(role) || to != null && !to.equals(e.getTo())) continue;
            return true;
        }
        return false;
    }

    public boolean hasExactEdge(Individual from, Role role, Node to) {
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge e = this.list.get(i);
            if (from != null && !from.equals(e.getFrom()) || role != null && !e.getRole().equals(role) || to != null && !to.equals(e.getTo())) continue;
            return true;
        }
        return false;
    }

    public boolean hasEdge(Edge e) {
        return this.hasEdge(e.getFrom(), e.getRole(), e.getTo());
    }

    public Edge getExactEdge(Individual from, Role role, Node to) {
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge e = this.list.get(i);
            if (from != null && !from.equals(e.getFrom()) || role != null && !e.getRole().equals(role) || to != null && !to.equals(e.getTo())) continue;
            return e;
        }
        return null;
    }

    public DependencySet getDepends(boolean doExplanation) {
        DependencySet ds = DependencySet.INDEPENDENT;
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge e = this.list.get(i);
            ds = ds.union(e.getDepends(), doExplanation);
        }
        return ds;
    }

    public String toString() {
        return this.list.toString();
    }

    public void reset() {
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            Edge e = this.list.get(i);
            if (e.getDepends().getBranch() == DependencySet.NO_BRANCH) continue;
            Collections.swap(this.list, i--, --size);
        }
        this.list.subList(size, this.list.size()).clear();
    }
}

