/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.exceptions.DatatypeReasonerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DefaultEdge;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.cache.CachedNode;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.queue.QueueElement;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Individual
extends Node
implements CachedNode {
    private EdgeList outEdges;
    private ArrayList<ATermAppl>[] types = new ArrayList[7];
    public int[] applyNext = new int[7];
    private int nominalLevel;
    private Individual parent;
    private boolean modifiedAfterMerge = false;

    Individual(ATermAppl name, ABox abox, Individual parent) {
        super(name, abox);
        this.parent = parent;
        this.nominalLevel = parent == null ? 0 : Integer.MAX_VALUE;
        for (int i = 0; i < 7; ++i) {
            this.types[i] = new ArrayList();
            this.applyNext[i] = 0;
        }
        this.outEdges = new EdgeList();
    }

    Individual(Individual ind, ABox abox) {
        super(ind, abox);
        this.nominalLevel = ind.nominalLevel;
        this.parent = ind.parent;
        for (int i = 0; i < 7; ++i) {
            this.types[i] = new ArrayList<ATermAppl>(ind.types[i]);
            this.applyNext[i] = ind.applyNext[i];
        }
        this.outEdges = this.isPruned() ? ind.outEdges.unmodifiable() : new EdgeList(ind.outEdges.size());
    }

    @Override
    public DependencySet getNodeDepends() {
        return this.getDepends((ATerm)ATermUtils.TOP);
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public boolean isIndividual() {
        return true;
    }

    @Override
    public boolean isNominal() {
        return this.nominalLevel != Integer.MAX_VALUE;
    }

    @Override
    public boolean isBlockable() {
        return this.nominalLevel == Integer.MAX_VALUE;
    }

    @Override
    public boolean isIndependent() {
        return true;
    }

    public void setNominalLevel(int level) {
        this.nominalLevel = level;
        if (this.nominalLevel != Integer.MAX_VALUE) {
            this.parent = null;
        }
    }

    @Override
    public int getNominalLevel() {
        return this.nominalLevel;
    }

    @Override
    public ATermAppl getTerm() {
        return this.name;
    }

    @Override
    public Node copyTo(ABox abox) {
        return new Individual(this, abox);
    }

    public List<ATermAppl> getTypes(int type) {
        return this.types[type];
    }

    @Override
    public boolean isDifferent(Node node) {
        if (PelletOptions.USE_UNIQUE_NAME_ASSUMPTION && this.isNamedIndividual() && node.isNamedIndividual()) {
            return !this.name.equals(node.name);
        }
        return this.differents.containsKey(node);
    }

    @Override
    public Set<Node> getDifferents() {
        return this.differents.keySet();
    }

    @Override
    public DependencySet getDifferenceDependency(Node node) {
        if (PelletOptions.USE_UNIQUE_NAME_ASSUMPTION && this.isNamedIndividual() && node.isNamedIndividual()) {
            return DependencySet.INDEPENDENT;
        }
        return (DependencySet)this.differents.get(node);
    }

    public void getObviousTypes(List<ATermAppl> types, List<ATermAppl> nonTypes) {
        for (ATermAppl c : this.getTypes(0)) {
            if (!this.getDepends((ATerm)c).isIndependent()) continue;
            if (ATermUtils.isPrimitive(c)) {
                types.add(c);
                continue;
            }
            if (!ATermUtils.isNegatedPrimitive(c)) continue;
            nonTypes.add((ATermAppl)c.getArgument(0));
        }
    }

    public boolean canApply(int type) {
        return this.applyNext[type] < this.types[type].size();
    }

    @Override
    public void addType(ATermAppl c, DependencySet ds) {
        this.addType(c, ds, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addType(ATermAppl c, DependencySet ds, boolean checkForPruned) {
        if (checkForPruned) {
            if (this.isPruned()) {
                throw new InternalReasonerException("Adding type to a pruned node " + this + " " + c);
            }
            if (this.isMerged()) {
                return;
            }
        } else if (this.isMerged()) {
            this.modifiedAfterMerge = true;
        }
        if (this.depends.containsKey(c)) {
            if (checkForPruned || !ds.isIndependent()) return;
            this.depends.put(c, ds);
            return;
        }
        int b = this.abox.getBranch();
        int max = ds.max();
        if (b == -1 && max != 0) {
            b = max + 1;
        }
        ds = ds.copy(b);
        this.depends.put(c, ds);
        this.abox.setChanged(true);
        if (this.abox.getBranch() >= 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), this.getName());
        }
        QueueElement qElement = new QueueElement(this, c);
        ATermAppl notC = ATermUtils.negate(c);
        DependencySet clashDepends = (DependencySet)this.depends.get(notC);
        if (clashDepends != null) {
            ATermAppl positive = ATermUtils.isNot(notC) ? c : notC;
            clashDepends = clashDepends.union(ds, this.abox.doExplanation());
            clashDepends = clashDepends.copy(this.abox.getBranch());
            this.abox.setClash(Clash.atomic(this, clashDepends, positive));
        }
        if (ATermUtils.isPrimitive(c)) {
            this.setChanged(0);
            this.types[0].add(c);
            if (!PelletOptions.USE_COMPLETION_QUEUE) return;
            this.abox.getCompletionQueue().add(qElement, NodeSelector.ATOM);
            return;
        } else if (c.getAFun().equals(ATermUtils.ANDFUN)) {
            ATermList cs = (ATermList)c.getArgument(0);
            while (!cs.isEmpty()) {
                ATermAppl conj = (ATermAppl)cs.getFirst();
                this.addType(conj, ds, checkForPruned);
                cs = cs.getNext();
            }
            return;
        } else if (c.getAFun().equals(ATermUtils.ALLFUN)) {
            this.setChanged(3);
            this.types[3].add(c);
            if (!PelletOptions.USE_COMPLETION_QUEUE) return;
            this.abox.getCompletionQueue().add(qElement, NodeSelector.UNIVERSAL);
            return;
        } else if (c.getAFun().equals(ATermUtils.MINFUN)) {
            if (this.isRedundantMin(c)) return;
            this.types[4].add(c);
            this.setChanged(4);
            if (PelletOptions.USE_COMPLETION_QUEUE) {
                this.abox.getCompletionQueue().add(qElement, NodeSelector.MIN_NUMBER);
            }
            this.checkMinClash(c, ds);
            return;
        } else if (c.getAFun().equals(ATermUtils.NOTFUN)) {
            ATermAppl x = (ATermAppl)c.getArgument(0);
            if (ATermUtils.isAnd(x)) {
                this.setChanged(1);
                this.types[1].add(c);
                if (!PelletOptions.USE_COMPLETION_QUEUE) return;
                this.abox.getCompletionQueue().add(qElement, NodeSelector.DISJUNCTION);
                return;
            } else if (ATermUtils.isAllValues(x)) {
                this.setChanged(2);
                this.types[2].add(c);
                if (!PelletOptions.USE_COMPLETION_QUEUE) return;
                this.abox.getCompletionQueue().add(qElement, NodeSelector.EXISTENTIAL);
                return;
            } else if (ATermUtils.isMin(x)) {
                if (this.isRedundantMax(x)) return;
                this.types[5].add(c);
                this.setChanged(5);
                if (PelletOptions.USE_COMPLETION_QUEUE) {
                    this.abox.getCompletionQueue().add(qElement, NodeSelector.MAX_NUMBER);
                    this.abox.getCompletionQueue().add(qElement, NodeSelector.CHOOSE);
                    this.abox.getCompletionQueue().add(qElement, NodeSelector.GUESS);
                }
                this.checkMaxClash(c, ds);
                return;
            } else if (ATermUtils.isNominal(x)) {
                this.setChanged(0);
                this.types[0].add(c);
                if (!PelletOptions.USE_COMPLETION_QUEUE) return;
                this.abox.getCompletionQueue().add(qElement, NodeSelector.ATOM);
                return;
            } else if (ATermUtils.isSelf(x)) {
                EdgeList selfEdges;
                ATermAppl p = (ATermAppl)x.getArgument(0);
                Role role = this.abox.getRole((ATerm)p);
                if (role == null || (selfEdges = this.outEdges.getEdges(role).getEdgesTo(this)).isEmpty()) return;
                this.abox.setClash(Clash.unexplained(this, selfEdges.getDepends(this.abox.doExplanation())));
                return;
            } else {
                if (x.getArity() != 0) throw new InternalReasonerException("Invalid type " + c + " for individual " + this.name);
                this.setChanged(0);
                this.types[0].add(c);
                if (!PelletOptions.USE_COMPLETION_QUEUE) return;
                this.abox.getCompletionQueue().add(qElement, NodeSelector.ATOM);
            }
            return;
        } else if (c.getAFun().equals(ATermUtils.VALUEFUN)) {
            this.setChanged(6);
            this.types[6].add(c);
            if (!PelletOptions.USE_COMPLETION_QUEUE) return;
            this.abox.getCompletionQueue().add(qElement, NodeSelector.NOMINAL);
            return;
        } else {
            if (!ATermUtils.isSelf(c)) throw new InternalReasonerException("Warning: Adding invalid class constructor - " + c);
            this.setChanged(0);
            this.types[0].add(c);
        }
    }

    public boolean checkMinClash(ATermAppl minCard, DependencySet minDepends) {
        Role minR = this.abox.getRole(minCard.getArgument(0));
        if (minR == null) {
            return false;
        }
        int min = ((ATermInt)minCard.getArgument(1)).getInt();
        ATermAppl minC = (ATermAppl)minCard.getArgument(2);
        if (minR.isFunctional() && min > 1) {
            this.abox.setClash(Clash.minMax(this, minDepends.union(minR.getExplainFunctional(), this.abox.doExplanation())));
            return true;
        }
        for (ATermAppl mc : this.types[5]) {
            ATermAppl maxCard = (ATermAppl)mc.getArgument(0);
            Role maxR = this.abox.getRole(maxCard.getArgument(0));
            if (maxR == null) {
                return false;
            }
            int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
            ATermAppl maxC = (ATermAppl)maxCard.getArgument(2);
            if (max >= min || !minC.equals(maxC) || !minR.isSubRoleOf(maxR)) continue;
            DependencySet maxDepends = this.getDepends((ATerm)mc);
            DependencySet subDepends = maxR.getExplainSub((ATerm)minR.getName());
            DependencySet ds = minDepends.union(maxDepends, this.abox.doExplanation()).union(subDepends, this.abox.doExplanation());
            this.abox.setClash(Clash.minMax(this, ds));
            return true;
        }
        return false;
    }

    public boolean checkMaxClash(ATermAppl normalizedMax, DependencySet maxDepends) {
        ATermAppl maxCard = (ATermAppl)normalizedMax.getArgument(0);
        Role maxR = this.abox.getRole(maxCard.getArgument(0));
        if (maxR == null) {
            return false;
        }
        int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
        ATermAppl maxC = (ATermAppl)maxCard.getArgument(2);
        for (ATermAppl minCard : this.types[4]) {
            Role minR = this.abox.getRole(minCard.getArgument(0));
            if (minR == null) {
                return false;
            }
            int min = ((ATermInt)minCard.getArgument(1)).getInt();
            ATermAppl minC = (ATermAppl)minCard.getArgument(2);
            if (max >= min || !minC.equals(maxC) || !minR.isSubRoleOf(maxR)) continue;
            DependencySet minDepends = this.getDepends((ATerm)minCard);
            DependencySet subDepends = maxR.getExplainSub((ATerm)minR.getName());
            DependencySet ds = minDepends.union(maxDepends, this.abox.doExplanation()).union(subDepends, this.abox.doExplanation());
            this.abox.setClash(Clash.minMax(this, ds));
            return true;
        }
        return false;
    }

    public boolean isRedundantMin(ATermAppl minCard) {
        Role minR = this.abox.getRole(minCard.getArgument(0));
        if (minR == null) {
            return false;
        }
        int min = ((ATermInt)minCard.getArgument(1)).getInt();
        ATermAppl minQ = (ATermAppl)minCard.getArgument(2);
        for (ATermAppl prevMinCard : this.types[4]) {
            Role prevMinR = this.abox.getRole(prevMinCard.getArgument(0));
            if (prevMinR == null) continue;
            int prevMin = ((ATermInt)prevMinCard.getArgument(1)).getInt() - 1;
            ATermAppl prevMinQ = (ATermAppl)prevMinCard.getArgument(2);
            if (min > prevMin || !prevMinR.isSubRoleOf(minR) || !minQ.equals(prevMinQ) && !ATermUtils.isTop(minQ)) continue;
            return true;
        }
        return false;
    }

    public boolean isRedundantMax(ATermAppl maxCard) {
        Role maxR = this.abox.getRole(maxCard.getArgument(0));
        if (maxR == null) {
            return false;
        }
        int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
        if (max == 1 && maxR != null && maxR.isFunctional()) {
            return true;
        }
        ATermAppl maxQ = (ATermAppl)maxCard.getArgument(2);
        for (ATermAppl mc : this.types[5]) {
            ATermAppl prevMaxCard = (ATermAppl)mc.getArgument(0);
            Role prevMaxR = this.abox.getRole(prevMaxCard.getArgument(0));
            if (prevMaxR == null) continue;
            int prevMax = ((ATermInt)prevMaxCard.getArgument(1)).getInt() - 1;
            ATermAppl prevMaxQ = (ATermAppl)prevMaxCard.getArgument(2);
            if (max < prevMax || !maxR.isSubRoleOf(prevMaxR) || !maxQ.equals(prevMaxQ) && !ATermUtils.isTop(prevMaxQ)) continue;
            return true;
        }
        return false;
    }

    public DependencySet hasMax1(Role r) {
        for (ATermAppl mc : this.types[5]) {
            ATermAppl maxCard = (ATermAppl)mc.getArgument(0);
            Role maxR = this.abox.getRole(maxCard.getArgument(0));
            int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
            ATermAppl maxQ = (ATermAppl)maxCard.getArgument(2);
            if (max != 1 || !r.isSubRoleOf(maxR) || !ATermUtils.isTop(maxQ)) continue;
            return this.getDepends((ATerm)mc).union(r.getExplainSub((ATerm)maxR.getName()), this.abox.doExplanation());
        }
        return null;
    }

    public int getMaxCard(Role r) {
        int min = Integer.MAX_VALUE;
        for (ATermAppl mc : this.types[5]) {
            ATermAppl maxCard = (ATermAppl)mc.getArgument(0);
            Role maxR = this.abox.getRole(maxCard.getArgument(0));
            int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
            if (!r.isSubRoleOf(maxR) || max >= min) continue;
            min = max;
        }
        if (r.isFunctional() && min > 1) {
            min = 1;
        }
        return min;
    }

    public int getMinCard(Role r) {
        int max = 0;
        for (ATermAppl minCard : this.types[4]) {
            Role minR = this.abox.getRole(minCard.getArgument(0));
            int min = ((ATermInt)minCard.getArgument(1)).getInt();
            if (!minR.isSubRoleOf(r) || max >= min) continue;
            max = min;
        }
        return max;
    }

    @Override
    public void removeType(ATermAppl c) {
        this.depends.remove(c);
        if (ATermUtils.isPrimitive(c) || ATermUtils.isSelf(c)) {
            this.types[0].remove(c);
        } else if (!c.getAFun().equals(ATermUtils.ANDFUN)) {
            if (c.getAFun().equals(ATermUtils.ALLFUN)) {
                this.types[3].remove(c);
            } else if (c.getAFun().equals(ATermUtils.MINFUN)) {
                this.types[4].remove(c);
            } else if (c.getAFun().equals(ATermUtils.NOTFUN)) {
                ATermAppl x = (ATermAppl)c.getArgument(0);
                if (ATermUtils.isAnd(x)) {
                    this.types[1].remove(c);
                } else if (ATermUtils.isAllValues(x)) {
                    this.types[2].remove(c);
                } else if (ATermUtils.isMin(x)) {
                    this.types[5].remove(c);
                } else if (ATermUtils.isNominal(x)) {
                    this.types[0].remove(c);
                } else if (x.getArity() == 0) {
                    this.types[0].remove(c);
                } else if (!ATermUtils.isSelf(x)) {
                    throw new InternalReasonerException("Invalid type " + c + " for individual " + this.name);
                }
            } else if (c.getAFun().equals(ATermUtils.VALUEFUN)) {
                this.types[6].remove(c);
            } else {
                throw new RuntimeException("Invalid concept " + c);
            }
        }
    }

    @Override
    public final boolean isLeaf() {
        return !this.isRoot() && this.outEdges.isEmpty();
    }

    @Override
    public final Individual getSame() {
        return (Individual)super.getSame();
    }

    public final Set<Node> getRSuccessors(Role r, ATermAppl c) {
        HashSet<Node> result = new HashSet<Node>();
        EdgeList edges = this.outEdges.getEdges(r);
        int n = edges.size();
        for (int i = 0; i < n; ++i) {
            Edge edge = edges.edgeAt(i);
            Node other = edge.getNeighbor(this);
            if (!other.hasType((ATerm)c)) continue;
            result.add(other);
        }
        return result;
    }

    public final Set<Node> getRSuccessors(Role r) {
        return this.outEdges.getEdges(r).getNeighbors(this);
    }

    public final EdgeList getRSuccessorEdges(Role r) {
        return this.outEdges.getEdges(r);
    }

    public final EdgeList getRPredecessorEdges(Role r) {
        return this.inEdges.getEdges(r);
    }

    public final Set<ATermAppl> getRNeighborNames(Role r) {
        return this.getRNeighborEdges(r).getNeighborNames(this);
    }

    public final Set<Node> getRNeighbors(Role r) {
        return this.getRNeighborEdges(r).getNeighbors(this);
    }

    public EdgeList getRNeighborEdges(Role r) {
        EdgeList neighbors = this.outEdges.getEdges(r);
        if (r == null) {
            throw new NullPointerException();
        }
        Role invR = r.getInverse();
        if (invR != null) {
            neighbors.addEdgeList(this.inEdges.getEdges(invR));
        }
        return neighbors;
    }

    public EdgeList getRNeighborEdges(Role r, Node node) {
        EdgeList neighbors = this.outEdges.getEdges(r, node);
        if (r == null) {
            throw new NullPointerException();
        }
        Role invR = r.getInverse();
        if (invR != null) {
            neighbors.addEdgeList(this.inEdges.getEdges(invR, node));
        }
        return neighbors;
    }

    public EdgeList getEdgesTo(Node x) {
        return this.outEdges.getEdgesTo(x);
    }

    public EdgeList getEdgesTo(Node x, Role r) {
        return this.outEdges.getEdgesTo(x).getEdges(r);
    }

    public DependencySet hasDistinctRNeighborsForMax(Role r, int n, ATermAppl c) {
        boolean hasNeighbors = false;
        EdgeList edges = this.getRNeighborEdges(r);
        if (edges.size() >= n) {
            ArrayList allDisjointSets = new ArrayList();
            block0: for (int i = 0; i < edges.size(); ++i) {
                Node y = edges.edgeAt(i).getNeighbor(this);
                if (!y.hasType((ATerm)c)) continue;
                boolean added = false;
                for (int j = 0; j < allDisjointSets.size(); ++j) {
                    Node z;
                    int k;
                    List disjointSet = (List)allDisjointSets.get(j);
                    for (k = 0; k < disjointSet.size() && y.isDifferent(z = (Node)disjointSet.get(k)); ++k) {
                    }
                    if (k != disjointSet.size()) continue;
                    added = true;
                    disjointSet.add(y);
                    if (disjointSet.size() < n) continue;
                    hasNeighbors = true;
                    break block0;
                }
                if (added) continue;
                ArrayList<Node> singletonSet = new ArrayList<Node>();
                singletonSet.add(y);
                allDisjointSets.add(singletonSet);
                if (n != 1) continue;
                hasNeighbors = true;
                break;
            }
        }
        if (!hasNeighbors) {
            return null;
        }
        DependencySet ds = DependencySet.EMPTY;
        for (Edge edge : edges) {
            ds = ds.union(r.getExplainSubOrInv(edge.getRole()), this.abox.doExplanation());
            ds = ds.union(edge.getDepends(), this.abox.doExplanation());
            Node node = edge.getNeighbor(this);
            DependencySet typeDS = node.getDepends((ATerm)c);
            if (typeDS == null) continue;
            ds = ds.union(typeDS, this.abox.doExplanation());
        }
        return ds;
    }

    public boolean hasDistinctRNeighborsForMin(Role r, int n, ATermAppl c) {
        return this.hasDistinctRNeighborsForMin(r, n, c, false);
    }

    public boolean hasDistinctRNeighborsForMin(Role r, int n, ATermAppl c, boolean onlyNominals) {
        EdgeList edges = this.getRNeighborEdges(r);
        if (n == 1 && !onlyNominals && c.equals(ATermUtils.TOP)) {
            return !edges.isEmpty();
        }
        if (edges.size() < n) {
            return false;
        }
        ArrayList allDisjointSets = new ArrayList();
        for (int i = 0; i < edges.size(); ++i) {
            Node y = edges.edgeAt(i).getNeighbor(this);
            if (!y.hasType((ATerm)c)) continue;
            if (onlyNominals) {
                if (y.isBlockable()) continue;
                if (n == 1) {
                    return true;
                }
            }
            boolean added = false;
            for (int j = 0; j < allDisjointSets.size(); ++j) {
                boolean addToThis = true;
                List disjointSet = (List)allDisjointSets.get(j);
                for (int k = 0; k < disjointSet.size(); ++k) {
                    Node z = (Node)disjointSet.get(k);
                    if (y.isDifferent(z)) continue;
                    addToThis = false;
                    break;
                }
                if (!addToThis) continue;
                added = true;
                disjointSet.add(y);
                if (disjointSet.size() < n) continue;
                return true;
            }
            if (!added) {
                ArrayList<Node> singletonSet = new ArrayList<Node>();
                singletonSet.add(y);
                allDisjointSets.add(singletonSet);
            }
            if (n != 1 || allDisjointSets.size() < 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean hasRNeighbor(Role r) {
        if (this.outEdges.hasEdge(r)) {
            return true;
        }
        Role invR = r.getInverse();
        return invR != null && this.inEdges.hasEdge(invR);
    }

    public boolean hasRSuccessor(Role r) {
        return this.outEdges.hasEdge(r);
    }

    @Override
    public boolean hasSuccessor(Node x) {
        return this.outEdges.hasEdgeTo(x);
    }

    public final boolean hasRSuccessor(Role r, Node x) {
        return this.outEdges.hasEdge(this, r, x);
    }

    public Bool hasDataPropertyValue(Role r, Object value) {
        Bool hasValue = Bool.FALSE;
        EdgeList edges = this.outEdges.getEdges(r);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            DependencySet ds = edge.getDepends();
            Literal literal = (Literal)edge.getTo();
            Object literalValue = literal.getValue();
            if (value != null && literalValue == null) {
                try {
                    if (this.abox.dtReasoner.isSatisfiable(literal.getTypes(), value)) {
                        hasValue = Bool.UNKNOWN;
                        continue;
                    }
                    hasValue = Bool.FALSE;
                    continue;
                }
                catch (DatatypeReasonerException e) {
                    String msg = "Unexpected datatype reasoner exception while checking property value: " + e.getMessage();
                    log.severe(msg);
                    throw new InternalReasonerException(msg);
                }
            }
            if (value != null && !value.equals(literalValue)) continue;
            if (ds.isIndependent()) {
                return Bool.TRUE;
            }
            hasValue = Bool.UNKNOWN;
        }
        return hasValue;
    }

    public boolean hasRNeighbor(Role r, Node x) {
        if (this.hasRSuccessor(r, x)) {
            return true;
        }
        if (x instanceof Individual) {
            return ((Individual)x).hasRSuccessor(r.getInverse(), this);
        }
        return false;
    }

    @Override
    protected void addInEdge(Edge edge) {
        this.setChanged(3);
        this.setChanged(5);
        this.applyNext[5] = 0;
        ATermAppl p = edge.getRole().getInverse().getName();
        if (p.equals(ATermUtils.BOTTOM_DATA_PROPERTY) || p.equals(ATermUtils.BOTTOM_OBJECT_PROPERTY)) {
            this.abox.setClash(Clash.bottomProperty(edge.getFrom(), edge.getDepends(), p));
        } else {
            this.inEdges.addEdge(edge);
        }
    }

    protected void addOutEdge(Edge edge) {
        this.setChanged(3);
        this.setChanged(5);
        this.applyNext[5] = 0;
        ATermAppl p = edge.getRole().getName();
        if (p.equals(ATermUtils.BOTTOM_DATA_PROPERTY) || p.equals(ATermUtils.BOTTOM_OBJECT_PROPERTY)) {
            this.abox.setClash(Clash.bottomProperty(edge.getFrom(), edge.getDepends(), p));
        } else {
            this.outEdges.addEdge(edge);
        }
    }

    public Edge addEdge(Role r, Node x, DependencySet ds) {
        if (this.abox.getBranch() > 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), this.getName());
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), x.getName());
        }
        if (r.getName().equals(ATermUtils.BOTTOM_DATA_PROPERTY) || r.getName().equals(ATermUtils.BOTTOM_OBJECT_PROPERTY)) {
            this.abox.setClash(Clash.bottomProperty(this, ds, r.getName()));
            return null;
        }
        if (this.hasRSuccessor(r, x) || r.getName().equals(ATermUtils.TOP_OBJECT_PROPERTY) || r.getName().equals(ATermUtils.TOP_DATA_PROPERTY)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("EDGE: " + this + " -> " + r + " -> " + x + ": " + ds + " " + this.getRNeighborEdges(r).getEdgesContaining(x));
            }
            return null;
        }
        if (this.isPruned()) {
            throw new InternalReasonerException("Adding edge to a pruned node " + this + " " + r + " " + x);
        }
        if (this.isMerged()) {
            return null;
        }
        this.abox.setChanged(true);
        this.setChanged(3);
        this.setChanged(5);
        this.applyNext[5] = 0;
        ds = ds.copy(this.abox.getBranch());
        DefaultEdge edge = new DefaultEdge(r, this, x, ds);
        this.outEdges.addEdge(edge);
        x.addInEdge(edge);
        return edge;
    }

    @Override
    public final EdgeList getOutEdges() {
        return this.outEdges;
    }

    public Individual getParent() {
        return this.parent;
    }

    @Override
    public void reset(boolean onlyApplyTypes) {
        super.reset(onlyApplyTypes);
        for (int i = 0; i < 7; ++i) {
            this.applyNext[i] = 0;
        }
        if (onlyApplyTypes) {
            return;
        }
        this.outEdges.reset();
    }

    @Override
    protected void resetTypes() {
        for (int type = 0; type < 7; ++type) {
            ArrayList<ATermAppl> list = this.types[type];
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                ATermAppl c = list.get(i);
                if (((DependencySet)this.depends.get(c)).getBranch() == DependencySet.NO_BRANCH) continue;
                Collections.swap(list, i--, --size);
                this.depends.remove(c);
            }
            if (size >= list.size()) continue;
            list.subList(size, list.size()).clear();
        }
        Iterator i = this.depends.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (((DependencySet)e.getValue()).getBranch() == DependencySet.NO_BRANCH) continue;
            i.remove();
        }
    }

    @Override
    public boolean restore(int branch) {
        Boolean restorePruned = this.restorePruned(branch);
        if (Boolean.FALSE.equals(restorePruned)) {
            return restorePruned;
        }
        boolean restored = Boolean.TRUE.equals(restorePruned);
        restored |= super.restore(branch);
        for (int i = 0; i < 7; ++i) {
            this.applyNext[i] = 0;
        }
        boolean removed = false;
        Iterator<Edge> i = this.outEdges.iterator();
        while (i.hasNext()) {
            Edge e = i.next();
            DependencySet d = e.getDepends();
            if (d.getBranch() <= branch) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("RESTORE: " + this.name + " remove edge " + e + " " + d.max() + " " + branch);
            }
            i.remove();
            restored = true;
            removed = true;
            if (!PelletOptions.USE_INCREMENTAL_CONSISTENCY) continue;
            this.abox.getIncrementalChangeTracker().addDeletedEdge(e);
        }
        if (removed && PelletOptions.USE_COMPLETION_QUEUE) {
            this.abox.getCompletionQueue().add(new QueueElement(this), NodeSelector.EXISTENTIAL);
            this.abox.getCompletionQueue().add(new QueueElement(this), NodeSelector.MIN_NUMBER);
        }
        if (this.modifiedAfterMerge && restored) {
            for (Map.Entry entry : this.depends.entrySet()) {
                ATermAppl c = (ATermAppl)entry.getKey();
                ATermAppl notC = ATermUtils.negate(c);
                DependencySet ds = (DependencySet)this.depends.get(notC);
                if (ds == null) continue;
                DependencySet clashDepends = (DependencySet)entry.getValue();
                ATermAppl positive = ATermUtils.isNot(notC) ? c : notC;
                clashDepends = clashDepends.union(ds, this.abox.doExplanation());
                this.abox.setClash(Clash.atomic(this, clashDepends, positive));
            }
            this.modifiedAfterMerge = false;
        }
        return restored;
    }

    public final boolean removeEdge(Edge edge) {
        boolean removed = this.outEdges.removeEdge(edge);
        if (!removed) {
            throw new InternalReasonerException("Trying to remove a non-existing edge " + edge);
        }
        return true;
    }

    @Override
    public void prune(DependencySet ds) {
        if (this.abox.getBranch() >= 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), this.getName());
        }
        this.pruned = ds;
        for (int i = 0; i < this.outEdges.size(); ++i) {
            Edge edge = this.outEdges.edgeAt(i);
            Node succ = edge.getTo();
            if (succ.equals(this)) continue;
            if (succ.isNominal()) {
                succ.removeInEdge(edge);
                continue;
            }
            succ.prune(ds);
        }
    }

    @Override
    public void unprune(int branch) {
        super.unprune(branch);
        boolean added = false;
        for (int i = 0; i < this.outEdges.size(); ++i) {
            Edge edge = this.outEdges.edgeAt(i);
            DependencySet d = edge.getDepends();
            if (d.getBranch() > branch) continue;
            Node succ = edge.getTo();
            Role role = edge.getRole();
            if (succ.inEdges.hasExactEdge(this, role, succ)) continue;
            succ.addInEdge(edge);
            if (PelletOptions.TRACK_BRANCH_EFFECTS) {
                this.abox.getBranchEffectTracker().add(d.getBranch(), succ.name);
                this.abox.getBranchEffectTracker().add(d.getBranch(), this.name);
            }
            if (!PelletOptions.USE_COMPLETION_QUEUE) continue;
            added = true;
            if (!(succ instanceof Individual)) continue;
            Individual succInd = (Individual)succ;
            succInd.applyNext[5] = 0;
            QueueElement qe = new QueueElement(succInd);
            this.abox.getCompletionQueue().add(qe, NodeSelector.MAX_NUMBER);
            this.abox.getCompletionQueue().add(qe, NodeSelector.GUESS);
            this.abox.getCompletionQueue().add(qe, NodeSelector.CHOOSE);
        }
        if (added) {
            this.applyNext[5] = 0;
            QueueElement qe = new QueueElement(this);
            this.abox.getCompletionQueue().add(qe, NodeSelector.MAX_NUMBER);
            this.abox.getCompletionQueue().add(qe, NodeSelector.GUESS);
            this.abox.getCompletionQueue().add(qe, NodeSelector.CHOOSE);
        }
    }

    public String debugString() {
        return this.name.getName() + " = " + this.types[0] + this.types[3] + this.types[2] + this.types[1] + this.types[4] + this.types[5] + this.types[6] + "; **" + this.outEdges + "**" + "; **" + this.inEdges + "**" + " --> " + this.depends + "";
    }

    @Override
    protected void updateNodeReferences() {
        super.updateNodeReferences();
        if (this.parent != null) {
            this.parent = this.abox.getIndividual((ATerm)this.parent.getName());
        }
        if (this.isPruned()) {
            EdgeList oldEdges = this.outEdges;
            this.outEdges = new EdgeList(oldEdges.size());
            for (int i = 0; i < oldEdges.size(); ++i) {
                Edge edge = oldEdges.edgeAt(i);
                Node to = this.abox.getNode((ATerm)edge.getTo().getName());
                DefaultEdge newEdge = new DefaultEdge(edge.getRole(), this, to, edge.getDepends());
                this.outEdges.addEdge(newEdge);
            }
        }
    }

    @Override
    public boolean isBottom() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public boolean isTop() {
        return false;
    }
}

